/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector;

import io.milvus.exception.ParamException;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.Status;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.response.DescCollResponseWrapper;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.RpcUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorService
extends BaseService {
    Logger logger = LoggerFactory.getLogger(VectorService.class);
    public CollectionService collectionService = new CollectionService();
    public IndexService indexService = new IndexService();
    private ConcurrentHashMap<String, DescribeCollectionResponse> cacheCollectionInfo = new ConcurrentHashMap();

    private DescribeCollectionResponse getCollectionInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String databaseName, String collectionName) {
        String key = this.combineCacheKey(databaseName, collectionName);
        DescribeCollectionResponse info = this.cacheCollectionInfo.get(key);
        if (info == null) {
            String msg = String.format("Fail to describe collection '%s'", collectionName);
            DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(collectionName);
            if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                builder.setDbName(databaseName);
                msg = String.format("Fail to describe collection '%s' in database '%s'", collectionName, databaseName);
            }
            DescribeCollectionRequest describeCollectionRequest = builder.build();
            DescribeCollectionResponse response = blockingStub.describeCollection(describeCollectionRequest);
            new RpcUtils().handleResponse(msg, response.getStatus());
            info = response;
            this.cacheCollectionInfo.put(key, info);
        }
        return info;
    }

    private String combineCacheKey(String databaseName, String collectionName) {
        if (collectionName == null || StringUtils.isBlank((CharSequence)collectionName)) {
            throw new ParamException("Collection name is empty, not able to get collection info.");
        }
        String key = collectionName;
        if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
            key = String.format("%s|%s", databaseName, collectionName);
        }
        return key;
    }

    private void cleanCacheIfFailed(Status status, String databaseName, String collectionName) {
        if (status.getCode() != 0 && status.getCode() != 8 || !status.getErrorCode().equals((Object)ErrorCode.Success) && status.getErrorCode() != ErrorCode.RateLimit) {
            this.cacheCollectionInfo.remove(this.combineCacheKey(databaseName, collectionName));
        }
    }

    public InsertResp insert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, InsertReq request) {
        String title = String.format("InsertRequest collectionName:%s", request.getCollectionName());
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, "", request.getCollectionName());
        MutationResult response = blockingStub.insert(this.dataUtils.convertGrpcInsertRequest(request, new DescCollResponseWrapper(descResp)));
        this.cleanCacheIfFailed(response.getStatus(), "", request.getCollectionName());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((InsertResp.InsertRespBuilder)InsertResp.builder().InsertCnt(response.getInsertCnt())).build();
    }

    public UpsertResp upsert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpsertReq request) {
        String title = String.format("UpsertRequest collectionName:%s", request.getCollectionName());
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, "", request.getCollectionName());
        MutationResult response = blockingStub.upsert(this.dataUtils.convertGrpcUpsertRequest(request, new DescCollResponseWrapper(descResp)));
        this.cleanCacheIfFailed(response.getStatus(), "", request.getCollectionName());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((UpsertResp.UpsertRespBuilder)UpsertResp.builder().upsertCnt(response.getInsertCnt())).build();
    }

    public QueryResp query(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryReq request) {
        String title = String.format("QueryRequest collectionName:%s", request.getCollectionName());
        if (request.getFilter() == null && request.getIds() == null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be null at the same time");
        }
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        DescribeCollectionResp descR = this.collectionService.describeCollection(blockingStub, (DescribeCollectionReq)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().collectionName(request.getCollectionName())).build());
        if (request.getIds() != null && request.getFilter() == null) {
            request.setFilter(this.vectorUtils.getExprById(descR.getPrimaryFieldName(), request.getIds()));
        }
        QueryResults response = blockingStub.query(this.vectorUtils.ConvertToGrpcQueryRequest(request));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((QueryResp.QueryRespBuilder)QueryResp.builder().queryResults(this.convertUtils.getEntities(response))).build();
    }

    public SearchResp search(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchReq request) {
        String title = String.format("SearchRequest collectionName:%s", request.getCollectionName());
        SearchRequest searchRequest = this.vectorUtils.ConvertToGrpcSearchRequest(request);
        SearchResults response = blockingStub.search(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((SearchResp.SearchRespBuilder)SearchResp.builder().searchResults(this.convertUtils.getEntities(response))).build();
    }

    public QueryIterator queryIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryIteratorReq request) {
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, "", request.getCollectionName());
        DescribeCollectionResp respR = CollectionService.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new QueryIterator(request, blockingStub, pkField);
    }

    public SearchIterator searchIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchIteratorReq request) {
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, "", request.getCollectionName());
        DescribeCollectionResp respR = CollectionService.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new SearchIterator(request, blockingStub, pkField);
    }

    public DeleteResp delete(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DeleteReq request) {
        String title = String.format("DeleteRequest collectionName:%s", request.getCollectionName());
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, "", request.getCollectionName());
        DescribeCollectionResp respR = CollectionService.convertDescCollectionResp(descResp);
        if (request.getFilter() == null) {
            request.setFilter(this.vectorUtils.getExprById(respR.getPrimaryFieldName(), request.getIds()));
        }
        DeleteRequest deleteRequest = DeleteRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).setExpr(request.getFilter()).build();
        MutationResult response = blockingStub.delete(deleteRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((DeleteResp.DeleteRespBuilder)DeleteResp.builder().deleteCnt(response.getDeleteCnt())).build();
    }

    public GetResp get(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetReq request) {
        String title = String.format("GetRequest collectionName:%s", request.getCollectionName());
        this.logger.debug(title);
        Object queryReq = ((QueryReq.QueryReqBuilder)((QueryReq.QueryReqBuilder)QueryReq.builder().collectionName(request.getCollectionName())).ids(request.getIds())).build();
        if (request.getOutputFields() != null) {
            ((QueryReq)queryReq).setOutputFields(request.getOutputFields());
        }
        QueryResp queryResp = this.query(blockingStub, (QueryReq)queryReq);
        return ((GetResp.GetRespBuilder)GetResp.builder().getResults(queryResp.getQueryResults())).build();
    }
}

