/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response.basic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.QueryResultsWrapper;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RowRecordWrapper {
    private ConcurrentHashMap<String, FieldDataWrapper> outputFieldsData = new ConcurrentHashMap();

    protected FieldDataWrapper getFieldWrapperInternal(FieldData field) {
        if (this.outputFieldsData.containsKey(field.getFieldName())) {
            return this.outputFieldsData.get(field.getFieldName());
        }
        FieldDataWrapper wrapper = new FieldDataWrapper(field);
        this.outputFieldsData.put(field.getFieldName(), wrapper);
        return wrapper;
    }

    public abstract List<QueryResultsWrapper.RowRecord> getRowRecords();

    public FieldDataWrapper getDynamicWrapper() throws ParamException {
        List<FieldData> fields = this.getFieldDataList();
        for (FieldData field : fields) {
            if (!field.getIsDynamic()) continue;
            return this.getFieldWrapperInternal(field);
        }
        throw new ParamException("The dynamic field doesn't exist");
    }

    protected QueryResultsWrapper.RowRecord buildRowRecord(QueryResultsWrapper.RowRecord record, long index) {
        for (String outputKey : this.getOutputFields()) {
            FieldDataWrapper dynamicField;
            Object obj;
            boolean isField = false;
            for (FieldData field : this.getFieldDataList()) {
                if (!outputKey.equals(field.getFieldName())) continue;
                FieldDataWrapper wrapper = this.getFieldWrapperInternal(field);
                if (index < 0L || index >= wrapper.getRowCount()) {
                    throw new ParamException("Index out of range");
                }
                Object value = wrapper.valueByIdx((int)index);
                if (wrapper.isJsonField()) {
                    JsonElement jsonField = FieldDataWrapper.ParseJSONObject(value);
                    if (wrapper.isDynamicField() && jsonField instanceof JsonObject) {
                        JsonObject jsonObj = (JsonObject)jsonField;
                        for (String key : jsonObj.keySet()) {
                            record.put(key, FieldDataWrapper.ValueOfJSONElement(jsonObj.get(key)));
                        }
                    } else {
                        record.put(field.getFieldName(), jsonField);
                    }
                } else {
                    record.put(field.getFieldName(), value);
                }
                isField = true;
                break;
            }
            if (isField || (obj = (dynamicField = this.getDynamicWrapper()).get((int)index, outputKey)) == null) continue;
            record.put(outputKey, obj);
        }
        return record;
    }

    protected abstract List<FieldData> getFieldDataList();

    protected abstract List<String> getOutputFields();
}

