/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.QueryResults;
import io.milvus.response.FieldDataWrapper;
import java.util.List;
import lombok.NonNull;

public class QueryResultsWrapper {
    private final QueryResults results;

    public QueryResultsWrapper(@NonNull QueryResults results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    public FieldDataWrapper getFieldWrapper(@NonNull String fieldName) throws ParamException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        List<FieldData> fields = this.results.getFieldsDataList();
        for (FieldData field : fields) {
            if (fieldName.compareTo(field.getFieldName()) != 0) continue;
            return new FieldDataWrapper(field);
        }
        throw new ParamException("The field name doesn't exist");
    }
}

