/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.IllegalResponseException;
import io.milvus.grpc.GetImportStateResponse;
import io.milvus.grpc.ImportState;
import io.milvus.grpc.KeyValuePair;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class GetBulkloadStateWrapper {
    private final GetImportStateResponse response;

    public GetBulkloadStateWrapper(@NonNull GetImportStateResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
    }

    public long getTaskID() {
        return this.response.getId();
    }

    public List<Long> getAutoGeneratedIDs() {
        List<Long> ranges = this.response.getIdListList();
        if (ranges.size() % 2 != 0) {
            throw new IllegalResponseException("The bulkload state response id range list is illegal");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < ranges.size() / 2; ++i) {
            Long begin = ranges.get(i * 2);
            Long end = ranges.get(i * 2 + 1);
            for (long j = begin.longValue(); j <= end; ++j) {
                ids.add(j);
            }
        }
        return ids;
    }

    public ImportState getState() {
        return this.response.getState();
    }

    public long getImportedCount() {
        return this.response.getRowCount();
    }

    public String getFailedReason() {
        return this.getInfo("failed_reason");
    }

    public String getFiles() {
        return this.getInfo("files");
    }

    public String getCollectionName() {
        return this.getInfo("collection");
    }

    public String getPartitionName() {
        return this.getInfo("partition");
    }

    public boolean queryable() {
        return this.response.getDataQueryable();
    }

    public boolean indexed() {
        return this.response.getDataIndexed();
    }

    private String getInfo(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        List<KeyValuePair> infos = this.response.getInfosList();
        for (KeyValuePair kv : infos) {
            if (kv.getKey().compareTo(key) != 0) continue;
            return kv.getValue();
        }
        return "";
    }

    public String toString() {
        return "bulk load task state{, autoGeneratedIDs:" + this.getAutoGeneratedIDs() + ", state:" + this.getState().name() + ", failed reason:" + this.getFailedReason() + ", files:" + this.getFiles() + '}';
    }
}

