/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class QueryParam {
    private final String collectionName;
    private final List<String> partitionNames;
    private final List<String> outFields;
    private final String expr;
    private final long travelTimestamp;
    private final ConsistencyLevelEnum consistencyLevel;

    private QueryParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.outFields = builder.outFields;
        this.expr = builder.expr;
        this.travelTimestamp = builder.travelTimestamp;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "QueryParam{collectionName='" + this.collectionName + '\'' + ", partitionNames='" + this.partitionNames.toString() + '\'' + ", outFields='" + this.outFields.toString() + '\'' + ", expr='" + this.expr + '\'' + ", consistencyLevel='" + (Object)((Object)this.consistencyLevel) + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public String getExpr() {
        return this.expr;
    }

    public long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public static class Builder {
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private final List<String> outFields = new ArrayList<String>();
        private String expr = "";
        private Long travelTimestamp = 0L;
        private ConsistencyLevelEnum consistencyLevel = ConsistencyLevelEnum.BOUNDED;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withOutFields(@NonNull List<String> outFields) {
            if (outFields == null) {
                throw new NullPointerException("outFields is marked non-null but is null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        public Builder withExpr(@NonNull String expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withTravelTimestamp(@NonNull Long ts) {
            if (ts == null) {
                throw new NullPointerException("ts is marked non-null but is null");
            }
            this.travelTimestamp = ts;
            return this;
        }

        public QueryParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.expr, "Expression");
            if (this.travelTimestamp < 0L) {
                throw new ParamException("The travel timestamp must be greater than 0");
            }
            return new QueryParam(this);
        }
    }
}

