/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import com.google.protobuf.ByteString;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.BoolArray;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DoubleArray;
import io.milvus.grpc.DslType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FloatArray;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.IntArray;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.PlaceholderGroup;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.PlaceholderValue;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.StringArray;
import io.milvus.grpc.VectorField;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.collection.FieldType;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ParamUtils {
    private static final Set<DataType> vectorDataType = new HashSet<DataType>(){
        {
            this.add(DataType.FloatVector);
            this.add(DataType.BinaryVector);
        }
    };

    public static HashMap<DataType, String> getTypeErrorMsg() {
        HashMap<DataType, String> typeErrMsg = new HashMap<DataType, String>();
        typeErrMsg.put(DataType.None, "Type mismatch for field '%s': the field type is illegal");
        typeErrMsg.put(DataType.Bool, "Type mismatch for field '%s': Bool field value type must be Boolean");
        typeErrMsg.put(DataType.Int8, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer");
        typeErrMsg.put(DataType.Int16, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer");
        typeErrMsg.put(DataType.Int32, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer");
        typeErrMsg.put(DataType.Int64, "Type mismatch for field '%s': Int64 field value type must be Long");
        typeErrMsg.put(DataType.Float, "Type mismatch for field '%s': Float field value type must be Float");
        typeErrMsg.put(DataType.Double, "Type mismatch for field '%s': Double field value type must be Double");
        typeErrMsg.put(DataType.String, "Type mismatch for field '%s': String field value type must be String");
        typeErrMsg.put(DataType.VarChar, "Type mismatch for field '%s': VarChar field value type must be String");
        typeErrMsg.put(DataType.FloatVector, "Type mismatch for field '%s': Float vector field's value type must be List<Float>");
        typeErrMsg.put(DataType.BinaryVector, "Type mismatch for field '%s': Binary vector field's value type must be ByteBuffer");
        return typeErrMsg;
    }

    private static void checkFieldData(FieldType fieldSchema, InsertParam.Field fieldData) {
        List<?> values = fieldData.getValues();
        HashMap<DataType, String> errMsgs = ParamUtils.getTypeErrorMsg();
        DataType dataType = fieldSchema.getDataType();
        switch (dataType) {
            case FloatVector: {
                int dim = fieldSchema.getDimension();
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!(value instanceof List)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    List temp = (List)value;
                    for (Object v : temp) {
                        if (v instanceof Float) continue;
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    if (temp.size() == dim) continue;
                    String msg = "Incorrect dimension for field '%s': the no.%d vector's dimension: %d is not equal to field's dimension: %d";
                    throw new ParamException(String.format(msg, fieldSchema.getName(), i, temp.size(), dim));
                }
                break;
            }
            case BinaryVector: {
                int dim = fieldSchema.getDimension();
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!(value instanceof ByteBuffer)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    ByteBuffer v = (ByteBuffer)value;
                    if (v.position() * 8 == dim) continue;
                    String msg = "Incorrect dimension for field '%s': the no.%d vector's dimension: %d is not equal to field's dimension: %d";
                    throw new ParamException(String.format(msg, fieldSchema.getName(), i, v.position() * 8, dim));
                }
                break;
            }
            case Int64: {
                for (Object value : values) {
                    if (value instanceof Long) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Int32: 
            case Int16: 
            case Int8: {
                for (Object value : values) {
                    if (value instanceof Short || value instanceof Integer) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Bool: {
                for (Object value : values) {
                    if (value instanceof Boolean) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Float: {
                for (Object value : values) {
                    if (value instanceof Float) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Double: {
                for (Object value : values) {
                    if (value instanceof Double) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case VarChar: 
            case String: {
                for (Object value : values) {
                    if (value instanceof String) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            default: {
                throw new IllegalResponseException("Unsupported data type returned by FieldData");
            }
        }
    }

    public static void CheckNullEmptyString(String target, String name) throws ParamException {
        if (target == null || StringUtils.isBlank((CharSequence)target)) {
            throw new ParamException(name + " cannot be null or empty");
        }
    }

    public static boolean IsFloatMetric(MetricType metric) {
        return metric == MetricType.L2 || metric == MetricType.IP;
    }

    public static boolean IsBinaryMetric(MetricType metric) {
        return !ParamUtils.IsFloatMetric(metric);
    }

    public static boolean IsVectorIndex(IndexType idx) {
        return idx != IndexType.INVALID && idx != IndexType.TRIE;
    }

    public static InsertRequest convertInsertParam(@NonNull InsertParam requestParam, @NonNull List<FieldType> fieldTypes) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (fieldTypes == null) {
            throw new NullPointerException("fieldTypes is marked non-null but is null");
        }
        String collectionName = requestParam.getCollectionName();
        String partitionName = requestParam.getPartitionName();
        List<InsertParam.Field> fields = requestParam.getFields();
        MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
        InsertRequest.Builder insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName).setBase(msgBase).setNumRows(requestParam.getRowCount());
        for (FieldType fieldType : fieldTypes) {
            boolean found = false;
            for (InsertParam.Field field : fields) {
                if (!field.getName().equals(fieldType.getName())) continue;
                if (fieldType.isAutoID()) {
                    String msg = "The primary key: " + fieldType.getName() + " is auto generated, no need to input.";
                    throw new ParamException(msg);
                }
                ParamUtils.checkFieldData(fieldType, field);
                found = true;
                insertBuilder.addFieldsData(ParamUtils.genFieldData(field.getName(), fieldType.getDataType(), field.getValues()));
                break;
            }
            if (found || fieldType.isAutoID()) continue;
            String msg = "The field: " + fieldType.getName() + " is not provided.";
            throw new ParamException(msg);
        }
        return insertBuilder.build();
    }

    public static SearchRequest convertSearchParam(@NonNull SearchParam requestParam) throws ParamException {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        SearchRequest.Builder builder = SearchRequest.newBuilder().setDbName("").setCollectionName(requestParam.getCollectionName());
        if (!requestParam.getPartitionNames().isEmpty()) {
            requestParam.getPartitionNames().forEach(builder::addPartitionNames);
        }
        PlaceholderType plType = PlaceholderType.None;
        List<?> vectors = requestParam.getVectors();
        ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
        for (Object vector : vectors) {
            if (vector instanceof List) {
                plType = PlaceholderType.FloatVector;
                List list = (List)vector;
                ByteBuffer buf = ByteBuffer.allocate(4 * list.size());
                buf.order(ByteOrder.LITTLE_ENDIAN);
                list.forEach(buf::putFloat);
                byte[] array = buf.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            if (vector instanceof ByteBuffer) {
                plType = PlaceholderType.BinaryVector;
                ByteBuffer buf = (ByteBuffer)vector;
                byte[] array = buf.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            String msg = "Search target vector type is illegal(Only allow List<Float> or ByteBuffer)";
            throw new ParamException(msg);
        }
        PlaceholderValue.Builder pldBuilder = PlaceholderValue.newBuilder().setTag("$0").setType(plType);
        byteStrings.forEach(pldBuilder::addValues);
        PlaceholderValue plv = pldBuilder.build();
        PlaceholderGroup placeholderGroup = PlaceholderGroup.newBuilder().addPlaceholders(plv).build();
        ByteString byteStr = placeholderGroup.toByteString();
        builder.setPlaceholderGroup(byteStr);
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(requestParam.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(requestParam.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(requestParam.getMetricType()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(requestParam.getRoundDecimal())).build());
        if (null != requestParam.getParams() && !requestParam.getParams().isEmpty()) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(requestParam.getParams()).build());
        }
        if (!requestParam.getOutFields().isEmpty()) {
            requestParam.getOutFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (requestParam.getExpr() != null && !requestParam.getExpr().isEmpty()) {
            builder.setDsl(requestParam.getExpr());
        }
        long guaranteeTimestamp = ParamUtils.getGuaranteeTimestamp(requestParam.getConsistencyLevel());
        builder.setTravelTimestamp(requestParam.getTravelTimestamp());
        builder.setGuaranteeTimestamp(guaranteeTimestamp);
        return builder.build();
    }

    public static QueryRequest convertQueryParam(@NonNull QueryParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        long guaranteeTimestamp = ParamUtils.getGuaranteeTimestamp(requestParam.getConsistencyLevel());
        return QueryRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).addAllOutputFields(requestParam.getOutFields()).setExpr(requestParam.getExpr()).setTravelTimestamp(requestParam.getTravelTimestamp()).setGuaranteeTimestamp(guaranteeTimestamp).build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevelEnum consistencyLevel) {
        long guaranteeTimestamp = 2L;
        if (consistencyLevel == null) {
            return guaranteeTimestamp;
        }
        switch (consistencyLevel) {
            case STRONG: {
                guaranteeTimestamp = 0L;
                break;
            }
            case EVENTUALLY: {
                guaranteeTimestamp = 1L;
                break;
            }
            case BOUNDED: {
                guaranteeTimestamp = 2L;
            }
        }
        return guaranteeTimestamp;
    }

    private static FieldData genFieldData(String fieldName, DataType dataType, List<?> objects) {
        if (objects == null) {
            throw new ParamException("Cannot generate FieldData from null object");
        }
        FieldData.Builder builder = FieldData.newBuilder();
        if (vectorDataType.contains((Object)dataType)) {
            if (dataType == DataType.FloatVector) {
                ArrayList floats = new ArrayList();
                for (Object object : objects) {
                    if (object instanceof List) {
                        List list = (List)object;
                        floats.addAll(list);
                        continue;
                    }
                    throw new ParamException("The type of FloatVector must be List<Float>");
                }
                int dim = floats.size() / objects.size();
                FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
                VectorField vectorField = VectorField.newBuilder().setDim(dim).setFloatVector(floatArray).build();
                return builder.setFieldName(fieldName).setType(DataType.FloatVector).setVectors(vectorField).build();
            }
            if (dataType == DataType.BinaryVector) {
                ByteBuffer totalBuf = null;
                int dim = 0;
                for (Object object : objects) {
                    ByteBuffer buf = (ByteBuffer)object;
                    if (totalBuf == null) {
                        totalBuf = ByteBuffer.allocate(buf.position() * objects.size());
                        totalBuf.put(buf.array());
                        dim = buf.position() * 8;
                        continue;
                    }
                    totalBuf.put(buf.array());
                }
                assert (totalBuf != null);
                ByteString byteString = ByteString.copyFrom((byte[])totalBuf.array());
                VectorField vectorField = VectorField.newBuilder().setDim(dim).setBinaryVector(byteString).build();
                return builder.setFieldName(fieldName).setType(DataType.BinaryVector).setVectors(vectorField).build();
            }
        } else {
            switch (dataType) {
                case None: 
                case UNRECOGNIZED: {
                    throw new ParamException("Cannot support this dataType:" + (Object)((Object)dataType));
                }
                case Int64: {
                    List longs = objects.stream().map(p -> (Long)p).collect(Collectors.toList());
                    LongArray longArray = LongArray.newBuilder().addAllData(longs).build();
                    ScalarField scalarField = ScalarField.newBuilder().setLongData(longArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
                case Int32: 
                case Int16: 
                case Int8: {
                    List integers = objects.stream().map(p -> p instanceof Short ? ((Short)p).intValue() : ((Integer)p).intValue()).collect(Collectors.toList());
                    IntArray intArray = IntArray.newBuilder().addAllData(integers).build();
                    ScalarField scalarField = ScalarField.newBuilder().setIntData(intArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
                case Bool: {
                    List booleans = objects.stream().map(p -> (Boolean)p).collect(Collectors.toList());
                    BoolArray boolArray = BoolArray.newBuilder().addAllData(booleans).build();
                    ScalarField scalarField = ScalarField.newBuilder().setBoolData(boolArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
                case Float: {
                    List floats = objects.stream().map(p -> (Float)p).collect(Collectors.toList());
                    FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
                    ScalarField scalarField = ScalarField.newBuilder().setFloatData(floatArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
                case Double: {
                    List doubles = objects.stream().map(p -> (Double)p).collect(Collectors.toList());
                    DoubleArray doubleArray = DoubleArray.newBuilder().addAllData(doubles).build();
                    ScalarField scalarField = ScalarField.newBuilder().setDoubleData(doubleArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
                case VarChar: 
                case String: {
                    List<String> strings = objects.stream().map(p -> (String)p).collect(Collectors.toList());
                    StringArray stringArray = StringArray.newBuilder().addAllData(strings).build();
                    ScalarField scalarField = ScalarField.newBuilder().setStringData(stringArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
                }
            }
        }
        return null;
    }

    public static FieldType ConvertField(@NonNull FieldSchema field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        FieldType.Builder builder = FieldType.newBuilder().withName(field.getName()).withDescription(field.getDescription()).withPrimaryKey(field.getIsPrimaryKey()).withAutoID(field.getAutoID()).withDataType(field.getDataType());
        List<KeyValuePair> keyValuePairs = field.getTypeParamsList();
        keyValuePairs.forEach(kv -> builder.addTypeParam(kv.getKey(), kv.getValue()));
        return builder.build();
    }

    public static FieldSchema ConvertField(@NonNull FieldType field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        FieldSchema.Builder builder = FieldSchema.newBuilder().setIsPrimaryKey(field.isPrimaryKey()).setAutoID(field.isAutoID()).setName(field.getName()).setDescription(field.getDescription()).setDataType(field.getDataType());
        Map<String, String> params = field.getTypeParams();
        params.forEach((key, value) -> builder.addTypeParams(KeyValuePair.newBuilder().setKey((String)key).setValue((String)value).build()));
        return builder.build();
    }
}

