/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.param.ParamUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.NonNull;

public class InsertParam {
    private final List<Field> fields;
    private final String collectionName;
    private final String partitionName;
    private final int rowCount;

    private InsertParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.fields = builder.fields;
        this.rowCount = builder.rowCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "InsertParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", row_count=" + this.rowCount + '}';
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static class Field {
        private final String name;
        private final DataType type;
        private final List<?> values;

        public Field(String name, DataType type, List<?> values) {
            if (type == DataType.String) {
                throw new ParamException("String type is not supported, use VarChar instead");
            }
            this.name = name;
            this.type = type;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public List<?> getValues() {
            return this.values;
        }
    }

    public static class Builder {
        private String collectionName;
        private String partitionName = "_default";
        private List<Field> fields;
        private int rowCount;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withFields(@NonNull List<Field> fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.fields = fields;
            return this;
        }

        public InsertParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.fields.isEmpty()) {
                throw new ParamException("Fields cannot be empty");
            }
            for (Field field : this.fields) {
                if (field == null) {
                    throw new ParamException("Field cannot be null. If the field is auto-id, just ignore it from withFields()");
                }
                ParamUtils.CheckNullEmptyString(field.getName(), "Field name");
                if (field.getValues() != null && !field.getValues().isEmpty()) continue;
                throw new ParamException("Field value cannot be empty. If the field is auto-id, just ignore it from withFields()");
            }
            int count = this.fields.get(0).getValues().size();
            for (Field field : this.fields) {
                if (field.getValues().size() == count) continue;
                throw new ParamException("Row count of fields must be equal");
            }
            this.rowCount = count;
            if (count == 0) {
                throw new ParamException("Row count is zero");
            }
            for (Field field : this.fields) {
                Object temp;
                int i;
                Object first;
                List<?> values = field.getValues();
                if (field.getType() == DataType.FloatVector) {
                    for (Object obj : values) {
                        if (!(obj instanceof List)) {
                            throw new ParamException("Float vector field's value must be Lst<Float>");
                        }
                        List temp2 = (List)obj;
                        for (Object v : temp2) {
                            if (v instanceof Float) continue;
                            throw new ParamException("Float vector's value type must be Float");
                        }
                    }
                    first = (List)values.get(0);
                    int dim = first.size();
                    for (i = 1; i < values.size(); ++i) {
                        temp = (List)values.get(i);
                        if (dim == temp.size()) continue;
                        throw new ParamException("Vector dimension must be equal");
                    }
                    continue;
                }
                if (field.getType() == DataType.BinaryVector) {
                    for (Object obj : values) {
                        if (obj instanceof ByteBuffer) continue;
                        throw new ParamException("Binary vector field's type must be ByteBuffer");
                    }
                    first = (ByteBuffer)values.get(0);
                    int dim = ((Buffer)first).position();
                    for (i = 1; i < values.size(); ++i) {
                        temp = (ByteBuffer)values.get(i);
                        if (dim == ((Buffer)temp).position()) continue;
                        throw new ParamException("Vector dimension must be equal");
                    }
                    continue;
                }
                if (field.getType() == DataType.Int64) {
                    for (Object obj : values) {
                        if (obj instanceof Long) continue;
                        throw new ParamException("Int64 field value type must be Long");
                    }
                    continue;
                }
                if (field.getType() == DataType.Int32 || field.getType() == DataType.Int16 || field.getType() == DataType.Int8) {
                    for (Object obj : values) {
                        if (obj instanceof Integer || obj instanceof Short) continue;
                        throw new ParamException("Int32/Int16/Int8 field value type must be Integer or Short");
                    }
                    continue;
                }
                if (field.getType() == DataType.Float) {
                    for (Object obj : values) {
                        if (obj instanceof Float) continue;
                        throw new ParamException("Float field value type must be Float");
                    }
                    continue;
                }
                if (field.getType() == DataType.Double) {
                    for (Object obj : values) {
                        if (obj instanceof Double) continue;
                        throw new ParamException("Double field value type must be Double");
                    }
                    continue;
                }
                if (field.getType() == DataType.Bool) {
                    for (Object obj : values) {
                        if (obj instanceof Boolean) continue;
                        throw new ParamException("Bool field value type must be Boolean");
                    }
                    continue;
                }
                if (field.getType() != DataType.String && field.getType() != DataType.VarChar) continue;
                for (Object obj : values) {
                    if (obj instanceof String) continue;
                    throw new ParamException("String field value type must be String");
                }
            }
            return new InsertParam(this);
        }
    }
}

