/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.MetricType;
import java.util.List;
import lombok.NonNull;

public class CalcDistanceParam {
    private final List<List<Float>> vectorsLeft;
    private final List<List<Float>> vectorsRight;
    private final String metricType;

    private CalcDistanceParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.vectorsLeft = builder.vectorsLeft;
        this.vectorsRight = builder.vectorsRight;
        this.metricType = builder.metricType.name();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CalcDistanceParam{ left vector count:" + this.vectorsLeft.size() + " right vector count:" + this.vectorsRight.size() + '}';
    }

    public List<List<Float>> getVectorsLeft() {
        return this.vectorsLeft;
    }

    public List<List<Float>> getVectorsRight() {
        return this.vectorsRight;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public static class Builder {
        private List<List<Float>> vectorsLeft;
        private List<List<Float>> vectorsRight;
        private MetricType metricType;

        private Builder() {
        }

        public Builder withVectorsLeft(@NonNull List<List<Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectorsLeft = vectors;
            return this;
        }

        public Builder withVectorsRight(@NonNull List<List<Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectorsRight = vectors;
            return this;
        }

        public Builder withMetricType(MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public CalcDistanceParam build() throws ParamException {
            if (this.metricType == MetricType.INVALID) {
                throw new ParamException("Metric type is illegal");
            }
            if (this.metricType != MetricType.L2 && this.metricType != MetricType.IP) {
                throw new ParamException("Only support L2 or IP metric type now!");
            }
            if (this.vectorsLeft == null || this.vectorsLeft.isEmpty()) {
                throw new ParamException("Left vectors can not be empty");
            }
            int count = this.vectorsLeft.get(0).size();
            for (List<Float> vector : this.vectorsLeft) {
                if (vector.size() == count) continue;
                throw new ParamException("Left vector's dimension must be equal");
            }
            if (this.vectorsRight == null || this.vectorsRight.isEmpty()) {
                throw new ParamException("Right vectors can not be empty");
            }
            count = this.vectorsRight.get(0).size();
            for (List<Float> vector : this.vectorsRight) {
                if (vector.size() == count) continue;
                throw new ParamException("Right vector's dimension must be equal");
            }
            return new CalcDistanceParam(this);
        }
    }
}

