/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class BulkloadParam {
    private final String collectionName;
    private final String partitionName;
    private final boolean rowBased;
    private final List<String> files;
    private final Map<String, String> options = new HashMap<String, String>();

    private BulkloadParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.rowBased = builder.rowBased;
        this.files = builder.files;
        this.options.put("bucket", builder.bucketName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "BulkloadParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", files='" + this.files.toString() + '\'' + ", rowBased='" + this.rowBased + '\'' + ", options=" + this.options.toString() + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static class Builder {
        private String collectionName;
        private String partitionName = "";
        private Boolean rowBased = Boolean.TRUE;
        private final List<String> files = Lists.newArrayList();
        private String bucketName = "";

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withRowBased(@NonNull Boolean rowBased) {
            if (rowBased == null) {
                throw new NullPointerException("rowBased is marked non-null but is null");
            }
            this.rowBased = rowBased;
            return this;
        }

        public Builder withBucket(@NonNull String bucketName) {
            if (bucketName == null) {
                throw new NullPointerException("bucketName is marked non-null but is null");
            }
            this.bucketName = bucketName;
            return this;
        }

        public Builder withFiles(@NonNull List<String> files) {
            if (files == null) {
                throw new NullPointerException("files is marked non-null but is null");
            }
            files.forEach(this::addFile);
            return this;
        }

        public Builder addFile(@NonNull String filePath) {
            if (filePath == null) {
                throw new NullPointerException("filePath is marked non-null but is null");
            }
            if (!this.files.contains(filePath)) {
                this.files.add(filePath);
            }
            return this;
        }

        public BulkloadParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new BulkloadParam(this);
        }
    }
}

