/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;

public class FlushParam {
    private final List<String> collectionNames;
    private final Boolean syncFlush;
    private final long syncFlushWaitingInterval;
    private final long syncFlushWaitingTimeout;

    private FlushParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionNames = builder.collectionNames;
        this.syncFlush = builder.syncFlush;
        this.syncFlushWaitingInterval = builder.syncFlushWaitingInterval;
        this.syncFlushWaitingTimeout = builder.syncFlushWaitingTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "FlushParam{collectionNames='" + this.collectionNames + '\'' + ", syncFlush=" + this.syncFlush.toString() + ", syncFlushWaitingInterval=" + this.syncFlushWaitingInterval + ", syncFlushWaitingTimeout=" + this.syncFlushWaitingTimeout + '}';
    }

    public List<String> getCollectionNames() {
        return this.collectionNames;
    }

    public Boolean getSyncFlush() {
        return this.syncFlush;
    }

    public long getSyncFlushWaitingInterval() {
        return this.syncFlushWaitingInterval;
    }

    public long getSyncFlushWaitingTimeout() {
        return this.syncFlushWaitingTimeout;
    }

    public static final class Builder {
        private final List<String> collectionNames = new ArrayList<String>();
        private Boolean syncFlush = Boolean.TRUE;
        private Long syncFlushWaitingInterval = 500L;
        private Long syncFlushWaitingTimeout = 60L;

        private Builder() {
        }

        public Builder withCollectionNames(@NonNull List<String> collectionNames) {
            if (collectionNames == null) {
                throw new NullPointerException("collectionNames is marked non-null but is null");
            }
            this.collectionNames.addAll(collectionNames);
            return this;
        }

        public Builder addCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionNames.add(collectionName);
            return this;
        }

        public Builder withSyncFlush(@NonNull Boolean syncFlush) {
            if (syncFlush == null) {
                throw new NullPointerException("syncFlush is marked non-null but is null");
            }
            this.syncFlush = syncFlush;
            return this;
        }

        public Builder withSyncFlushWaitingInterval(@NonNull Long milliseconds) {
            if (milliseconds == null) {
                throw new NullPointerException("milliseconds is marked non-null but is null");
            }
            this.syncFlushWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncFlushWaitingTimeout(@NonNull Long seconds) {
            if (seconds == null) {
                throw new NullPointerException("seconds is marked non-null but is null");
            }
            this.syncFlushWaitingTimeout = seconds;
            return this;
        }

        public FlushParam build() throws ParamException {
            if (this.collectionNames.isEmpty()) {
                throw new ParamException("CollectionNames can not be empty");
            }
            for (String name : this.collectionNames) {
                ParamUtils.CheckNullEmptyString(name, "Collection name");
            }
            if (Objects.equals(this.syncFlush, Boolean.TRUE)) {
                if (this.syncFlushWaitingInterval <= 0L) {
                    throw new ParamException("Sync flush waiting interval must be larger than zero");
                }
                if (this.syncFlushWaitingInterval > Constant.MAX_WAITING_FLUSHING_INTERVAL) {
                    throw new ParamException("Sync flush waiting interval cannot be larger than " + Constant.MAX_WAITING_FLUSHING_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncFlushWaitingTimeout <= 0L) {
                    throw new ParamException("Sync flush waiting timeout must be larger than zero");
                }
                if (this.syncFlushWaitingTimeout > Constant.MAX_WAITING_FLUSHING_TIMEOUT) {
                    throw new ParamException("Sync flush waiting timeout cannot be larger than " + Constant.MAX_WAITING_FLUSHING_TIMEOUT.toString() + " seconds");
                }
            }
            return new FlushParam(this);
        }
    }
}

