/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.connection;

import io.milvus.connection.Listener;
import io.milvus.connection.ServerSetting;
import io.milvus.grpc.SearchResults;
import io.milvus.param.QueryNodeSingleSearch;
import io.milvus.param.R;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryNodeListener
implements Listener {
    private static final Logger logger = LoggerFactory.getLogger(QueryNodeListener.class);
    private static final int HEARTBEAT_TIMEOUT_MILLS = 4000;
    private final SearchParam searchParam;

    public QueryNodeListener(QueryNodeSingleSearch singleSearch) {
        this.searchParam = SearchParam.newBuilder().withCollectionName(singleSearch.getCollectionName()).withVectors(singleSearch.getVectors()).withVectorFieldName(singleSearch.getVectorFieldName()).withParams(singleSearch.getParams()).withMetricType(singleSearch.getMetricType()).withTopK(5).withRoundDecimal(-1).withGuaranteeTimestamp(1L).build();
    }

    @Override
    public Boolean heartBeat(ServerSetting serverSetting) {
        boolean isRunning = false;
        try {
            SearchResultsWrapper wrapperSearch;
            List<SearchResultsWrapper.IDScore> idScores;
            R<SearchResults> response = serverSetting.getClient().withTimeout(4L, TimeUnit.SECONDS).search(this.searchParam);
            if (response.getStatus().intValue() == R.Status.Success.getCode() && CollectionUtils.isNotEmpty(idScores = (wrapperSearch = new SearchResultsWrapper(response.getData().getResults())).getIDScore(0))) {
                logger.debug("Host [{}] heartbeat Success of Milvus QueryNode Listener.", (Object)serverSetting.getServerAddress().getHost());
                isRunning = true;
            }
        }
        catch (Exception e) {
            logger.error("Host [{}] heartbeat Error of Milvus QueryNode Listener.", (Object)serverSetting.getServerAddress().getHost(), (Object)e);
        }
        return isRunning;
    }
}

