/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.ListenableFuture;
import io.milvus.client.MilvusClient;
import io.milvus.client.MilvusServiceClient;
import io.milvus.connection.ClusterFactory;
import io.milvus.connection.ServerSetting;
import io.milvus.grpc.CalcDistanceResults;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.param.ConnectParam;
import io.milvus.param.MultiConnectParam;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.ServerAddress;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.GetReplicasParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactionParam;
import io.milvus.param.credential.CreateCredentialParam;
import io.milvus.param.credential.DeleteCredentialParam;
import io.milvus.param.credential.ListCredUsersParam;
import io.milvus.param.credential.UpdateCredentialParam;
import io.milvus.param.dml.CalcDistanceParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class MilvusMultiServiceClient
implements MilvusClient {
    private final ClusterFactory clusterFactory;

    public MilvusMultiServiceClient(@NonNull MultiConnectParam multiConnectParam) {
        if (multiConnectParam == null) {
            throw new NullPointerException("multiConnectParam is marked non-null but is null");
        }
        List<ServerSetting> serverSettings = multiConnectParam.getHosts().stream().map(host -> {
            MilvusClient milvusClient = this.buildMilvusClient((ServerAddress)host, multiConnectParam);
            return ServerSetting.newBuilder().withHost((ServerAddress)host).withMilvusClient(milvusClient).build();
        }).collect(Collectors.toList());
        boolean keepMonitor = serverSettings.size() > 1;
        this.clusterFactory = ClusterFactory.newBuilder().withServerSetting(serverSettings).keepMonitor(keepMonitor).withQueryNodeSingleSearch(multiConnectParam.getQueryNodeSingleSearch()).build();
    }

    private MilvusClient buildMilvusClient(ServerAddress host, MultiConnectParam multiConnectParam) {
        long connectTimeoutMsm = multiConnectParam.getConnectTimeoutMs();
        long keepAliveTimeMs = multiConnectParam.getKeepAliveTimeMs();
        long keepAliveTimeoutMs = multiConnectParam.getKeepAliveTimeoutMs();
        boolean keepAliveWithoutCalls = multiConnectParam.isKeepAliveWithoutCalls();
        boolean secure = multiConnectParam.isSecure();
        long idleTimeoutMs = multiConnectParam.getIdleTimeoutMs();
        ConnectParam clusterConnectParam = ConnectParam.newBuilder().withHost(host.getHost()).withPort(host.getPort()).withConnectTimeout(connectTimeoutMsm, TimeUnit.MILLISECONDS).withKeepAliveTime(keepAliveTimeMs, TimeUnit.MILLISECONDS).withKeepAliveTimeout(keepAliveTimeoutMs, TimeUnit.MILLISECONDS).keepAliveWithoutCalls(keepAliveWithoutCalls).secure(secure).withIdleTimeout(idleTimeoutMs, TimeUnit.MILLISECONDS).withAuthorization(multiConnectParam.getAuthorization()).build();
        return new MilvusServiceClient(clusterConnectParam);
    }

    @Override
    public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
        return this.clusterFactory.getMaster().getClient().withTimeout(timeout, timeoutUnit);
    }

    @Override
    public void close(long maxWaitSeconds) throws InterruptedException {
        this.clusterFactory.getAvailableServerSettings().parallelStream().forEach(serverSetting -> serverSetting.getClient().close());
        this.clusterFactory.close();
    }

    @Override
    public R<Boolean> hasCollection(HasCollectionParam requestParam) {
        return this.clusterFactory.getMaster().getClient().hasCollection(requestParam);
    }

    @Override
    public R<RpcStatus> createCollection(CreateCollectionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().createCollection(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> dropCollection(DropCollectionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().dropCollection(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> loadCollection(LoadCollectionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().loadCollection(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> releaseCollection(ReleaseCollectionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().releaseCollection(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<DescribeCollectionResponse> describeCollection(DescribeCollectionParam requestParam) {
        return this.clusterFactory.getMaster().getClient().describeCollection(requestParam);
    }

    @Override
    public R<GetCollectionStatisticsResponse> getCollectionStatistics(GetCollectionStatisticsParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getCollectionStatistics(requestParam);
    }

    @Override
    public R<ShowCollectionsResponse> showCollections(ShowCollectionsParam requestParam) {
        return this.clusterFactory.getMaster().getClient().showCollections(requestParam);
    }

    @Override
    public R<FlushResponse> flush(FlushParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().flush(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> createPartition(CreatePartitionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().createPartition(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> dropPartition(DropPartitionParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().dropPartition(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<Boolean> hasPartition(HasPartitionParam requestParam) {
        return this.clusterFactory.getMaster().getClient().hasPartition(requestParam);
    }

    @Override
    public R<RpcStatus> loadPartitions(LoadPartitionsParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().loadPartitions(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> releasePartitions(ReleasePartitionsParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().releasePartitions(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<GetPartitionStatisticsResponse> getPartitionStatistics(GetPartitionStatisticsParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getPartitionStatistics(requestParam);
    }

    @Override
    public R<ShowPartitionsResponse> showPartitions(ShowPartitionsParam requestParam) {
        return this.clusterFactory.getMaster().getClient().showPartitions(requestParam);
    }

    @Override
    public R<RpcStatus> createAlias(CreateAliasParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().createAlias(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> dropAlias(DropAliasParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().dropAlias(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> alterAlias(AlterAliasParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().alterAlias(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> createIndex(CreateIndexParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().createIndex(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<RpcStatus> dropIndex(DropIndexParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().dropIndex(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<DescribeIndexResponse> describeIndex(DescribeIndexParam requestParam) {
        return this.clusterFactory.getMaster().getClient().describeIndex(requestParam);
    }

    @Override
    public R<GetIndexStateResponse> getIndexState(GetIndexStateParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getIndexState(requestParam);
    }

    @Override
    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(GetIndexBuildProgressParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getIndexBuildProgress(requestParam);
    }

    @Override
    public R<MutationResult> insert(InsertParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().insert(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public ListenableFuture<R<MutationResult>> insertAsync(InsertParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().insertAsync(requestParam)).collect(Collectors.toList());
        return (ListenableFuture)response.get(0);
    }

    @Override
    public R<MutationResult> delete(DeleteParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().stream().map(serverSetting -> serverSetting.getClient().delete(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<SearchResults> search(SearchParam requestParam) {
        return this.clusterFactory.getMaster().getClient().search(requestParam);
    }

    @Override
    public ListenableFuture<R<SearchResults>> searchAsync(SearchParam requestParam) {
        return this.clusterFactory.getMaster().getClient().searchAsync(requestParam);
    }

    @Override
    public R<QueryResults> query(QueryParam requestParam) {
        return this.clusterFactory.getMaster().getClient().query(requestParam);
    }

    @Override
    public ListenableFuture<R<QueryResults>> queryAsync(QueryParam requestParam) {
        return this.clusterFactory.getMaster().getClient().queryAsync(requestParam);
    }

    @Override
    public R<CalcDistanceResults> calcDistance(CalcDistanceParam requestParam) {
        return this.clusterFactory.getMaster().getClient().calcDistance(requestParam);
    }

    @Override
    public R<GetMetricsResponse> getMetrics(GetMetricsParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getMetrics(requestParam);
    }

    @Override
    public R<GetFlushStateResponse> getFlushState(GetFlushStateParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getFlushState(requestParam);
    }

    @Override
    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(GetPersistentSegmentInfoParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getPersistentSegmentInfo(requestParam);
    }

    @Override
    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(GetQuerySegmentInfoParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getQuerySegmentInfo(requestParam);
    }

    @Override
    public R<GetReplicasResponse> getReplicas(GetReplicasParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getReplicas(requestParam);
    }

    @Override
    public R<RpcStatus> loadBalance(LoadBalanceParam requestParam) {
        List response = this.clusterFactory.getAvailableServerSettings().parallelStream().map(serverSetting -> serverSetting.getClient().loadBalance(requestParam)).collect(Collectors.toList());
        return this.handleResponse(response);
    }

    @Override
    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getCompactionState(requestParam);
    }

    @Override
    public R<ManualCompactionResponse> manualCompaction(ManualCompactionParam requestParam) {
        return null;
    }

    @Override
    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam requestParam) {
        return this.clusterFactory.getMaster().getClient().getCompactionStateWithPlans(requestParam);
    }

    @Override
    public R<RpcStatus> createCredential(CreateCredentialParam requestParam) {
        return this.clusterFactory.getMaster().getClient().createCredential(requestParam);
    }

    @Override
    public R<RpcStatus> updateCredential(UpdateCredentialParam requestParam) {
        return this.clusterFactory.getMaster().getClient().updateCredential(requestParam);
    }

    @Override
    public R<RpcStatus> deleteCredential(DeleteCredentialParam requestParam) {
        return this.clusterFactory.getMaster().getClient().deleteCredential(requestParam);
    }

    @Override
    public R<ListCredUsersResponse> listCredUsers(ListCredUsersParam requestParam) {
        return this.clusterFactory.getMaster().getClient().listCredUsers(requestParam);
    }

    private <T> R<T> handleResponse(List<R<T>> response) {
        if (CollectionUtils.isNotEmpty(response)) {
            R<T> rSuccess = null;
            for (R<T> singleRes : response) {
                if (R.Status.Success.getCode() == singleRes.getStatus().intValue()) {
                    rSuccess = singleRes;
                    continue;
                }
                return singleRes;
            }
            if (null != rSuccess) {
                return rSuccess;
            }
        }
        return R.failed(R.Status.Unknown, "Response is empty.");
    }
}

