/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.ListenableFuture;
import io.milvus.grpc.CalcDistanceResults;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.GetReplicasParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactionParam;
import io.milvus.param.credential.CreateCredentialParam;
import io.milvus.param.credential.DeleteCredentialParam;
import io.milvus.param.credential.ListCredUsersParam;
import io.milvus.param.credential.UpdateCredentialParam;
import io.milvus.param.dml.CalcDistanceParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import java.util.concurrent.TimeUnit;

public interface MilvusClient {
    public MilvusClient withTimeout(long var1, TimeUnit var3);

    default public void close() {
        try {
            this.close(TimeUnit.MINUTES.toSeconds(1L));
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted during shutdown Milvus client!");
        }
    }

    public void close(long var1) throws InterruptedException;

    public R<Boolean> hasCollection(HasCollectionParam var1);

    public R<RpcStatus> createCollection(CreateCollectionParam var1);

    public R<RpcStatus> dropCollection(DropCollectionParam var1);

    public R<RpcStatus> loadCollection(LoadCollectionParam var1);

    public R<RpcStatus> releaseCollection(ReleaseCollectionParam var1);

    public R<DescribeCollectionResponse> describeCollection(DescribeCollectionParam var1);

    public R<GetCollectionStatisticsResponse> getCollectionStatistics(GetCollectionStatisticsParam var1);

    public R<ShowCollectionsResponse> showCollections(ShowCollectionsParam var1);

    public R<FlushResponse> flush(FlushParam var1);

    public R<RpcStatus> createPartition(CreatePartitionParam var1);

    public R<RpcStatus> dropPartition(DropPartitionParam var1);

    public R<Boolean> hasPartition(HasPartitionParam var1);

    public R<RpcStatus> loadPartitions(LoadPartitionsParam var1);

    public R<RpcStatus> releasePartitions(ReleasePartitionsParam var1);

    public R<GetPartitionStatisticsResponse> getPartitionStatistics(GetPartitionStatisticsParam var1);

    public R<ShowPartitionsResponse> showPartitions(ShowPartitionsParam var1);

    public R<RpcStatus> createAlias(CreateAliasParam var1);

    public R<RpcStatus> dropAlias(DropAliasParam var1);

    public R<RpcStatus> alterAlias(AlterAliasParam var1);

    public R<RpcStatus> createIndex(CreateIndexParam var1);

    public R<RpcStatus> dropIndex(DropIndexParam var1);

    public R<DescribeIndexResponse> describeIndex(DescribeIndexParam var1);

    public R<GetIndexStateResponse> getIndexState(GetIndexStateParam var1);

    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(GetIndexBuildProgressParam var1);

    public R<MutationResult> insert(InsertParam var1);

    public ListenableFuture<R<MutationResult>> insertAsync(InsertParam var1);

    public R<MutationResult> delete(DeleteParam var1);

    public R<SearchResults> search(SearchParam var1);

    public ListenableFuture<R<SearchResults>> searchAsync(SearchParam var1);

    public R<QueryResults> query(QueryParam var1);

    public ListenableFuture<R<QueryResults>> queryAsync(QueryParam var1);

    public R<CalcDistanceResults> calcDistance(CalcDistanceParam var1);

    public R<GetMetricsResponse> getMetrics(GetMetricsParam var1);

    public R<GetFlushStateResponse> getFlushState(GetFlushStateParam var1);

    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(GetPersistentSegmentInfoParam var1);

    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(GetQuerySegmentInfoParam var1);

    public R<GetReplicasResponse> getReplicas(GetReplicasParam var1);

    public R<RpcStatus> loadBalance(LoadBalanceParam var1);

    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam var1);

    public R<ManualCompactionResponse> manualCompaction(ManualCompactionParam var1);

    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam var1);

    public R<RpcStatus> createCredential(CreateCredentialParam var1);

    public R<RpcStatus> updateCredential(UpdateCredentialParam var1);

    public R<RpcStatus> deleteCredential(DeleteCredentialParam var1);

    public R<ListCredUsersResponse> listCredUsers(ListCredUsersParam var1);
}

