/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.Response;

import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.KeyValuePair;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class DescCollResponseWrapper {
    private final DescribeCollectionResponse response;

    public DescCollResponseWrapper(@NonNull DescribeCollectionResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
    }

    public String getCollectionName() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getName();
    }

    public String getCollectionDescription() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getDescription();
    }

    public long getCollectionID() {
        return this.response.getCollectionID();
    }

    public int getShardNumber() {
        return this.response.getShardsNum();
    }

    public long getCreatedUtcTimestamp() {
        return this.response.getCreatedUtcTimestamp();
    }

    public List<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (int i = 0; i < this.response.getAliasesCount(); ++i) {
            aliases.add(this.response.getAliases(i));
        }
        return aliases;
    }

    public List<FieldType> getFields() {
        ArrayList<FieldType> results = new ArrayList<FieldType>();
        CollectionSchema schema = this.response.getSchema();
        List<FieldSchema> fields = schema.getFieldsList();
        fields.forEach(field -> results.add(this.convertField((FieldSchema)field)));
        return results;
    }

    public FieldType getFieldByName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (fieldName.compareTo(field.getName()) != 0) continue;
            return this.convertField(field);
        }
        return null;
    }

    private FieldType convertField(@NonNull FieldSchema field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        FieldType.Builder builder = FieldType.newBuilder().withName(field.getName()).withDescription(field.getDescription()).withPrimaryKey(field.getIsPrimaryKey()).withAutoID(field.getAutoID()).withDataType(field.getDataType());
        List<KeyValuePair> keyValuePairs = field.getTypeParamsList();
        keyValuePairs.forEach(kv -> builder.addTypeParam(kv.getKey(), kv.getValue()));
        return builder.build();
    }

    public String toString() {
        return "Collection Description{name:'" + this.getCollectionName() + '\'' + ", description:'" + this.getCollectionDescription() + '\'' + ", id:" + this.getCollectionID() + ", shardNumber:" + this.getShardNumber() + ", createdUtcTimestamp:" + this.getCreatedUtcTimestamp() + ", aliases:" + this.getAliases() + ", fields:" + this.getFields().toString() + '}';
    }
}

