/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.MetricType;
import javax.annotation.Nonnull;

public class CollectionMapping {
    private final String collectionName;
    private final long dimension;
    private final long indexFileSize;
    private final MetricType metricType;

    private CollectionMapping(@Nonnull Builder builder) {
        this.collectionName = builder.collectionName;
        this.dimension = builder.dimension;
        this.indexFileSize = builder.indexFileSize;
        this.metricType = builder.metricType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public long getDimension() {
        return this.dimension;
    }

    public long getIndexFileSize() {
        return this.indexFileSize;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String toString() {
        return String.format("CollectionMapping = {collectionName = %s, dimension = %d, indexFileSize = %d, metricType = %s}", this.collectionName, this.dimension, this.indexFileSize, this.metricType.name());
    }

    public static class Builder {
        private final String collectionName;
        private final long dimension;
        private long indexFileSize = 1024L;
        private MetricType metricType = MetricType.L2;

        public Builder(@Nonnull String collectionName, long dimension) {
            this.collectionName = collectionName;
            this.dimension = dimension;
        }

        public Builder withIndexFileSize(long indexFileSize) {
            this.indexFileSize = indexFileSize;
            return this;
        }

        public Builder withMetricType(@Nonnull MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public CollectionMapping build() {
            return new CollectionMapping(this);
        }
    }
}

