/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.milvus.client.AbstractMilvusGrpcClient;
import io.milvus.client.ConnectParam;
import io.milvus.client.MilvusClient;
import io.milvus.client.Response;
import io.milvus.client.exception.InitializationException;
import io.milvus.client.exception.UnsupportedServerVersion;
import io.milvus.grpc.MilvusServiceGrpc;
import java.util.concurrent.TimeUnit;

public class MilvusGrpcClient
extends AbstractMilvusGrpcClient {
    private static String SUPPORTED_SERVER_VERSION = "0.10";
    private final ManagedChannel channel;
    private final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final MilvusServiceGrpc.MilvusServiceFutureStub futureStub;

    public MilvusGrpcClient(ConnectParam connectParam) {
        block4: {
            this.channel = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).build();
            this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
            this.futureStub = MilvusServiceGrpc.newFutureStub((Channel)this.channel);
            try {
                Response response = this.getServerVersion();
                if (response.ok()) {
                    String serverVersion = this.getServerVersion().getMessage();
                    if (!serverVersion.matches("^" + SUPPORTED_SERVER_VERSION + "(\\..*)?$")) {
                        throw new UnsupportedServerVersion(connectParam.getHost(), SUPPORTED_SERVER_VERSION, serverVersion);
                    }
                    break block4;
                }
                throw new InitializationException(connectParam.getHost(), response.getMessage());
            }
            catch (Throwable t) {
                this.channel.shutdownNow();
                throw t;
            }
        }
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    protected boolean maybeAvailable() {
        switch (this.channel.getState(false)) {
            case IDLE: 
            case CONNECTING: 
            case READY: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long maxWaitSeconds) {
        this.channel.shutdown();
        long now = System.nanoTime();
        long deadline = now + TimeUnit.SECONDS.toNanos(maxWaitSeconds);
        boolean interrupted = false;
        try {
            while (now < deadline && !this.channel.isTerminated()) {
                try {
                    this.channel.awaitTermination(deadline - now, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (!this.channel.isTerminated()) {
                this.channel.shutdownNow();
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
        long timeoutMillis = timeoutUnit.toMillis(timeout);
        TimeoutInterceptor timeoutInterceptor = new TimeoutInterceptor(timeoutMillis);
        final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub = (MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        final MilvusServiceGrpc.MilvusServiceFutureStub futureStub = (MilvusServiceGrpc.MilvusServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        return new AbstractMilvusGrpcClient(){

            @Override
            protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
                return blockingStub;
            }

            @Override
            protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
                return futureStub;
            }

            @Override
            protected boolean maybeAvailable() {
                return MilvusGrpcClient.this.maybeAvailable();
            }

            @Override
            public void close(long maxWaitSeconds) {
                MilvusGrpcClient.this.close(maxWaitSeconds);
            }

            @Override
            public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
                return MilvusGrpcClient.this.withTimeout(timeout, timeoutUnit);
            }
        };
    }

    private static class TimeoutInterceptor
    implements ClientInterceptor {
        private long timeoutMillis;

        TimeoutInterceptor(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS));
        }
    }
}

