/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.ListenableFuture;
import io.milvus.client.CollectionMapping;
import io.milvus.client.CountEntitiesResponse;
import io.milvus.client.GetCollectionInfoResponse;
import io.milvus.client.GetEntityByIDResponse;
import io.milvus.client.GetIndexInfoResponse;
import io.milvus.client.HasCollectionResponse;
import io.milvus.client.HasPartitionResponse;
import io.milvus.client.Index;
import io.milvus.client.InsertParam;
import io.milvus.client.InsertResponse;
import io.milvus.client.ListCollectionsResponse;
import io.milvus.client.ListIDInSegmentResponse;
import io.milvus.client.ListPartitionsResponse;
import io.milvus.client.Response;
import io.milvus.client.SearchParam;
import io.milvus.client.SearchResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface MilvusClient {
    public static final String clientVersion = new Supplier<String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            Properties properties = new Properties();
            InputStream inputStream = MilvusClient.class.getClassLoader().getResourceAsStream("milvus-client.properties");
            try {
                properties.load(inputStream);
            }
            catch (IOException ex) {
                ExceptionUtils.wrapAndThrow((Throwable)ex);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return properties.getProperty("version");
        }
    }.get();

    default public String getClientVersion() {
        return clientVersion;
    }

    default public void close() {
        this.close(TimeUnit.MINUTES.toSeconds(1L));
    }

    public void close(long var1);

    public MilvusClient withTimeout(long var1, TimeUnit var3);

    public Response createCollection(CollectionMapping var1);

    public HasCollectionResponse hasCollection(String var1);

    public Response dropCollection(String var1);

    public Response createIndex(Index var1);

    public ListenableFuture<Response> createIndexAsync(Index var1);

    public Response createPartition(String var1, String var2);

    public HasPartitionResponse hasPartition(String var1, String var2);

    public ListPartitionsResponse listPartitions(String var1);

    public Response dropPartition(String var1, String var2);

    public InsertResponse insert(InsertParam var1);

    public ListenableFuture<InsertResponse> insertAsync(InsertParam var1);

    public SearchResponse search(SearchParam var1);

    public ListenableFuture<SearchResponse> searchAsync(SearchParam var1);

    public GetCollectionInfoResponse getCollectionInfo(String var1);

    public ListCollectionsResponse listCollections();

    public CountEntitiesResponse countEntities(String var1);

    public Response getServerStatus();

    public Response getServerVersion();

    public Response command(String var1);

    public Response loadCollection(String var1);

    public Response loadCollection(String var1, List<String> var2);

    public GetIndexInfoResponse getIndexInfo(String var1);

    public Response dropIndex(String var1);

    public Response getCollectionStats(String var1);

    public GetEntityByIDResponse getEntityByID(String var1, List<Long> var2);

    public ListIDInSegmentResponse listIDInSegment(String var1, String var2);

    public Response deleteEntityByID(String var1, List<Long> var2);

    public Response flush(List<String> var1);

    public ListenableFuture<Response> flushAsync(List<String> var1);

    public Response flush(String var1);

    public ListenableFuture<Response> flushAsync(String var1);

    public Response compact(String var1);

    public ListenableFuture<Response> compactAsync(String var1);
}

