package io.milvus.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.30.2)",
    comments = "Source: milvus.proto")
public final class MilvusServiceGrpc {

  private MilvusServiceGrpc() {}

  public static final String SERVICE_NAME = "milvus.grpc.MilvusService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionSchema,
      io.milvus.grpc.Status> getCreateCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateCollection",
      requestType = io.milvus.grpc.CollectionSchema.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionSchema,
      io.milvus.grpc.Status> getCreateCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionSchema, io.milvus.grpc.Status> getCreateCollectionMethod;
    if ((getCreateCollectionMethod = MilvusServiceGrpc.getCreateCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateCollectionMethod = MilvusServiceGrpc.getCreateCollectionMethod) == null) {
          MilvusServiceGrpc.getCreateCollectionMethod = getCreateCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionSchema, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionSchema.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateCollection"))
              .build();
        }
      }
    }
    return getCreateCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.BoolReply> getHasCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "HasCollection",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.BoolReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.BoolReply> getHasCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.BoolReply> getHasCollectionMethod;
    if ((getHasCollectionMethod = MilvusServiceGrpc.getHasCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getHasCollectionMethod = MilvusServiceGrpc.getHasCollectionMethod) == null) {
          MilvusServiceGrpc.getHasCollectionMethod = getHasCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.BoolReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "HasCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.BoolReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("HasCollection"))
              .build();
        }
      }
    }
    return getHasCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionSchema> getDescribeCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeCollection",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.CollectionSchema.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionSchema> getDescribeCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionSchema> getDescribeCollectionMethod;
    if ((getDescribeCollectionMethod = MilvusServiceGrpc.getDescribeCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeCollectionMethod = MilvusServiceGrpc.getDescribeCollectionMethod) == null) {
          MilvusServiceGrpc.getDescribeCollectionMethod = getDescribeCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionSchema>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionSchema.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeCollection"))
              .build();
        }
      }
    }
    return getDescribeCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionRowCount> getCountCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CountCollection",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.CollectionRowCount.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionRowCount> getCountCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionRowCount> getCountCollectionMethod;
    if ((getCountCollectionMethod = MilvusServiceGrpc.getCountCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCountCollectionMethod = MilvusServiceGrpc.getCountCollectionMethod) == null) {
          MilvusServiceGrpc.getCountCollectionMethod = getCountCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionRowCount>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CountCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionRowCount.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CountCollection"))
              .build();
        }
      }
    }
    return getCountCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.CollectionNameList> getShowCollectionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowCollections",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.CollectionNameList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.CollectionNameList> getShowCollectionsMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.CollectionNameList> getShowCollectionsMethod;
    if ((getShowCollectionsMethod = MilvusServiceGrpc.getShowCollectionsMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowCollectionsMethod = MilvusServiceGrpc.getShowCollectionsMethod) == null) {
          MilvusServiceGrpc.getShowCollectionsMethod = getShowCollectionsMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.CollectionNameList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowCollections"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionNameList.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowCollections"))
              .build();
        }
      }
    }
    return getShowCollectionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionInfo> getShowCollectionInfoMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowCollectionInfo",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.CollectionInfo.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.CollectionInfo> getShowCollectionInfoMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionInfo> getShowCollectionInfoMethod;
    if ((getShowCollectionInfoMethod = MilvusServiceGrpc.getShowCollectionInfoMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowCollectionInfoMethod = MilvusServiceGrpc.getShowCollectionInfoMethod) == null) {
          MilvusServiceGrpc.getShowCollectionInfoMethod = getShowCollectionInfoMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.CollectionInfo>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowCollectionInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionInfo.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowCollectionInfo"))
              .build();
        }
      }
    }
    return getShowCollectionInfoMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getDropCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropCollection",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getDropCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.Status> getDropCollectionMethod;
    if ((getDropCollectionMethod = MilvusServiceGrpc.getDropCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropCollectionMethod = MilvusServiceGrpc.getDropCollectionMethod) == null) {
          MilvusServiceGrpc.getDropCollectionMethod = getDropCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropCollection"))
              .build();
        }
      }
    }
    return getDropCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateIndex",
      requestType = io.milvus.grpc.IndexParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam, io.milvus.grpc.Status> getCreateIndexMethod;
    if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
          MilvusServiceGrpc.getCreateIndexMethod = getCreateIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.IndexParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateIndex"))
              .build();
        }
      }
    }
    return getCreateIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeIndex",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.IndexParam.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.IndexParam> getDescribeIndexMethod;
    if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
          MilvusServiceGrpc.getDescribeIndexMethod = getDescribeIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.IndexParam>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeIndex"))
              .build();
        }
      }
    }
    return getDescribeIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getDropIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropIndex",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getDropIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.Status> getDropIndexMethod;
    if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
          MilvusServiceGrpc.getDropIndexMethod = getDropIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropIndex"))
              .build();
        }
      }
    }
    return getDropIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getCreatePartitionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreatePartition",
      requestType = io.milvus.grpc.PartitionParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getCreatePartitionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status> getCreatePartitionMethod;
    if ((getCreatePartitionMethod = MilvusServiceGrpc.getCreatePartitionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreatePartitionMethod = MilvusServiceGrpc.getCreatePartitionMethod) == null) {
          MilvusServiceGrpc.getCreatePartitionMethod = getCreatePartitionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreatePartition"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreatePartition"))
              .build();
        }
      }
    }
    return getCreatePartitionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.BoolReply> getHasPartitionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "HasPartition",
      requestType = io.milvus.grpc.PartitionParam.class,
      responseType = io.milvus.grpc.BoolReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.BoolReply> getHasPartitionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam, io.milvus.grpc.BoolReply> getHasPartitionMethod;
    if ((getHasPartitionMethod = MilvusServiceGrpc.getHasPartitionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getHasPartitionMethod = MilvusServiceGrpc.getHasPartitionMethod) == null) {
          MilvusServiceGrpc.getHasPartitionMethod = getHasPartitionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.PartitionParam, io.milvus.grpc.BoolReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "HasPartition"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.BoolReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("HasPartition"))
              .build();
        }
      }
    }
    return getHasPartitionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.PartitionList> getShowPartitionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowPartitions",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.PartitionList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.PartitionList> getShowPartitionsMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.PartitionList> getShowPartitionsMethod;
    if ((getShowPartitionsMethod = MilvusServiceGrpc.getShowPartitionsMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowPartitionsMethod = MilvusServiceGrpc.getShowPartitionsMethod) == null) {
          MilvusServiceGrpc.getShowPartitionsMethod = getShowPartitionsMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.PartitionList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowPartitions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionList.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowPartitions"))
              .build();
        }
      }
    }
    return getShowPartitionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getDropPartitionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropPartition",
      requestType = io.milvus.grpc.PartitionParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getDropPartitionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status> getDropPartitionMethod;
    if ((getDropPartitionMethod = MilvusServiceGrpc.getDropPartitionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropPartitionMethod = MilvusServiceGrpc.getDropPartitionMethod) == null) {
          MilvusServiceGrpc.getDropPartitionMethod = getDropPartitionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropPartition"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropPartition"))
              .build();
        }
      }
    }
    return getDropPartitionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Insert",
      requestType = io.milvus.grpc.InsertParam.class,
      responseType = io.milvus.grpc.VectorIds.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds> getInsertMethod;
    if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
          MilvusServiceGrpc.getInsertMethod = getInsertMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Insert"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.InsertParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIds.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Insert"))
              .build();
        }
      }
    }
    return getInsertMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.VectorsIdentity,
      io.milvus.grpc.VectorsData> getGetVectorsByIDMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetVectorsByID",
      requestType = io.milvus.grpc.VectorsIdentity.class,
      responseType = io.milvus.grpc.VectorsData.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.VectorsIdentity,
      io.milvus.grpc.VectorsData> getGetVectorsByIDMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.VectorsIdentity, io.milvus.grpc.VectorsData> getGetVectorsByIDMethod;
    if ((getGetVectorsByIDMethod = MilvusServiceGrpc.getGetVectorsByIDMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getGetVectorsByIDMethod = MilvusServiceGrpc.getGetVectorsByIDMethod) == null) {
          MilvusServiceGrpc.getGetVectorsByIDMethod = getGetVectorsByIDMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.VectorsIdentity, io.milvus.grpc.VectorsData>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetVectorsByID"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorsIdentity.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorsData.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("GetVectorsByID"))
              .build();
        }
      }
    }
    return getGetVectorsByIDMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam,
      io.milvus.grpc.VectorIds> getGetVectorIDsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetVectorIDs",
      requestType = io.milvus.grpc.GetVectorIDsParam.class,
      responseType = io.milvus.grpc.VectorIds.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam,
      io.milvus.grpc.VectorIds> getGetVectorIDsMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam, io.milvus.grpc.VectorIds> getGetVectorIDsMethod;
    if ((getGetVectorIDsMethod = MilvusServiceGrpc.getGetVectorIDsMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getGetVectorIDsMethod = MilvusServiceGrpc.getGetVectorIDsMethod) == null) {
          MilvusServiceGrpc.getGetVectorIDsMethod = getGetVectorIDsMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.GetVectorIDsParam, io.milvus.grpc.VectorIds>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetVectorIDs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.GetVectorIDsParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIds.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("GetVectorIDs"))
              .build();
        }
      }
    }
    return getGetVectorIDsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Search",
      requestType = io.milvus.grpc.SearchParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult> getSearchMethod;
    if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
          MilvusServiceGrpc.getSearchMethod = getSearchMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Search"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Search"))
              .build();
        }
      }
    }
    return getSearchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchByIDParam,
      io.milvus.grpc.TopKQueryResult> getSearchByIDMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SearchByID",
      requestType = io.milvus.grpc.SearchByIDParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchByIDParam,
      io.milvus.grpc.TopKQueryResult> getSearchByIDMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchByIDParam, io.milvus.grpc.TopKQueryResult> getSearchByIDMethod;
    if ((getSearchByIDMethod = MilvusServiceGrpc.getSearchByIDMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchByIDMethod = MilvusServiceGrpc.getSearchByIDMethod) == null) {
          MilvusServiceGrpc.getSearchByIDMethod = getSearchByIDMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchByIDParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SearchByID"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchByIDParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("SearchByID"))
              .build();
        }
      }
    }
    return getSearchByIDMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SearchInFiles",
      requestType = io.milvus.grpc.SearchInFilesParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;
    if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
          MilvusServiceGrpc.getSearchInFilesMethod = getSearchInFilesMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SearchInFiles"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchInFilesParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("SearchInFiles"))
              .build();
        }
      }
    }
    return getSearchInFilesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Cmd",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.StringReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.StringReply> getCmdMethod;
    if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
          MilvusServiceGrpc.getCmdMethod = getCmdMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.StringReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Cmd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.StringReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Cmd"))
              .build();
        }
      }
    }
    return getCmdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam,
      io.milvus.grpc.Status> getDeleteByIDMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteByID",
      requestType = io.milvus.grpc.DeleteByIDParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam,
      io.milvus.grpc.Status> getDeleteByIDMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam, io.milvus.grpc.Status> getDeleteByIDMethod;
    if ((getDeleteByIDMethod = MilvusServiceGrpc.getDeleteByIDMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDeleteByIDMethod = MilvusServiceGrpc.getDeleteByIDMethod) == null) {
          MilvusServiceGrpc.getDeleteByIDMethod = getDeleteByIDMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.DeleteByIDParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteByID"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.DeleteByIDParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DeleteByID"))
              .build();
        }
      }
    }
    return getDeleteByIDMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getPreloadCollectionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PreloadCollection",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getPreloadCollectionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.Status> getPreloadCollectionMethod;
    if ((getPreloadCollectionMethod = MilvusServiceGrpc.getPreloadCollectionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getPreloadCollectionMethod = MilvusServiceGrpc.getPreloadCollectionMethod) == null) {
          MilvusServiceGrpc.getPreloadCollectionMethod = getPreloadCollectionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PreloadCollection"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("PreloadCollection"))
              .build();
        }
      }
    }
    return getPreloadCollectionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam,
      io.milvus.grpc.Status> getFlushMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Flush",
      requestType = io.milvus.grpc.FlushParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam,
      io.milvus.grpc.Status> getFlushMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam, io.milvus.grpc.Status> getFlushMethod;
    if ((getFlushMethod = MilvusServiceGrpc.getFlushMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getFlushMethod = MilvusServiceGrpc.getFlushMethod) == null) {
          MilvusServiceGrpc.getFlushMethod = getFlushMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.FlushParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Flush"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.FlushParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Flush"))
              .build();
        }
      }
    }
    return getFlushMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getCompactMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Compact",
      requestType = io.milvus.grpc.CollectionName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName,
      io.milvus.grpc.Status> getCompactMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.CollectionName, io.milvus.grpc.Status> getCompactMethod;
    if ((getCompactMethod = MilvusServiceGrpc.getCompactMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCompactMethod = MilvusServiceGrpc.getCompactMethod) == null) {
          MilvusServiceGrpc.getCompactMethod = getCompactMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.CollectionName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Compact"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.CollectionName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Compact"))
              .build();
        }
      }
    }
    return getCompactMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MilvusServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceStub>() {
        @java.lang.Override
        public MilvusServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceStub(channel, callOptions);
        }
      };
    return MilvusServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MilvusServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceBlockingStub>() {
        @java.lang.Override
        public MilvusServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceBlockingStub(channel, callOptions);
        }
      };
    return MilvusServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MilvusServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceFutureStub>() {
        @java.lang.Override
        public MilvusServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceFutureStub(channel, callOptions);
        }
      };
    return MilvusServiceFutureStub.newStub(factory, channel);
  }

  /**
   */
  public static abstract class MilvusServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     **
     * &#64;brief This method is used to create collection
     * &#64;param CollectionSchema, use to provide collection information to be created.
     * &#64;return Status
     * </pre>
     */
    public void createCollection(io.milvus.grpc.CollectionSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test collection existence.
     * &#64;param CollectionName, collection name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnimplementedUnaryCall(getHasCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionSchema
     * </pre>
     */
    public void describeCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionSchema> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionRowCount
     * </pre>
     */
    public void countCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionRowCount> responseObserver) {
      asyncUnimplementedUnaryCall(getCountCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all collections.
     * &#64;param Command, dummy parameter.
     * &#64;return CollectionNameList
     * </pre>
     */
    public void showCollections(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionNameList> responseObserver) {
      asyncUnimplementedUnaryCall(getShowCollectionsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection detail information.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionInfo
     * </pre>
     */
    public void showCollectionInfo(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionInfo> responseObserver) {
      asyncUnimplementedUnaryCall(getShowCollectionInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete collection.
     * &#64;param CollectionName, collection name is going to be deleted.
     * &#64;return CollectionNameList
     * </pre>
     */
    public void dropCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by collection in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param CollectionName, target collection name.
     * &#64;return IndexParam
     * </pre>
     */
    public void describeIndex(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void dropIndex(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public void createPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreatePartitionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test partition existence.
     * &#64;param PartitionParam, target partition.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnimplementedUnaryCall(getHasPartitionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param CollectionName, target collection name.
     * &#64;return PartitionList
     * </pre>
     */
    public void showPartitions(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList> responseObserver) {
      asyncUnimplementedUnaryCall(getShowPartitionsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public void dropPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropPartitionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to collection.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnimplementedUnaryCall(getInsertMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vectors data by id array.
     * &#64;param VectorsIdentity, target vector id array.
     * &#64;return VectorsData
     * </pre>
     */
    public void getVectorsByID(io.milvus.grpc.VectorsIdentity request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorsData> responseObserver) {
      asyncUnimplementedUnaryCall(getGetVectorsByIDMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target collection and segment
     * &#64;return VectorIds
     * </pre>
     */
    public void getVectorIDs(io.milvus.grpc.GetVectorIDsParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnimplementedUnaryCall(getGetVectorIDsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in collection.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector by id.
     * &#64;param SearchByIDParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchByID(io.milvus.grpc.SearchByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchByIDMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchInFilesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnimplementedUnaryCall(getCmdMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public void deleteByID(io.milvus.grpc.DeleteByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteByIDMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void preloadCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getPreloadCollectionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public void flush(io.milvus.grpc.FlushParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getFlushMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void compact(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCompactMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionSchema,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_COLLECTION)))
          .addMethod(
            getHasCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.BoolReply>(
                  this, METHODID_HAS_COLLECTION)))
          .addMethod(
            getDescribeCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.CollectionSchema>(
                  this, METHODID_DESCRIBE_COLLECTION)))
          .addMethod(
            getCountCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.CollectionRowCount>(
                  this, METHODID_COUNT_COLLECTION)))
          .addMethod(
            getShowCollectionsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.CollectionNameList>(
                  this, METHODID_SHOW_COLLECTIONS)))
          .addMethod(
            getShowCollectionInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.CollectionInfo>(
                  this, METHODID_SHOW_COLLECTION_INFO)))
          .addMethod(
            getDropCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_COLLECTION)))
          .addMethod(
            getCreateIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.IndexParam,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_INDEX)))
          .addMethod(
            getDescribeIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.IndexParam>(
                  this, METHODID_DESCRIBE_INDEX)))
          .addMethod(
            getDropIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_INDEX)))
          .addMethod(
            getCreatePartitionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.PartitionParam,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_PARTITION)))
          .addMethod(
            getHasPartitionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.PartitionParam,
                io.milvus.grpc.BoolReply>(
                  this, METHODID_HAS_PARTITION)))
          .addMethod(
            getShowPartitionsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.PartitionList>(
                  this, METHODID_SHOW_PARTITIONS)))
          .addMethod(
            getDropPartitionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.PartitionParam,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_PARTITION)))
          .addMethod(
            getInsertMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.InsertParam,
                io.milvus.grpc.VectorIds>(
                  this, METHODID_INSERT)))
          .addMethod(
            getGetVectorsByIDMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.VectorsIdentity,
                io.milvus.grpc.VectorsData>(
                  this, METHODID_GET_VECTORS_BY_ID)))
          .addMethod(
            getGetVectorIDsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.GetVectorIDsParam,
                io.milvus.grpc.VectorIds>(
                  this, METHODID_GET_VECTOR_IDS)))
          .addMethod(
            getSearchMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH)))
          .addMethod(
            getSearchByIDMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchByIDParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH_BY_ID)))
          .addMethod(
            getSearchInFilesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchInFilesParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH_IN_FILES)))
          .addMethod(
            getCmdMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.StringReply>(
                  this, METHODID_CMD)))
          .addMethod(
            getDeleteByIDMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.DeleteByIDParam,
                io.milvus.grpc.Status>(
                  this, METHODID_DELETE_BY_ID)))
          .addMethod(
            getPreloadCollectionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.Status>(
                  this, METHODID_PRELOAD_COLLECTION)))
          .addMethod(
            getFlushMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.FlushParam,
                io.milvus.grpc.Status>(
                  this, METHODID_FLUSH)))
          .addMethod(
            getCompactMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.CollectionName,
                io.milvus.grpc.Status>(
                  this, METHODID_COMPACT)))
          .build();
    }
  }

  /**
   */
  public static final class MilvusServiceStub extends io.grpc.stub.AbstractAsyncStub<MilvusServiceStub> {
    private MilvusServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create collection
     * &#64;param CollectionSchema, use to provide collection information to be created.
     * &#64;return Status
     * </pre>
     */
    public void createCollection(io.milvus.grpc.CollectionSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test collection existence.
     * &#64;param CollectionName, collection name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getHasCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionSchema
     * </pre>
     */
    public void describeCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionSchema> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionRowCount
     * </pre>
     */
    public void countCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionRowCount> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCountCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all collections.
     * &#64;param Command, dummy parameter.
     * &#64;return CollectionNameList
     * </pre>
     */
    public void showCollections(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionNameList> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowCollectionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection detail information.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionInfo
     * </pre>
     */
    public void showCollectionInfo(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionInfo> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowCollectionInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete collection.
     * &#64;param CollectionName, collection name is going to be deleted.
     * &#64;return CollectionNameList
     * </pre>
     */
    public void dropCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by collection in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param CollectionName, target collection name.
     * &#64;return IndexParam
     * </pre>
     */
    public void describeIndex(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void dropIndex(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public void createPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreatePartitionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test partition existence.
     * &#64;param PartitionParam, target partition.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getHasPartitionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param CollectionName, target collection name.
     * &#64;return PartitionList
     * </pre>
     */
    public void showPartitions(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowPartitionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public void dropPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropPartitionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to collection.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vectors data by id array.
     * &#64;param VectorsIdentity, target vector id array.
     * &#64;return VectorsData
     * </pre>
     */
    public void getVectorsByID(io.milvus.grpc.VectorsIdentity request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorsData> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetVectorsByIDMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target collection and segment
     * &#64;return VectorIds
     * </pre>
     */
    public void getVectorIDs(io.milvus.grpc.GetVectorIDsParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetVectorIDsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in collection.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector by id.
     * &#64;param SearchByIDParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchByID(io.milvus.grpc.SearchByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchByIDMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public void deleteByID(io.milvus.grpc.DeleteByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteByIDMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void preloadCollection(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPreloadCollectionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public void flush(io.milvus.grpc.FlushParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFlushMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public void compact(io.milvus.grpc.CollectionName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCompactMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class MilvusServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<MilvusServiceBlockingStub> {
    private MilvusServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create collection
     * &#64;param CollectionSchema, use to provide collection information to be created.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createCollection(io.milvus.grpc.CollectionSchema request) {
      return blockingUnaryCall(
          getChannel(), getCreateCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test collection existence.
     * &#64;param CollectionName, collection name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public io.milvus.grpc.BoolReply hasCollection(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getHasCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionSchema
     * </pre>
     */
    public io.milvus.grpc.CollectionSchema describeCollection(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionRowCount
     * </pre>
     */
    public io.milvus.grpc.CollectionRowCount countCollection(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getCountCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all collections.
     * &#64;param Command, dummy parameter.
     * &#64;return CollectionNameList
     * </pre>
     */
    public io.milvus.grpc.CollectionNameList showCollections(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getShowCollectionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection detail information.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionInfo
     * </pre>
     */
    public io.milvus.grpc.CollectionInfo showCollectionInfo(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getShowCollectionInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete collection.
     * &#64;param CollectionName, collection name is going to be deleted.
     * &#64;return CollectionNameList
     * </pre>
     */
    public io.milvus.grpc.Status dropCollection(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getDropCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by collection in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createIndex(io.milvus.grpc.IndexParam request) {
      return blockingUnaryCall(
          getChannel(), getCreateIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param CollectionName, target collection name.
     * &#64;return IndexParam
     * </pre>
     */
    public io.milvus.grpc.IndexParam describeIndex(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status dropIndex(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getDropIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createPartition(io.milvus.grpc.PartitionParam request) {
      return blockingUnaryCall(
          getChannel(), getCreatePartitionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test partition existence.
     * &#64;param PartitionParam, target partition.
     * &#64;return BoolReply
     * </pre>
     */
    public io.milvus.grpc.BoolReply hasPartition(io.milvus.grpc.PartitionParam request) {
      return blockingUnaryCall(
          getChannel(), getHasPartitionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param CollectionName, target collection name.
     * &#64;return PartitionList
     * </pre>
     */
    public io.milvus.grpc.PartitionList showPartitions(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getShowPartitionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status dropPartition(io.milvus.grpc.PartitionParam request) {
      return blockingUnaryCall(
          getChannel(), getDropPartitionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to collection.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public io.milvus.grpc.VectorIds insert(io.milvus.grpc.InsertParam request) {
      return blockingUnaryCall(
          getChannel(), getInsertMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vectors data by id array.
     * &#64;param VectorsIdentity, target vector id array.
     * &#64;return VectorsData
     * </pre>
     */
    public io.milvus.grpc.VectorsData getVectorsByID(io.milvus.grpc.VectorsIdentity request) {
      return blockingUnaryCall(
          getChannel(), getGetVectorsByIDMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target collection and segment
     * &#64;return VectorIds
     * </pre>
     */
    public io.milvus.grpc.VectorIds getVectorIDs(io.milvus.grpc.GetVectorIDsParam request) {
      return blockingUnaryCall(
          getChannel(), getGetVectorIDsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in collection.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public io.milvus.grpc.TopKQueryResult search(io.milvus.grpc.SearchParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector by id.
     * &#64;param SearchByIDParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public io.milvus.grpc.TopKQueryResult searchByID(io.milvus.grpc.SearchByIDParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchByIDMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public io.milvus.grpc.TopKQueryResult searchInFiles(io.milvus.grpc.SearchInFilesParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchInFilesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public io.milvus.grpc.StringReply cmd(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getCmdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public io.milvus.grpc.Status deleteByID(io.milvus.grpc.DeleteByIDParam request) {
      return blockingUnaryCall(
          getChannel(), getDeleteByIDMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status preloadCollection(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getPreloadCollectionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status flush(io.milvus.grpc.FlushParam request) {
      return blockingUnaryCall(
          getChannel(), getFlushMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status compact(io.milvus.grpc.CollectionName request) {
      return blockingUnaryCall(
          getChannel(), getCompactMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class MilvusServiceFutureStub extends io.grpc.stub.AbstractFutureStub<MilvusServiceFutureStub> {
    private MilvusServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create collection
     * &#64;param CollectionSchema, use to provide collection information to be created.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createCollection(
        io.milvus.grpc.CollectionSchema request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test collection existence.
     * &#64;param CollectionName, collection name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.BoolReply> hasCollection(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getHasCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionSchema
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.CollectionSchema> describeCollection(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection schema.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionRowCount
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.CollectionRowCount> countCollection(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getCountCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all collections.
     * &#64;param Command, dummy parameter.
     * &#64;return CollectionNameList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.CollectionNameList> showCollections(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getShowCollectionsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get collection detail information.
     * &#64;param CollectionName, target collection name.
     * &#64;return CollectionInfo
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.CollectionInfo> showCollectionInfo(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getShowCollectionInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete collection.
     * &#64;param CollectionName, collection name is going to be deleted.
     * &#64;return CollectionNameList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropCollection(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by collection in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createIndex(
        io.milvus.grpc.IndexParam request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param CollectionName, target collection name.
     * &#64;return IndexParam
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.IndexParam> describeIndex(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropIndex(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createPartition(
        io.milvus.grpc.PartitionParam request) {
      return futureUnaryCall(
          getChannel().newCall(getCreatePartitionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test partition existence.
     * &#64;param PartitionParam, target partition.
     * &#64;return BoolReply
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.BoolReply> hasPartition(
        io.milvus.grpc.PartitionParam request) {
      return futureUnaryCall(
          getChannel().newCall(getHasPartitionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param CollectionName, target collection name.
     * &#64;return PartitionList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.PartitionList> showPartitions(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getShowPartitionsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropPartition(
        io.milvus.grpc.PartitionParam request) {
      return futureUnaryCall(
          getChannel().newCall(getDropPartitionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to collection.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorIds> insert(
        io.milvus.grpc.InsertParam request) {
      return futureUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vectors data by id array.
     * &#64;param VectorsIdentity, target vector id array.
     * &#64;return VectorsData
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorsData> getVectorsByID(
        io.milvus.grpc.VectorsIdentity request) {
      return futureUnaryCall(
          getChannel().newCall(getGetVectorsByIDMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target collection and segment
     * &#64;return VectorIds
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorIds> getVectorIDs(
        io.milvus.grpc.GetVectorIDsParam request) {
      return futureUnaryCall(
          getChannel().newCall(getGetVectorIDsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in collection.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> search(
        io.milvus.grpc.SearchParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector by id.
     * &#64;param SearchByIDParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> searchByID(
        io.milvus.grpc.SearchByIDParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchByIDMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> searchInFiles(
        io.milvus.grpc.SearchInFilesParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.StringReply> cmd(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> deleteByID(
        io.milvus.grpc.DeleteByIDParam request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteByIDMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> preloadCollection(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getPreloadCollectionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> flush(
        io.milvus.grpc.FlushParam request) {
      return futureUnaryCall(
          getChannel().newCall(getFlushMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact collection
     * &#64;param CollectionName, target collection name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> compact(
        io.milvus.grpc.CollectionName request) {
      return futureUnaryCall(
          getChannel().newCall(getCompactMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_COLLECTION = 0;
  private static final int METHODID_HAS_COLLECTION = 1;
  private static final int METHODID_DESCRIBE_COLLECTION = 2;
  private static final int METHODID_COUNT_COLLECTION = 3;
  private static final int METHODID_SHOW_COLLECTIONS = 4;
  private static final int METHODID_SHOW_COLLECTION_INFO = 5;
  private static final int METHODID_DROP_COLLECTION = 6;
  private static final int METHODID_CREATE_INDEX = 7;
  private static final int METHODID_DESCRIBE_INDEX = 8;
  private static final int METHODID_DROP_INDEX = 9;
  private static final int METHODID_CREATE_PARTITION = 10;
  private static final int METHODID_HAS_PARTITION = 11;
  private static final int METHODID_SHOW_PARTITIONS = 12;
  private static final int METHODID_DROP_PARTITION = 13;
  private static final int METHODID_INSERT = 14;
  private static final int METHODID_GET_VECTORS_BY_ID = 15;
  private static final int METHODID_GET_VECTOR_IDS = 16;
  private static final int METHODID_SEARCH = 17;
  private static final int METHODID_SEARCH_BY_ID = 18;
  private static final int METHODID_SEARCH_IN_FILES = 19;
  private static final int METHODID_CMD = 20;
  private static final int METHODID_DELETE_BY_ID = 21;
  private static final int METHODID_PRELOAD_COLLECTION = 22;
  private static final int METHODID_FLUSH = 23;
  private static final int METHODID_COMPACT = 24;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MilvusServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MilvusServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_COLLECTION:
          serviceImpl.createCollection((io.milvus.grpc.CollectionSchema) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_HAS_COLLECTION:
          serviceImpl.hasCollection((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply>) responseObserver);
          break;
        case METHODID_DESCRIBE_COLLECTION:
          serviceImpl.describeCollection((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionSchema>) responseObserver);
          break;
        case METHODID_COUNT_COLLECTION:
          serviceImpl.countCollection((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionRowCount>) responseObserver);
          break;
        case METHODID_SHOW_COLLECTIONS:
          serviceImpl.showCollections((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionNameList>) responseObserver);
          break;
        case METHODID_SHOW_COLLECTION_INFO:
          serviceImpl.showCollectionInfo((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.CollectionInfo>) responseObserver);
          break;
        case METHODID_DROP_COLLECTION:
          serviceImpl.dropCollection((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_CREATE_INDEX:
          serviceImpl.createIndex((io.milvus.grpc.IndexParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_DESCRIBE_INDEX:
          serviceImpl.describeIndex((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam>) responseObserver);
          break;
        case METHODID_DROP_INDEX:
          serviceImpl.dropIndex((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_CREATE_PARTITION:
          serviceImpl.createPartition((io.milvus.grpc.PartitionParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_HAS_PARTITION:
          serviceImpl.hasPartition((io.milvus.grpc.PartitionParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply>) responseObserver);
          break;
        case METHODID_SHOW_PARTITIONS:
          serviceImpl.showPartitions((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList>) responseObserver);
          break;
        case METHODID_DROP_PARTITION:
          serviceImpl.dropPartition((io.milvus.grpc.PartitionParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_INSERT:
          serviceImpl.insert((io.milvus.grpc.InsertParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds>) responseObserver);
          break;
        case METHODID_GET_VECTORS_BY_ID:
          serviceImpl.getVectorsByID((io.milvus.grpc.VectorsIdentity) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorsData>) responseObserver);
          break;
        case METHODID_GET_VECTOR_IDS:
          serviceImpl.getVectorIDs((io.milvus.grpc.GetVectorIDsParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds>) responseObserver);
          break;
        case METHODID_SEARCH:
          serviceImpl.search((io.milvus.grpc.SearchParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_SEARCH_BY_ID:
          serviceImpl.searchByID((io.milvus.grpc.SearchByIDParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_SEARCH_IN_FILES:
          serviceImpl.searchInFiles((io.milvus.grpc.SearchInFilesParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_CMD:
          serviceImpl.cmd((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply>) responseObserver);
          break;
        case METHODID_DELETE_BY_ID:
          serviceImpl.deleteByID((io.milvus.grpc.DeleteByIDParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_PRELOAD_COLLECTION:
          serviceImpl.preloadCollection((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_FLUSH:
          serviceImpl.flush((io.milvus.grpc.FlushParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_COMPACT:
          serviceImpl.compact((io.milvus.grpc.CollectionName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MilvusServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.milvus.grpc.MilvusProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MilvusService");
    }
  }

  private static final class MilvusServiceFileDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier {
    MilvusServiceFileDescriptorSupplier() {}
  }

  private static final class MilvusServiceMethodDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MilvusServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MilvusServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MilvusServiceFileDescriptorSupplier())
              .addMethod(getCreateCollectionMethod())
              .addMethod(getHasCollectionMethod())
              .addMethod(getDescribeCollectionMethod())
              .addMethod(getCountCollectionMethod())
              .addMethod(getShowCollectionsMethod())
              .addMethod(getShowCollectionInfoMethod())
              .addMethod(getDropCollectionMethod())
              .addMethod(getCreateIndexMethod())
              .addMethod(getDescribeIndexMethod())
              .addMethod(getDropIndexMethod())
              .addMethod(getCreatePartitionMethod())
              .addMethod(getHasPartitionMethod())
              .addMethod(getShowPartitionsMethod())
              .addMethod(getDropPartitionMethod())
              .addMethod(getInsertMethod())
              .addMethod(getGetVectorsByIDMethod())
              .addMethod(getGetVectorIDsMethod())
              .addMethod(getSearchMethod())
              .addMethod(getSearchByIDMethod())
              .addMethod(getSearchInFilesMethod())
              .addMethod(getCmdMethod())
              .addMethod(getDeleteByIDMethod())
              .addMethod(getPreloadCollectionMethod())
              .addMethod(getFlushMethod())
              .addMethod(getCompactMethod())
              .build();
        }
      }
    }
    return result;
  }
}
