/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.milvus.client.CollectionMapping;
import io.milvus.client.ConnectFailedException;
import io.milvus.client.ConnectParam;
import io.milvus.client.CountEntitiesResponse;
import io.milvus.client.GetCollectionInfoResponse;
import io.milvus.client.GetEntityByIDResponse;
import io.milvus.client.GetIndexInfoResponse;
import io.milvus.client.HasCollectionResponse;
import io.milvus.client.HasPartitionResponse;
import io.milvus.client.Index;
import io.milvus.client.IndexType;
import io.milvus.client.InsertParam;
import io.milvus.client.InsertResponse;
import io.milvus.client.ListCollectionsResponse;
import io.milvus.client.ListIDInSegmentResponse;
import io.milvus.client.ListPartitionsResponse;
import io.milvus.client.MetricType;
import io.milvus.client.MilvusClient;
import io.milvus.client.Response;
import io.milvus.client.SearchParam;
import io.milvus.client.SearchResponse;
import io.milvus.grpc.BoolReply;
import io.milvus.grpc.CollectionInfo;
import io.milvus.grpc.CollectionName;
import io.milvus.grpc.CollectionNameList;
import io.milvus.grpc.CollectionRowCount;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.Command;
import io.milvus.grpc.DeleteByIDParam;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FlushParam;
import io.milvus.grpc.GetVectorIDsParam;
import io.milvus.grpc.IndexParam;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.PartitionList;
import io.milvus.grpc.PartitionParam;
import io.milvus.grpc.RowRecord;
import io.milvus.grpc.Status;
import io.milvus.grpc.StringReply;
import io.milvus.grpc.TopKQueryResult;
import io.milvus.grpc.VectorIds;
import io.milvus.grpc.VectorsData;
import io.milvus.grpc.VectorsIdentity;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusGrpcClient
implements MilvusClient {
    private static final Logger logger = LoggerFactory.getLogger(MilvusGrpcClient.class);
    private final String extraParamKey = "params";
    private ManagedChannel channel = null;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub = null;
    private MilvusServiceGrpc.MilvusServiceFutureStub futureStub = null;
    Function<Status, Response> transformStatusToResponseFunc = status -> {
        if (status.getErrorCode() == ErrorCode.SUCCESS) {
            return new Response(Response.Status.SUCCESS);
        }
        return new Response(Response.Status.valueOf(status.getErrorCodeValue()), status.getReason());
    };

    @Override
    public Response connect(ConnectParam connectParam) throws ConnectFailedException {
        if (this.channel != null && !this.channel.isShutdown() && !this.channel.isTerminated()) {
            this.logWarning("Channel is not shutdown or terminated", new Object[0]);
            throw new ConnectFailedException("Channel is not shutdown or terminated");
        }
        try {
            this.channel = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).build();
            this.channel.getState(true);
            long timeout = connectParam.getConnectTimeout(TimeUnit.MILLISECONDS);
            this.logInfo("Trying to connect...Timeout in {} ms", timeout);
            long checkFrequency = 100L;
            while (this.channel.getState(false) != ConnectivityState.READY) {
                if (timeout <= 0L) {
                    this.logError("Connect timeout!", new Object[0]);
                    throw new ConnectFailedException("Connect timeout");
                }
                TimeUnit.MILLISECONDS.sleep(100L);
                timeout -= 100L;
            }
            this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
            this.futureStub = MilvusServiceGrpc.newFutureStub((Channel)this.channel);
            String serverVersion = this.getServerVersion().getMessage();
            if (!serverVersion.contains("0.10.")) {
                this.logError("Connect failed! Server version {} does not match SDK version 0.8.4", serverVersion);
                throw new ConnectFailedException("Failed to connect to Milvus server.");
            }
        }
        catch (Exception e) {
            if (!(e instanceof ConnectFailedException)) {
                this.logError("Connect failed! {}", e.toString());
            }
            throw new ConnectFailedException("Exception occurred: " + e.toString());
        }
        this.logInfo("Connection established successfully to host={}, port={}", connectParam.getHost(), String.valueOf(connectParam.getPort()));
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public Response disconnect() throws InterruptedException {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        try {
            if (!this.channel.shutdown().awaitTermination(60L, TimeUnit.SECONDS)) {
                this.logError("Encountered error when terminating channel", new Object[0]);
                return new Response(Response.Status.RPC_ERROR);
            }
            this.logInfo("Channel terminated", new Object[0]);
        }
        catch (InterruptedException e) {
            this.logError("Exception thrown when terminating channel: {}", e.toString());
            throw e;
        }
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public Response createCollection(@Nonnull CollectionMapping collectionMapping) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionSchema request = CollectionSchema.newBuilder().setCollectionName(collectionMapping.getCollectionName()).setDimension(collectionMapping.getDimension()).setIndexFileSize(collectionMapping.getIndexFileSize()).setMetricType(collectionMapping.getMetricType().getVal()).build();
        try {
            Status response = this.blockingStub.createCollection(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created collection successfully!\n{}", collectionMapping.toString());
                return new Response(Response.Status.SUCCESS);
            }
            if (response.getReason().contentEquals("Collection already exists")) {
                this.logWarning("Collection `{}` already exists", collectionMapping.getCollectionName());
                return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
            }
            this.logError("Create collection failed\n{}\n{}", collectionMapping.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("createCollection RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public HasCollectionResponse hasCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new HasCollectionResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), false);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            BoolReply response = this.blockingStub.hasCollection(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("hasCollection `{}` = {}", collectionName, response.getBoolReply());
                return new HasCollectionResponse(new Response(Response.Status.SUCCESS), response.getBoolReply());
            }
            this.logError("hasCollection `{}` failed:\n{}", collectionName, response.toString());
            return new HasCollectionResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), false);
        }
        catch (StatusRuntimeException e) {
            this.logError("hasCollection RPC failed:\n{}", e.getStatus().toString());
            return new HasCollectionResponse(new Response(Response.Status.RPC_ERROR, e.toString()), false);
        }
    }

    @Override
    public Response dropCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            Status response = this.blockingStub.dropCollection(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped collection `{}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Drop collection `{}` failed:\n{}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("dropCollection RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response createIndex(@Nonnull Index index) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(index.getParamsInJson()).build();
        IndexParam request = IndexParam.newBuilder().setCollectionName(index.getCollectionName()).setIndexType(index.getIndexType().getVal()).addExtraParams(extraParam).build();
        try {
            Status response = this.blockingStub.createIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created index successfully!\n{}", index.toString());
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Create index failed:\n{}\n{}", index.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("createIndex RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public ListenableFuture<Response> createIndexAsync(final @Nonnull Index index) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return Futures.immediateFuture((Object)new Response(Response.Status.CLIENT_NOT_CONNECTED));
        }
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(index.getParamsInJson()).build();
        IndexParam request = IndexParam.newBuilder().setCollectionName(index.getCollectionName()).setIndexType(index.getIndexType().getVal()).addExtraParams(extraParam).build();
        ListenableFuture<Status> response = this.futureStub.createIndex(request);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<Status>(){

            public void onSuccess(Status result) {
                if (result.getErrorCode() == ErrorCode.SUCCESS) {
                    MilvusGrpcClient.this.logInfo("Created index successfully!\n{}", new Object[]{index.toString()});
                } else {
                    MilvusGrpcClient.this.logError("CreateIndexAsync failed:\n{}\n{}", new Object[]{index.toString(), result.toString()});
                }
            }

            public void onFailure(Throwable t) {
                MilvusGrpcClient.this.logError("CreateIndexAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transform(response, this.transformStatusToResponseFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public Response createPartition(String collectionName, String tag) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        PartitionParam request = PartitionParam.newBuilder().setCollectionName(collectionName).setTag(tag).build();
        try {
            Status response = this.blockingStub.createPartition(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created partition `{}` in collection `{}` successfully!", tag, collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Create partition `{}` in collection `{}` failed: {}", tag, collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("createPartition RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public HasPartitionResponse hasPartition(String collectionName, String tag) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new HasPartitionResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), false);
        }
        PartitionParam request = PartitionParam.newBuilder().setCollectionName(collectionName).setTag(tag).build();
        try {
            BoolReply response = this.blockingStub.hasPartition(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("hasPartition with tag `{}` in `{}` = {}", tag, collectionName, response.getBoolReply());
                return new HasPartitionResponse(new Response(Response.Status.SUCCESS), response.getBoolReply());
            }
            this.logError("hasPartition with tag `{}` in `{}` failed:\n{}", tag, collectionName, response.toString());
            return new HasPartitionResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), false);
        }
        catch (StatusRuntimeException e) {
            this.logError("hasPartition RPC failed:\n{}", e.getStatus().toString());
            return new HasPartitionResponse(new Response(Response.Status.RPC_ERROR, e.toString()), false);
        }
    }

    @Override
    public ListPartitionsResponse listPartitions(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ListPartitionsResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList());
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            PartitionList response = this.blockingStub.showPartitions(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Current partitions of collection {}: {}", collectionName, response.getPartitionTagArrayList());
                return new ListPartitionsResponse(new Response(Response.Status.SUCCESS), (List<String>)response.getPartitionTagArrayList());
            }
            this.logError("List partitions failed:\n{}", response.toString());
            return new ListPartitionsResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), Collections.emptyList());
        }
        catch (StatusRuntimeException e) {
            this.logError("listPartitions RPC failed:\n{}", e.getStatus().toString());
            return new ListPartitionsResponse(new Response(Response.Status.RPC_ERROR, e.toString()), Collections.emptyList());
        }
    }

    @Override
    public Response dropPartition(String collectionName, String tag) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        PartitionParam request = PartitionParam.newBuilder().setCollectionName(collectionName).setTag(tag).build();
        try {
            Status response = this.blockingStub.dropPartition(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped partition `{}` in collection `{}` successfully!", tag, collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Drop partition `{}` in collection `{}` failed:\n{}", tag, collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("dropPartition RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public InsertResponse insert(@Nonnull InsertParam insertParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new InsertResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList());
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(insertParam.getFloatVectors(), insertParam.getBinaryVectors());
        io.milvus.grpc.InsertParam request = io.milvus.grpc.InsertParam.newBuilder().setCollectionName(insertParam.getCollectionName()).addAllRowRecordArray(rowRecordList).addAllRowIdArray(insertParam.getVectorIds()).setPartitionTag(insertParam.getPartitionTag()).build();
        try {
            VectorIds response = this.blockingStub.insert(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Inserted {} vectors to collection `{}` successfully!", response.getVectorIdArrayCount(), insertParam.getCollectionName());
                return new InsertResponse(new Response(Response.Status.SUCCESS), response.getVectorIdArrayList());
            }
            this.logError("Insert vectors failed:\n{}", response.getStatus().toString());
            return new InsertResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), Collections.emptyList());
        }
        catch (StatusRuntimeException e) {
            this.logError("insert RPC failed:\n{}", e.getStatus().toString());
            return new InsertResponse(new Response(Response.Status.RPC_ERROR, e.toString()), Collections.emptyList());
        }
    }

    @Override
    public ListenableFuture<InsertResponse> insertAsync(final @Nonnull InsertParam insertParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return Futures.immediateFuture((Object)new InsertResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList()));
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(insertParam.getFloatVectors(), insertParam.getBinaryVectors());
        io.milvus.grpc.InsertParam request = io.milvus.grpc.InsertParam.newBuilder().setCollectionName(insertParam.getCollectionName()).addAllRowRecordArray(rowRecordList).addAllRowIdArray(insertParam.getVectorIds()).setPartitionTag(insertParam.getPartitionTag()).build();
        ListenableFuture<VectorIds> response = this.futureStub.insert(request);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<VectorIds>(){

            public void onSuccess(VectorIds result) {
                if (result.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                    MilvusGrpcClient.this.logInfo("Inserted {} vectors to collection `{}` successfully!", new Object[]{result.getVectorIdArrayCount(), insertParam.getCollectionName()});
                } else {
                    MilvusGrpcClient.this.logError("InsertAsync failed:\n{}", new Object[]{result.getStatus().toString()});
                }
            }

            public void onFailure(Throwable t) {
                MilvusGrpcClient.this.logError("InsertAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<VectorIds, InsertResponse> transformFunc = vectorIds -> {
            if (vectorIds.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                return new InsertResponse(new Response(Response.Status.SUCCESS), vectorIds.getVectorIdArrayList());
            }
            return new InsertResponse(new Response(Response.Status.valueOf(vectorIds.getStatus().getErrorCodeValue()), vectorIds.getStatus().getReason()), Collections.emptyList());
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public SearchResponse search(@Nonnull SearchParam searchParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED));
            return searchResponse;
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(searchParam.getFloatVectors(), searchParam.getBinaryVectors());
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(searchParam.getParamsInJson()).build();
        io.milvus.grpc.SearchParam request = io.milvus.grpc.SearchParam.newBuilder().setCollectionName(searchParam.getCollectionName()).addAllQueryRecordArray(rowRecordList).addAllPartitionTagArray(searchParam.getPartitionTags()).setTopk(searchParam.getTopK()).addExtraParams(extraParam).build();
        try {
            TopKQueryResult response = this.blockingStub.search(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                SearchResponse searchResponse = this.buildSearchResponse(response);
                searchResponse.setResponse(new Response(Response.Status.SUCCESS));
                this.logInfo("Search completed successfully! Returned results for {} queries", searchResponse.getNumQueries());
                return searchResponse;
            }
            this.logError("Search failed:\n{}", response.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()));
            return searchResponse;
        }
        catch (StatusRuntimeException e) {
            this.logError("search RPC failed:\n{}", e.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.RPC_ERROR, e.toString()));
            return searchResponse;
        }
    }

    @Override
    public ListenableFuture<SearchResponse> searchAsync(@Nonnull SearchParam searchParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED));
            return Futures.immediateFuture((Object)searchResponse);
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(searchParam.getFloatVectors(), searchParam.getBinaryVectors());
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(searchParam.getParamsInJson()).build();
        io.milvus.grpc.SearchParam request = io.milvus.grpc.SearchParam.newBuilder().setCollectionName(searchParam.getCollectionName()).addAllQueryRecordArray(rowRecordList).addAllPartitionTagArray(searchParam.getPartitionTags()).setTopk(searchParam.getTopK()).addExtraParams(extraParam).build();
        ListenableFuture<TopKQueryResult> response = this.futureStub.search(request);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<TopKQueryResult>(){

            public void onSuccess(TopKQueryResult result) {
                if (result.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                    MilvusGrpcClient.this.logInfo("SearchAsync completed successfully! Returned results for {} queries", new Object[]{result.getRowNum()});
                } else {
                    MilvusGrpcClient.this.logError("SearchAsync failed:\n{}", new Object[]{result.getStatus().toString()});
                }
            }

            public void onFailure(Throwable t) {
                MilvusGrpcClient.this.logError("SearchAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<TopKQueryResult, SearchResponse> transformFunc = topKQueryResult -> {
            if (topKQueryResult.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                SearchResponse searchResponse = this.buildSearchResponse((TopKQueryResult)topKQueryResult);
                searchResponse.setResponse(new Response(Response.Status.SUCCESS));
                return searchResponse;
            }
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.valueOf(topKQueryResult.getStatus().getErrorCodeValue()), topKQueryResult.getStatus().getReason()));
            return searchResponse;
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public GetCollectionInfoResponse getCollectionInfo(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetCollectionInfoResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            CollectionSchema response = this.blockingStub.describeCollection(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                CollectionMapping collectionMapping = new CollectionMapping.Builder(response.getCollectionName(), response.getDimension()).withIndexFileSize(response.getIndexFileSize()).withMetricType(MetricType.valueOf(response.getMetricType())).build();
                this.logInfo("Get Collection Info `{}` returned:\n{}", collectionName, collectionMapping);
                return new GetCollectionInfoResponse(new Response(Response.Status.SUCCESS), collectionMapping);
            }
            this.logError("Get Collection Info `{}` failed:\n{}", collectionName, response.getStatus().toString());
            return new GetCollectionInfoResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logError("getCollectionInfo RPC failed:\n{}", e.getStatus().toString());
            return new GetCollectionInfoResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public ListCollectionsResponse listCollections() {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ListCollectionsResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList());
        }
        Command request = Command.newBuilder().setCmd("").build();
        try {
            CollectionNameList response = this.blockingStub.showCollections(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                ProtocolStringList collectionNames = response.getCollectionNamesList();
                this.logInfo("Current collections: {}", collectionNames.toString());
                return new ListCollectionsResponse(new Response(Response.Status.SUCCESS), (List<String>)collectionNames);
            }
            this.logError("List collections failed:\n{}", response.getStatus().toString());
            return new ListCollectionsResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), Collections.emptyList());
        }
        catch (StatusRuntimeException e) {
            this.logError("listCollections RPC failed:\n{}", e.getStatus().toString());
            return new ListCollectionsResponse(new Response(Response.Status.RPC_ERROR, e.toString()), Collections.emptyList());
        }
    }

    @Override
    public CountEntitiesResponse countEntities(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new CountEntitiesResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), 0L);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            CollectionRowCount response = this.blockingStub.countCollection(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                long collectionRowCount = response.getCollectionRowCount();
                this.logInfo("Collection `{}` has {} entities", collectionName, collectionRowCount);
                return new CountEntitiesResponse(new Response(Response.Status.SUCCESS), collectionRowCount);
            }
            this.logError("Get collection `{}` entity count failed:\n{}", collectionName, response.getStatus().toString());
            return new CountEntitiesResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), 0L);
        }
        catch (StatusRuntimeException e) {
            this.logError("countEntities RPC failed:\n{}", e.getStatus().toString());
            return new CountEntitiesResponse(new Response(Response.Status.RPC_ERROR, e.toString()), 0L);
        }
    }

    @Override
    public Response getServerStatus() {
        return this.command("status");
    }

    @Override
    public Response getServerVersion() {
        return this.command("version");
    }

    @Override
    public Response command(@Nonnull String command) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        Command request = Command.newBuilder().setCmd(command).build();
        try {
            StringReply response = this.blockingStub.cmd(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Command `{}`: {}", command, response.getStringReply());
                return new Response(Response.Status.SUCCESS, response.getStringReply());
            }
            this.logError("Command `{}` failed:\n{}", command, response.toString());
            return new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("Command RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response loadCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            Status response = this.blockingStub.preloadCollection(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Loaded collection `{}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Load collection `{}` failed:\n{}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("loadCollection RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public GetIndexInfoResponse getIndexInfo(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetIndexInfoResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            IndexParam response = this.blockingStub.describeIndex(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                String extraParam = "";
                for (KeyValuePair kv : response.getExtraParamsList()) {
                    if (!kv.getKey().contentEquals("params")) continue;
                    extraParam = kv.getValue();
                }
                Index index = new Index.Builder(response.getCollectionName(), IndexType.valueOf(response.getIndexType())).withParamsInJson(extraParam).build();
                this.logInfo("Get index info for collection `{}` returned:\n{}", collectionName, index.toString());
                return new GetIndexInfoResponse(new Response(Response.Status.SUCCESS), index);
            }
            this.logError("Get index info for collection `{}` failed:\n{}", collectionName, response.getStatus().toString());
            return new GetIndexInfoResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logError("getIndexInfo RPC failed:\n{}", e.getStatus().toString());
            return new GetIndexInfoResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public Response dropIndex(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            Status response = this.blockingStub.dropIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped index for collection `{}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Drop index for collection `{}` failed:\n{}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("dropIndex RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response getCollectionStats(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            CollectionInfo response = this.blockingStub.showCollectionInfo(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("getCollectionStats for `{}` returned successfully!", collectionName);
                return new Response(Response.Status.SUCCESS, response.getJsonInfo());
            }
            this.logError("getCollectionStats for `{}` failed:\n{}", collectionName, response.getStatus().toString());
            return new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("getCollectionStats RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public GetEntityByIDResponse getEntityByID(String collectionName, List<Long> ids) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetEntityByIDResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList(), null);
        }
        VectorsIdentity request = VectorsIdentity.newBuilder().setCollectionName(collectionName).addAllIdArray(ids).build();
        try {
            VectorsData response = this.blockingStub.getVectorsByID(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("getEntityByID in collection `{}` returned successfully!", collectionName);
                ArrayList<List<Float>> floatVectors = new ArrayList<List<Float>>(ids.size());
                ArrayList<ByteBuffer> binaryVectors = new ArrayList<ByteBuffer>(ids.size());
                for (int i = 0; i < ids.size(); ++i) {
                    floatVectors.add(response.getVectorsData(i).getFloatDataList());
                    binaryVectors.add(response.getVectorsData(i).getBinaryData().asReadOnlyByteBuffer());
                }
                return new GetEntityByIDResponse(new Response(Response.Status.SUCCESS), floatVectors, binaryVectors);
            }
            this.logError("getEntityByID in collection `{}` failed:\n{}", collectionName, response.getStatus().toString());
            return new GetEntityByIDResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), Collections.emptyList(), null);
        }
        catch (StatusRuntimeException e) {
            this.logError("getEntityByID RPC failed:\n{}", e.getStatus().toString());
            return new GetEntityByIDResponse(new Response(Response.Status.RPC_ERROR, e.toString()), Collections.emptyList(), null);
        }
    }

    @Override
    public ListIDInSegmentResponse listIDInSegment(String collectionName, String segmentName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ListIDInSegmentResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), Collections.emptyList());
        }
        GetVectorIDsParam request = GetVectorIDsParam.newBuilder().setCollectionName(collectionName).setSegmentName(segmentName).build();
        try {
            VectorIds response = this.blockingStub.getVectorIDs(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("listIDInSegment in collection `{}`, segment `{}` returned successfully!", collectionName, segmentName);
                return new ListIDInSegmentResponse(new Response(Response.Status.SUCCESS), response.getVectorIdArrayList());
            }
            this.logError("listIDInSegment in collection `{}`, segment `{}` failed:\n{}", collectionName, segmentName, response.getStatus().toString());
            return new ListIDInSegmentResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), Collections.emptyList());
        }
        catch (StatusRuntimeException e) {
            this.logError("listIDInSegment RPC failed:\n{}", e.getStatus().toString());
            return new ListIDInSegmentResponse(new Response(Response.Status.RPC_ERROR, e.toString()), Collections.emptyList());
        }
    }

    @Override
    public Response deleteEntityByID(String collectionName, List<Long> ids) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        DeleteByIDParam request = DeleteByIDParam.newBuilder().setCollectionName(collectionName).addAllIdArray(ids).build();
        try {
            Status response = this.blockingStub.deleteByID(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("deleteEntityByID in collection `{}` completed successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("deleteEntityByID in collection `{}` failed:\n{}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("deleteEntityByID RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response flush(List<String> collectionNames) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        FlushParam request = FlushParam.newBuilder().addAllCollectionNameArray(collectionNames).build();
        try {
            Status response = this.blockingStub.flush(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Flushed collection {} successfully!", collectionNames);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Flush collection {} failed:\n{}", collectionNames, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("flush RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public ListenableFuture<Response> flushAsync(final @Nonnull List<String> collectionNames) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return Futures.immediateFuture((Object)new Response(Response.Status.CLIENT_NOT_CONNECTED));
        }
        FlushParam request = FlushParam.newBuilder().addAllCollectionNameArray(collectionNames).build();
        ListenableFuture<Status> response = this.futureStub.flush(request);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<Status>(){

            public void onSuccess(Status result) {
                if (result.getErrorCode() == ErrorCode.SUCCESS) {
                    MilvusGrpcClient.this.logInfo("Flushed collection {} successfully!", new Object[]{collectionNames});
                } else {
                    MilvusGrpcClient.this.logError("Flush collection {} failed:\n{}", new Object[]{collectionNames, result.toString()});
                }
            }

            public void onFailure(Throwable t) {
                MilvusGrpcClient.this.logError("FlushAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transform(response, this.transformStatusToResponseFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public Response flush(final String collectionName) {
        ArrayList<String> list = new ArrayList<String>(){
            {
                this.add(collectionName);
            }
        };
        return this.flush((List<String>)list);
    }

    @Override
    public ListenableFuture<Response> flushAsync(final String collectionName) {
        ArrayList<String> list = new ArrayList<String>(){
            {
                this.add(collectionName);
            }
        };
        return this.flushAsync((List<String>)list);
    }

    @Override
    public Response compact(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        try {
            Status response = this.blockingStub.compact(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Compacted collection `{}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logError("Compact collection `{}` failed:\n{}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("compact RPC failed:\n{}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public ListenableFuture<Response> compactAsync(final @Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return Futures.immediateFuture((Object)new Response(Response.Status.CLIENT_NOT_CONNECTED));
        }
        CollectionName request = CollectionName.newBuilder().setCollectionName(collectionName).build();
        ListenableFuture<Status> response = this.futureStub.compact(request);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<Status>(){

            public void onSuccess(Status result) {
                if (result.getErrorCode() == ErrorCode.SUCCESS) {
                    MilvusGrpcClient.this.logInfo("Compacted collection `{}` successfully!", new Object[]{collectionName});
                } else {
                    MilvusGrpcClient.this.logError("Compact collection `{}` failed:\n{}", new Object[]{collectionName, result.toString()});
                }
            }

            public void onFailure(Throwable t) {
                MilvusGrpcClient.this.logError("CompactAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transform(response, this.transformStatusToResponseFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    private List<RowRecord> buildRowRecordList(@Nonnull List<List<Float>> floatVectors, @Nonnull List<ByteBuffer> binaryVectors) {
        int largerSize = Math.max(floatVectors.size(), binaryVectors.size());
        ArrayList<RowRecord> rowRecordList = new ArrayList<RowRecord>(largerSize);
        for (int i = 0; i < largerSize; ++i) {
            RowRecord.Builder rowRecordBuilder = RowRecord.newBuilder();
            if (i < floatVectors.size()) {
                rowRecordBuilder.addAllFloatData((Iterable<? extends Float>)floatVectors.get(i));
            }
            if (i < binaryVectors.size()) {
                ((Buffer)binaryVectors.get(i)).rewind();
                rowRecordBuilder.setBinaryData(ByteString.copyFrom((ByteBuffer)binaryVectors.get(i)));
            }
            rowRecordList.add(rowRecordBuilder.build());
        }
        return rowRecordList;
    }

    private SearchResponse buildSearchResponse(TopKQueryResult topKQueryResult) {
        int numQueries = (int)topKQueryResult.getRowNum();
        int topK = numQueries == 0 ? 0 : topKQueryResult.getIdsCount() / numQueries;
        ArrayList<List<Long>> resultIdsList = new ArrayList<List<Long>>(numQueries);
        ArrayList<List<Float>> resultDistancesList = new ArrayList<List<Float>>(numQueries);
        if (topK > 0) {
            for (int i = 0; i < numQueries; ++i) {
                int pos;
                for (pos = i * topK; pos < i * topK + topK && topKQueryResult.getIdsList().get(pos) != -1L; ++pos) {
                }
                resultIdsList.add(topKQueryResult.getIdsList().subList(i * topK, pos));
                resultDistancesList.add(topKQueryResult.getDistancesList().subList(i * topK, pos));
            }
        }
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setNumQueries(numQueries);
        searchResponse.setTopK(topK);
        searchResponse.setResultIdsList(resultIdsList);
        searchResponse.setResultDistancesList(resultDistancesList);
        return searchResponse;
    }

    private boolean channelIsReadyOrIdle() {
        if (this.channel == null) {
            return false;
        }
        ConnectivityState connectivityState = this.channel.getState(false);
        return connectivityState == ConnectivityState.READY || connectivityState == ConnectivityState.IDLE;
    }

    private void logInfo(String msg, Object ... params) {
        logger.info(msg, params);
    }

    private void logWarning(String msg, Object ... params) {
        logger.warn(msg, params);
    }

    private void logError(String msg, Object ... params) {
        logger.error(msg, params);
    }
}

