/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.ListenableFuture;
import io.milvus.client.CollectionMapping;
import io.milvus.client.ConnectFailedException;
import io.milvus.client.ConnectParam;
import io.milvus.client.CountEntitiesResponse;
import io.milvus.client.GetCollectionInfoResponse;
import io.milvus.client.GetEntityByIDResponse;
import io.milvus.client.GetIndexInfoResponse;
import io.milvus.client.HasCollectionResponse;
import io.milvus.client.HasPartitionResponse;
import io.milvus.client.Index;
import io.milvus.client.InsertParam;
import io.milvus.client.InsertResponse;
import io.milvus.client.ListCollectionsResponse;
import io.milvus.client.ListIDInSegmentResponse;
import io.milvus.client.ListPartitionsResponse;
import io.milvus.client.Response;
import io.milvus.client.SearchParam;
import io.milvus.client.SearchResponse;
import java.util.List;

public interface MilvusClient {
    public static final String clientVersion = "0.8.4";

    default public String getClientVersion() {
        return clientVersion;
    }

    public Response connect(ConnectParam var1) throws ConnectFailedException;

    public Response disconnect() throws InterruptedException;

    public Response createCollection(CollectionMapping var1);

    public HasCollectionResponse hasCollection(String var1);

    public Response dropCollection(String var1);

    public Response createIndex(Index var1);

    public ListenableFuture<Response> createIndexAsync(Index var1);

    public Response createPartition(String var1, String var2);

    public HasPartitionResponse hasPartition(String var1, String var2);

    public ListPartitionsResponse listPartitions(String var1);

    public Response dropPartition(String var1, String var2);

    public InsertResponse insert(InsertParam var1);

    public ListenableFuture<InsertResponse> insertAsync(InsertParam var1);

    public SearchResponse search(SearchParam var1);

    public ListenableFuture<SearchResponse> searchAsync(SearchParam var1);

    public GetCollectionInfoResponse getCollectionInfo(String var1);

    public ListCollectionsResponse listCollections();

    public CountEntitiesResponse countEntities(String var1);

    public Response getServerStatus();

    public Response getServerVersion();

    public Response command(String var1);

    public Response loadCollection(String var1);

    public GetIndexInfoResponse getIndexInfo(String var1);

    public Response dropIndex(String var1);

    public Response getCollectionStats(String var1);

    public GetEntityByIDResponse getEntityByID(String var1, List<Long> var2);

    public ListIDInSegmentResponse listIDInSegment(String var1, String var2);

    public Response deleteEntityByID(String var1, List<Long> var2);

    public Response flush(List<String> var1);

    public ListenableFuture<Response> flushAsync(List<String> var1);

    public Response flush(String var1);

    public ListenableFuture<Response> flushAsync(String var1);

    public Response compact(String var1);

    public ListenableFuture<Response> compactAsync(String var1);
}

