/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.Response;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class SearchResponse {
    private Response response;
    private int numQueries;
    private long topK;
    private List<List<Long>> resultIdsList;
    private List<List<Float>> resultDistancesList;

    public int getNumQueries() {
        return this.numQueries;
    }

    void setNumQueries(int numQueries) {
        this.numQueries = numQueries;
    }

    public long getTopK() {
        return this.topK;
    }

    void setTopK(long topK) {
        this.topK = topK;
    }

    public List<List<QueryResult>> getQueryResultsList() {
        return IntStream.range(0, this.numQueries).mapToObj(i -> LongStream.range(0L, this.topK).mapToObj(j -> new QueryResult(this.resultIdsList.get(i).get((int)j), this.resultDistancesList.get(i).get((int)j).floatValue())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public List<List<Long>> getResultIdsList() {
        return this.resultIdsList;
    }

    void setResultIdsList(List<List<Long>> resultIdsList) {
        this.resultIdsList = resultIdsList;
    }

    public List<List<Float>> getResultDistancesList() {
        return this.resultDistancesList;
    }

    void setResultDistancesList(List<List<Float>> resultDistancesList) {
        this.resultDistancesList = resultDistancesList;
    }

    public Response getResponse() {
        return this.response;
    }

    void setResponse(Response response) {
        this.response = response;
    }

    public boolean ok() {
        return this.response.ok();
    }

    public String toString() {
        return String.format("SearchResponse {%s, returned results for %d queries}", this.response.toString(), this.numQueries);
    }

    public static class QueryResult {
        private final long vectorId;
        private final float distance;

        QueryResult(long vectorId, float distance) {
            this.vectorId = vectorId;
            this.distance = distance;
        }

        public long getVectorId() {
            return this.vectorId;
        }

        public float getDistance() {
            return this.distance;
        }
    }
}

