/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.milvus.client.CollectionInfo;
import io.milvus.client.CollectionMapping;
import io.milvus.client.ConnectFailedException;
import io.milvus.client.ConnectParam;
import io.milvus.client.DescribeCollectionResponse;
import io.milvus.client.DescribeIndexResponse;
import io.milvus.client.GetCollectionRowCountResponse;
import io.milvus.client.GetVectorByIdResponse;
import io.milvus.client.GetVectorIdsResponse;
import io.milvus.client.HasCollectionResponse;
import io.milvus.client.Index;
import io.milvus.client.IndexType;
import io.milvus.client.InsertParam;
import io.milvus.client.InsertResponse;
import io.milvus.client.MetricType;
import io.milvus.client.MilvusClient;
import io.milvus.client.Response;
import io.milvus.client.SearchParam;
import io.milvus.client.SearchResponse;
import io.milvus.client.ShowCollectionInfoResponse;
import io.milvus.client.ShowCollectionsResponse;
import io.milvus.client.ShowPartitionsResponse;
import io.milvus.grpc.BoolReply;
import io.milvus.grpc.Command;
import io.milvus.grpc.DeleteByIDParam;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FlushParam;
import io.milvus.grpc.GetVectorIDsParam;
import io.milvus.grpc.IndexParam;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.PartitionList;
import io.milvus.grpc.PartitionParam;
import io.milvus.grpc.PartitionStat;
import io.milvus.grpc.RowRecord;
import io.milvus.grpc.SearchInFilesParam;
import io.milvus.grpc.SegmentStat;
import io.milvus.grpc.Status;
import io.milvus.grpc.StringReply;
import io.milvus.grpc.TableInfo;
import io.milvus.grpc.TableName;
import io.milvus.grpc.TableNameList;
import io.milvus.grpc.TableRowCount;
import io.milvus.grpc.TableSchema;
import io.milvus.grpc.TopKQueryResult;
import io.milvus.grpc.VectorData;
import io.milvus.grpc.VectorIdentity;
import io.milvus.grpc.VectorIds;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.ListUtils;

public class MilvusGrpcClient
implements MilvusClient {
    private static final Logger logger = Logger.getLogger(MilvusGrpcClient.class.getName());
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_BRIGHT_PURPLE = "\u001b[95m";
    private final String extraParamKey = "params";
    private ManagedChannel channel = null;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub = null;

    public MilvusGrpcClient() {
        logger.setLevel(Level.ALL);
    }

    public MilvusGrpcClient(Level logLevel) {
        logger.setLevel(logLevel);
    }

    @Override
    public Response connect(ConnectParam connectParam) throws ConnectFailedException {
        if (this.channel != null && !this.channel.isShutdown() && !this.channel.isTerminated()) {
            this.logWarning("Channel is not shutdown or terminated", new Object[0]);
            throw new ConnectFailedException("Channel is not shutdown or terminated");
        }
        try {
            this.channel = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).build();
            this.channel.getState(true);
            long timeout = connectParam.getConnectTimeout(TimeUnit.MILLISECONDS);
            this.logInfo("Trying to connect...Timeout in {0} ms", timeout);
            long checkFrequency = 100L;
            while (this.channel.getState(false) != ConnectivityState.READY) {
                if (timeout <= 0L) {
                    this.logSevere("Connect timeout!", new Object[0]);
                    throw new ConnectFailedException("Connect timeout");
                }
                TimeUnit.MILLISECONDS.sleep(100L);
                timeout -= 100L;
            }
            this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        }
        catch (Exception e) {
            if (!(e instanceof ConnectFailedException)) {
                this.logSevere("Connect failed! {0}", e.toString());
            }
            throw new ConnectFailedException("Exception occurred: " + e.toString());
        }
        this.logInfo("Connection established successfully to host={0}, port={1}", connectParam.getHost(), String.valueOf(connectParam.getPort()));
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        ConnectivityState connectivityState = this.channel.getState(false);
        return connectivityState == ConnectivityState.READY;
    }

    @Override
    public Response disconnect() throws InterruptedException {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        try {
            if (!this.channel.shutdown().awaitTermination(60L, TimeUnit.SECONDS)) {
                this.logSevere("Encountered error when terminating channel", new Object[0]);
                return new Response(Response.Status.RPC_ERROR);
            }
            this.logInfo("Channel terminated", new Object[0]);
        }
        catch (InterruptedException e) {
            this.logSevere("Exception thrown when terminating channel: {0}", e.toString());
            throw e;
        }
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public Response createCollection(@Nonnull CollectionMapping collectionMapping) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        TableSchema request = TableSchema.newBuilder().setTableName(collectionMapping.getCollectionName()).setDimension(collectionMapping.getDimension()).setIndexFileSize(collectionMapping.getIndexFileSize()).setMetricType(collectionMapping.getMetricType().getVal()).build();
        try {
            Status response = this.blockingStub.createTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created collection successfully!\n{0}", collectionMapping.toString());
                return new Response(Response.Status.SUCCESS);
            }
            if (response.getReason().contentEquals("Collection already exists")) {
                this.logWarning("Collection `{0}` already exists", collectionMapping.getCollectionName());
                return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
            }
            this.logSevere("Create collection failed\n{0}\n{1}", collectionMapping.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("createCollection RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public HasCollectionResponse hasCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new HasCollectionResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), false);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            BoolReply response = this.blockingStub.hasTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("hasCollection `{0}` = {1}", collectionName, response.getBoolReply());
                return new HasCollectionResponse(new Response(Response.Status.SUCCESS), response.getBoolReply());
            }
            this.logSevere("hasCollection `{0}` failed:\n{1}", collectionName, response.toString());
            return new HasCollectionResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), false);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("hasCollection RPC failed:\n{0}", e.getStatus().toString());
            return new HasCollectionResponse(new Response(Response.Status.RPC_ERROR, e.toString()), false);
        }
    }

    @Override
    public Response dropCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            Status response = this.blockingStub.dropTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped collection `{0}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Drop collection `{0}` failed:\n{1}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("dropCollection RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response createIndex(@Nonnull Index index) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(index.getParamsInJson()).build();
        IndexParam request = IndexParam.newBuilder().setTableName(index.getCollectionName()).setIndexType(index.getIndexType().getVal()).addExtraParams(extraParam).build();
        try {
            Status response = this.blockingStub.createIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created index successfully!\n{0}", index.toString());
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Create index failed:\n{0}\n{1}", index.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("createIndex RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response createPartition(String collectionName, String tag) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        PartitionParam request = PartitionParam.newBuilder().setTableName(collectionName).setTag(tag).build();
        try {
            Status response = this.blockingStub.createPartition(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created partition `{0}` in collection `{1}` successfully!", tag, collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Create partition `{0}` in collection `{1}` failed: {2}", tag, collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("createPartition RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public ShowPartitionsResponse showPartitions(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ShowPartitionsResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<String>());
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            PartitionList response = this.blockingStub.showPartitions(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Current partitions of collection {0}: {1}", collectionName, response.getPartitionTagArrayList());
                return new ShowPartitionsResponse(new Response(Response.Status.SUCCESS), (List<String>)response.getPartitionTagArrayList());
            }
            this.logSevere("Show partitions failed:\n{0}", response.toString());
            return new ShowPartitionsResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<String>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("showPartitions RPC failed:\n{0}", e.getStatus().toString());
            return new ShowPartitionsResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<String>());
        }
    }

    @Override
    public Response dropPartition(String collectionName, String tag) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        PartitionParam request = PartitionParam.newBuilder().setTableName(collectionName).setTag(tag).build();
        try {
            Status response = this.blockingStub.dropPartition(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped partition `{1}` in collection `{1}` successfully!", tag, collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Drop partition `{0}` in collection `{1}` failed:\n{1}", tag, collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("dropPartition RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public InsertResponse insert(@Nonnull InsertParam insertParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new InsertResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<Long>());
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(insertParam.getFloatVectors(), insertParam.getBinaryVectors());
        io.milvus.grpc.InsertParam request = io.milvus.grpc.InsertParam.newBuilder().setTableName(insertParam.getCollectionName()).addAllRowRecordArray(rowRecordList).addAllRowIdArray(insertParam.getVectorIds()).setPartitionTag(insertParam.getPartitionTag()).build();
        try {
            VectorIds response = this.blockingStub.insert(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Inserted {0} vectors to collection `{1}` successfully!", response.getVectorIdArrayCount(), insertParam.getCollectionName());
                return new InsertResponse(new Response(Response.Status.SUCCESS), response.getVectorIdArrayList());
            }
            this.logSevere("Insert vectors failed:\n{0}", response.getStatus().toString());
            return new InsertResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<Long>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("insert RPC failed:\n{0}", e.getStatus().toString());
            return new InsertResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<Long>());
        }
    }

    @Override
    public SearchResponse search(@Nonnull SearchParam searchParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED));
            return searchResponse;
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(searchParam.getFloatVectors(), searchParam.getBinaryVectors());
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(searchParam.getParamsInJson()).build();
        io.milvus.grpc.SearchParam request = io.milvus.grpc.SearchParam.newBuilder().setTableName(searchParam.getCollectionName()).addAllQueryRecordArray(rowRecordList).addAllPartitionTagArray(searchParam.getPartitionTags()).setTopk(searchParam.getTopK()).addExtraParams(extraParam).build();
        try {
            TopKQueryResult response = this.blockingStub.search(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                SearchResponse searchResponse = this.buildSearchResponse(response);
                searchResponse.setResponse(new Response(Response.Status.SUCCESS));
                this.logInfo("Search completed successfully! Returned results for {0} queries", searchResponse.getNumQueries());
                return searchResponse;
            }
            this.logSevere("Search failed:\n{0}", response.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()));
            return searchResponse;
        }
        catch (StatusRuntimeException e) {
            this.logSevere("search RPC failed:\n{0}", e.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.RPC_ERROR, e.toString()));
            return searchResponse;
        }
    }

    @Override
    public SearchResponse searchInFiles(@Nonnull List<String> fileIds, @Nonnull SearchParam searchParam) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED));
            return searchResponse;
        }
        List<RowRecord> rowRecordList = this.buildRowRecordList(searchParam.getFloatVectors(), searchParam.getBinaryVectors());
        KeyValuePair extraParam = KeyValuePair.newBuilder().setKey("params").setValue(searchParam.getParamsInJson()).build();
        io.milvus.grpc.SearchParam constructSearchParam = io.milvus.grpc.SearchParam.newBuilder().setTableName(searchParam.getCollectionName()).addAllQueryRecordArray(rowRecordList).addAllPartitionTagArray(searchParam.getPartitionTags()).setTopk(searchParam.getTopK()).addExtraParams(extraParam).build();
        SearchInFilesParam request = SearchInFilesParam.newBuilder().addAllFileIdArray(fileIds).setSearchParam(constructSearchParam).build();
        try {
            TopKQueryResult response = this.blockingStub.searchInFiles(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                SearchResponse searchResponse = this.buildSearchResponse(response);
                searchResponse.setResponse(new Response(Response.Status.SUCCESS));
                this.logInfo("Search in files completed successfully! Returned results for {0} queries", searchResponse.getNumQueries());
                return searchResponse;
            }
            this.logSevere("Search in files failed: {0}", response.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()));
            return searchResponse;
        }
        catch (StatusRuntimeException e) {
            this.logSevere("searchInFiles RPC failed:\n{0}", e.getStatus().toString());
            SearchResponse searchResponse = new SearchResponse();
            searchResponse.setResponse(new Response(Response.Status.RPC_ERROR, e.toString()));
            return searchResponse;
        }
    }

    @Override
    public DescribeCollectionResponse describeCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new DescribeCollectionResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            TableSchema response = this.blockingStub.describeTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                CollectionMapping collectionMapping = new CollectionMapping.Builder(response.getTableName(), response.getDimension()).withIndexFileSize(response.getIndexFileSize()).withMetricType(MetricType.valueOf(response.getMetricType())).build();
                this.logInfo("Describe Collection `{0}` returned:\n{1}", collectionName, collectionMapping);
                return new DescribeCollectionResponse(new Response(Response.Status.SUCCESS), collectionMapping);
            }
            this.logSevere("Describe Collection `{0}` failed:\n{1}", collectionName, response.getStatus().toString());
            return new DescribeCollectionResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("describeCollection RPC failed:\n{0}", e.getStatus().toString());
            return new DescribeCollectionResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public ShowCollectionsResponse showCollections() {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ShowCollectionsResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<String>());
        }
        Command request = Command.newBuilder().setCmd("").build();
        try {
            TableNameList response = this.blockingStub.showTables(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                ProtocolStringList collectionNames = response.getTableNamesList();
                this.logInfo("Current collections: {0}", collectionNames.toString());
                return new ShowCollectionsResponse(new Response(Response.Status.SUCCESS), (List<String>)collectionNames);
            }
            this.logSevere("Show collections failed:\n{0}", response.getStatus().toString());
            return new ShowCollectionsResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<String>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("showCollections RPC failed:\n{0}", e.getStatus().toString());
            return new ShowCollectionsResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<String>());
        }
    }

    @Override
    public GetCollectionRowCountResponse getCollectionRowCount(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetCollectionRowCountResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), 0L);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            TableRowCount response = this.blockingStub.countTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                long collectionRowCount = response.getTableRowCount();
                this.logInfo("Collection `{0}` has {1} rows", collectionName, collectionRowCount);
                return new GetCollectionRowCountResponse(new Response(Response.Status.SUCCESS), collectionRowCount);
            }
            this.logSevere("Get collection `{0}` row count failed:\n{1}", collectionName, response.getStatus().toString());
            return new GetCollectionRowCountResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), 0L);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("countCollection RPC failed:\n{0}", e.getStatus().toString());
            return new GetCollectionRowCountResponse(new Response(Response.Status.RPC_ERROR, e.toString()), 0L);
        }
    }

    @Override
    public Response getServerStatus() {
        return this.command("status");
    }

    @Override
    public Response getServerVersion() {
        return this.command("version");
    }

    @Override
    public Response command(@Nonnull String command) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        Command request = Command.newBuilder().setCmd(command).build();
        try {
            StringReply response = this.blockingStub.cmd(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Command `{0}`: {1}", command, response.getStringReply());
                return new Response(Response.Status.SUCCESS, response.getStringReply());
            }
            this.logSevere("Command `{0}` failed:\n{1}", command, response.toString());
            return new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("Command RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response preloadCollection(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            Status response = this.blockingStub.preloadTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Preloaded collection `{0}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Preload collection `{0}` failed:\n{1}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("preloadCollection RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public DescribeIndexResponse describeIndex(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new DescribeIndexResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            IndexParam response = this.blockingStub.describeIndex(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                String extraParam = "";
                for (KeyValuePair kv : response.getExtraParamsList()) {
                    if (!kv.getKey().contentEquals("params")) continue;
                    extraParam = kv.getValue();
                }
                Index index = new Index.Builder(response.getTableName(), IndexType.valueOf(response.getIndexType())).withParamsInJson(extraParam).build();
                this.logInfo("Describe index for collection `{0}` returned:\n{1}", collectionName, index.toString());
                return new DescribeIndexResponse(new Response(Response.Status.SUCCESS), index);
            }
            this.logSevere("Describe index for collection `{0}` failed:\n{1}", collectionName, response.getStatus().toString());
            return new DescribeIndexResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("describeIndex RPC failed:\n{0}", e.getStatus().toString());
            return new DescribeIndexResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public Response dropIndex(@Nonnull String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            Status response = this.blockingStub.dropIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped index for collection `{0}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Drop index for collection `{0}` failed:\n{1}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("dropIndex RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public ShowCollectionInfoResponse showCollectionInfo(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ShowCollectionInfoResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            TableInfo response = this.blockingStub.showTableInfo(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                ArrayList<CollectionInfo.PartitionInfo> partitionInfos = new ArrayList<CollectionInfo.PartitionInfo>();
                for (PartitionStat partitionStat : response.getPartitionsStatList()) {
                    ArrayList<CollectionInfo.PartitionInfo.SegmentInfo> segmentInfos = new ArrayList<CollectionInfo.PartitionInfo.SegmentInfo>();
                    for (SegmentStat segmentStat : partitionStat.getSegmentsStatList()) {
                        CollectionInfo.PartitionInfo.SegmentInfo segmentInfo = new CollectionInfo.PartitionInfo.SegmentInfo(segmentStat.getSegmentName(), segmentStat.getRowCount(), segmentStat.getIndexName(), segmentStat.getDataSize());
                        segmentInfos.add(segmentInfo);
                    }
                    CollectionInfo.PartitionInfo partitionInfo = new CollectionInfo.PartitionInfo(partitionStat.getTag(), partitionStat.getTotalRowCount(), segmentInfos);
                    partitionInfos.add(partitionInfo);
                }
                CollectionInfo collectionInfo = new CollectionInfo(response.getTotalRowCount(), partitionInfos);
                this.logInfo("ShowCollectionInfo for `{0}` returned successfully!", collectionName);
                return new ShowCollectionInfoResponse(new Response(Response.Status.SUCCESS), collectionInfo);
            }
            this.logSevere("ShowCollectionInfo for `{0}` failed:\n{1}", collectionName, response.getStatus().toString());
            return new ShowCollectionInfoResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("describeIndex RPC failed:\n{0}", e.getStatus().toString());
            return new ShowCollectionInfoResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public GetVectorByIdResponse getVectorById(String collectionName, Long id) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetVectorByIdResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<Float>(), null);
        }
        VectorIdentity request = VectorIdentity.newBuilder().setTableName(collectionName).setId(id).build();
        try {
            VectorData response = this.blockingStub.getVectorByID(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("getVectorById for id={0} in collection `{1}` returned successfully!", String.valueOf(id), collectionName);
                return new GetVectorByIdResponse(new Response(Response.Status.SUCCESS), response.getVectorData().getFloatDataList(), response.getVectorData().getBinaryData().asReadOnlyByteBuffer());
            }
            this.logSevere("getVectorById for `{0}` in collection `{1}` failed:\n{2}", String.valueOf(id), collectionName, response.getStatus().toString());
            return new GetVectorByIdResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<Float>(), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("getVectorById RPC failed:\n{0}", e.getStatus().toString());
            return new GetVectorByIdResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<Float>(), null);
        }
    }

    @Override
    public GetVectorIdsResponse getVectorIds(String collectionName, String segmentName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetVectorIdsResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<Long>());
        }
        GetVectorIDsParam request = GetVectorIDsParam.newBuilder().setTableName(collectionName).setSegmentName(segmentName).build();
        try {
            VectorIds response = this.blockingStub.getVectorIDs(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("getVectorIds in collection `{0}`, segment `{1}` returned successfully!", collectionName, segmentName);
                return new GetVectorIdsResponse(new Response(Response.Status.SUCCESS), response.getVectorIdArrayList());
            }
            this.logSevere("getVectorIds in collection `{0}`, segment `{1}` failed:\n{2}", collectionName, segmentName, response.getStatus().toString());
            return new GetVectorIdsResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<Long>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("getVectorIds RPC failed:\n{0}", e.getStatus().toString());
            return new GetVectorIdsResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<Long>());
        }
    }

    @Override
    public Response deleteByIds(String collectionName, List<Long> ids) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        DeleteByIDParam request = DeleteByIDParam.newBuilder().setTableName(collectionName).addAllIdArray(ids).build();
        try {
            Status response = this.blockingStub.deleteByID(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("deleteByIds in collection `{0}` completed successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("deleteByIds in collection `{0}` failed:\n{1}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("deleteByIds RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response deleteById(String collectionName, final Long id) {
        ArrayList<Long> list = new ArrayList<Long>(){
            {
                this.add(id);
            }
        };
        return this.deleteByIds(collectionName, (List<Long>)list);
    }

    @Override
    public Response flush(List<String> collectionNames) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        FlushParam request = FlushParam.newBuilder().addAllTableNameArray(collectionNames).build();
        try {
            Status response = this.blockingStub.flush(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Flushed collection {0} successfully!", collectionNames);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Flush collection {0} failed:\n{1}", collectionNames, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("flush RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response flush(final String collectionName) {
        ArrayList<String> list = new ArrayList<String>(){
            {
                this.add(collectionName);
            }
        };
        return this.flush((List<String>)list);
    }

    @Override
    public Response compact(String collectionName) {
        if (!this.channelIsReadyOrIdle()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        TableName request = TableName.newBuilder().setTableName(collectionName).build();
        try {
            Status response = this.blockingStub.compact(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Compacted collection `{0}` successfully!", collectionName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Compact collection `{0}` failed:\n{1}", collectionName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("compact RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    private List<RowRecord> buildRowRecordList(@Nonnull List<List<Float>> floatVectors, @Nonnull List<ByteBuffer> binaryVectors) {
        ArrayList<RowRecord> rowRecordList = new ArrayList<RowRecord>();
        int largerSize = Math.max(floatVectors.size(), binaryVectors.size());
        for (int i = 0; i < largerSize; ++i) {
            RowRecord.Builder rowRecordBuilder = RowRecord.newBuilder();
            if (i < floatVectors.size()) {
                rowRecordBuilder.addAllFloatData((Iterable<? extends Float>)floatVectors.get(i));
            }
            if (i < binaryVectors.size()) {
                ((Buffer)binaryVectors.get(i)).rewind();
                rowRecordBuilder.setBinaryData(ByteString.copyFrom((ByteBuffer)binaryVectors.get(i)));
            }
            rowRecordList.add(rowRecordBuilder.build());
        }
        return rowRecordList;
    }

    private SearchResponse buildSearchResponse(TopKQueryResult topKQueryResult) {
        int numQueries = (int)topKQueryResult.getRowNum();
        int topK = numQueries == 0 ? 0 : topKQueryResult.getIdsCount() / numQueries;
        ArrayList<List<Long>> resultIdsList = new ArrayList();
        ArrayList<List<Float>> resultDistancesList = new ArrayList();
        if (topK > 0) {
            resultIdsList = ListUtils.partition(topKQueryResult.getIdsList(), (int)topK);
            resultDistancesList = ListUtils.partition(topKQueryResult.getDistancesList(), (int)topK);
        }
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setNumQueries(numQueries);
        searchResponse.setTopK(topK);
        searchResponse.setResultIdsList(resultIdsList);
        searchResponse.setResultDistancesList(resultDistancesList);
        return searchResponse;
    }

    private boolean channelIsReadyOrIdle() {
        if (this.channel == null) {
            return false;
        }
        ConnectivityState connectivityState = this.channel.getState(false);
        return connectivityState == ConnectivityState.READY || connectivityState == ConnectivityState.IDLE;
    }

    private void logInfo(String msg, Object ... params) {
        logger.log(Level.INFO, ANSI_YELLOW + msg + ANSI_RESET, params);
    }

    private void logWarning(String msg, Object ... params) {
        logger.log(Level.WARNING, ANSI_PURPLE + msg + ANSI_RESET, params);
    }

    private void logSevere(String msg, Object ... params) {
        logger.log(Level.SEVERE, ANSI_BRIGHT_PURPLE + msg + ANSI_RESET, params);
    }
}

