/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.Response;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;

public class GetVectorByIdResponse {
    private final Response response;
    private final List<Float> floatVector;
    private final ByteBuffer binaryVector;

    GetVectorByIdResponse(Response response, List<Float> floatVector, ByteBuffer binaryVector) {
        this.response = response;
        this.floatVector = floatVector;
        this.binaryVector = binaryVector;
    }

    public List<Float> getFloatVector() {
        return this.floatVector;
    }

    public Optional<ByteBuffer> getBinaryVector() {
        return Optional.ofNullable(this.binaryVector);
    }

    public boolean isFloatVector() {
        return !this.floatVector.isEmpty();
    }

    public boolean isBinaryVector() {
        return this.binaryVector != null && this.binaryVector.hasRemaining();
    }

    public boolean exists() {
        return this.isFloatVector() || this.isBinaryVector();
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean ok() {
        return this.response.ok();
    }
}

