package io.milvus.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.27.2)",
    comments = "Source: milvus.proto")
public final class MilvusServiceGrpc {

  private MilvusServiceGrpc() {}

  public static final String SERVICE_NAME = "milvus.grpc.MilvusService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema,
      io.milvus.grpc.Status> getCreateTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateTable",
      requestType = io.milvus.grpc.TableSchema.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema,
      io.milvus.grpc.Status> getCreateTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema, io.milvus.grpc.Status> getCreateTableMethod;
    if ((getCreateTableMethod = MilvusServiceGrpc.getCreateTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateTableMethod = MilvusServiceGrpc.getCreateTableMethod) == null) {
          MilvusServiceGrpc.getCreateTableMethod = getCreateTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableSchema, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableSchema.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateTable"))
              .build();
        }
      }
    }
    return getCreateTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.BoolReply> getHasTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "HasTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.BoolReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.BoolReply> getHasTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.BoolReply> getHasTableMethod;
    if ((getHasTableMethod = MilvusServiceGrpc.getHasTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getHasTableMethod = MilvusServiceGrpc.getHasTableMethod) == null) {
          MilvusServiceGrpc.getHasTableMethod = getHasTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.BoolReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "HasTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.BoolReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("HasTable"))
              .build();
        }
      }
    }
    return getHasTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableSchema> getDescribeTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.TableSchema.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableSchema> getDescribeTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.TableSchema> getDescribeTableMethod;
    if ((getDescribeTableMethod = MilvusServiceGrpc.getDescribeTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeTableMethod = MilvusServiceGrpc.getDescribeTableMethod) == null) {
          MilvusServiceGrpc.getDescribeTableMethod = getDescribeTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.TableSchema>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableSchema.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeTable"))
              .build();
        }
      }
    }
    return getDescribeTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableRowCount> getCountTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CountTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.TableRowCount.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableRowCount> getCountTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.TableRowCount> getCountTableMethod;
    if ((getCountTableMethod = MilvusServiceGrpc.getCountTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCountTableMethod = MilvusServiceGrpc.getCountTableMethod) == null) {
          MilvusServiceGrpc.getCountTableMethod = getCountTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.TableRowCount>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CountTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableRowCount.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CountTable"))
              .build();
        }
      }
    }
    return getCountTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.TableNameList> getShowTablesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowTables",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.TableNameList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.TableNameList> getShowTablesMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.TableNameList> getShowTablesMethod;
    if ((getShowTablesMethod = MilvusServiceGrpc.getShowTablesMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowTablesMethod = MilvusServiceGrpc.getShowTablesMethod) == null) {
          MilvusServiceGrpc.getShowTablesMethod = getShowTablesMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.TableNameList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowTables"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableNameList.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowTables"))
              .build();
        }
      }
    }
    return getShowTablesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableInfo> getShowTableInfoMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowTableInfo",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.TableInfo.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableInfo> getShowTableInfoMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.TableInfo> getShowTableInfoMethod;
    if ((getShowTableInfoMethod = MilvusServiceGrpc.getShowTableInfoMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowTableInfoMethod = MilvusServiceGrpc.getShowTableInfoMethod) == null) {
          MilvusServiceGrpc.getShowTableInfoMethod = getShowTableInfoMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.TableInfo>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowTableInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableInfo.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowTableInfo"))
              .build();
        }
      }
    }
    return getShowTableInfoMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getDropTableMethod;
    if ((getDropTableMethod = MilvusServiceGrpc.getDropTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropTableMethod = MilvusServiceGrpc.getDropTableMethod) == null) {
          MilvusServiceGrpc.getDropTableMethod = getDropTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropTable"))
              .build();
        }
      }
    }
    return getDropTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateIndex",
      requestType = io.milvus.grpc.IndexParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam, io.milvus.grpc.Status> getCreateIndexMethod;
    if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
          MilvusServiceGrpc.getCreateIndexMethod = getCreateIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.IndexParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateIndex"))
              .build();
        }
      }
    }
    return getCreateIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeIndex",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.IndexParam.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.IndexParam> getDescribeIndexMethod;
    if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
          MilvusServiceGrpc.getDescribeIndexMethod = getDescribeIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.IndexParam>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeIndex"))
              .build();
        }
      }
    }
    return getDescribeIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropIndex",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getDropIndexMethod;
    if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
          MilvusServiceGrpc.getDropIndexMethod = getDropIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropIndex"))
              .build();
        }
      }
    }
    return getDropIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getCreatePartitionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreatePartition",
      requestType = io.milvus.grpc.PartitionParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getCreatePartitionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status> getCreatePartitionMethod;
    if ((getCreatePartitionMethod = MilvusServiceGrpc.getCreatePartitionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreatePartitionMethod = MilvusServiceGrpc.getCreatePartitionMethod) == null) {
          MilvusServiceGrpc.getCreatePartitionMethod = getCreatePartitionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreatePartition"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreatePartition"))
              .build();
        }
      }
    }
    return getCreatePartitionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.PartitionList> getShowPartitionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowPartitions",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.PartitionList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.PartitionList> getShowPartitionsMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.PartitionList> getShowPartitionsMethod;
    if ((getShowPartitionsMethod = MilvusServiceGrpc.getShowPartitionsMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowPartitionsMethod = MilvusServiceGrpc.getShowPartitionsMethod) == null) {
          MilvusServiceGrpc.getShowPartitionsMethod = getShowPartitionsMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.PartitionList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowPartitions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionList.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowPartitions"))
              .build();
        }
      }
    }
    return getShowPartitionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getDropPartitionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropPartition",
      requestType = io.milvus.grpc.PartitionParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam,
      io.milvus.grpc.Status> getDropPartitionMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status> getDropPartitionMethod;
    if ((getDropPartitionMethod = MilvusServiceGrpc.getDropPartitionMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropPartitionMethod = MilvusServiceGrpc.getDropPartitionMethod) == null) {
          MilvusServiceGrpc.getDropPartitionMethod = getDropPartitionMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.PartitionParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropPartition"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.PartitionParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropPartition"))
              .build();
        }
      }
    }
    return getDropPartitionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Insert",
      requestType = io.milvus.grpc.InsertParam.class,
      responseType = io.milvus.grpc.VectorIds.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds> getInsertMethod;
    if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
          MilvusServiceGrpc.getInsertMethod = getInsertMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Insert"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.InsertParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIds.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Insert"))
              .build();
        }
      }
    }
    return getInsertMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.VectorIdentity,
      io.milvus.grpc.VectorData> getGetVectorByIDMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetVectorByID",
      requestType = io.milvus.grpc.VectorIdentity.class,
      responseType = io.milvus.grpc.VectorData.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.VectorIdentity,
      io.milvus.grpc.VectorData> getGetVectorByIDMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.VectorIdentity, io.milvus.grpc.VectorData> getGetVectorByIDMethod;
    if ((getGetVectorByIDMethod = MilvusServiceGrpc.getGetVectorByIDMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getGetVectorByIDMethod = MilvusServiceGrpc.getGetVectorByIDMethod) == null) {
          MilvusServiceGrpc.getGetVectorByIDMethod = getGetVectorByIDMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.VectorIdentity, io.milvus.grpc.VectorData>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetVectorByID"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIdentity.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorData.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("GetVectorByID"))
              .build();
        }
      }
    }
    return getGetVectorByIDMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam,
      io.milvus.grpc.VectorIds> getGetVectorIDsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetVectorIDs",
      requestType = io.milvus.grpc.GetVectorIDsParam.class,
      responseType = io.milvus.grpc.VectorIds.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam,
      io.milvus.grpc.VectorIds> getGetVectorIDsMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.GetVectorIDsParam, io.milvus.grpc.VectorIds> getGetVectorIDsMethod;
    if ((getGetVectorIDsMethod = MilvusServiceGrpc.getGetVectorIDsMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getGetVectorIDsMethod = MilvusServiceGrpc.getGetVectorIDsMethod) == null) {
          MilvusServiceGrpc.getGetVectorIDsMethod = getGetVectorIDsMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.GetVectorIDsParam, io.milvus.grpc.VectorIds>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetVectorIDs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.GetVectorIDsParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIds.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("GetVectorIDs"))
              .build();
        }
      }
    }
    return getGetVectorIDsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Search",
      requestType = io.milvus.grpc.SearchParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult> getSearchMethod;
    if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
          MilvusServiceGrpc.getSearchMethod = getSearchMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Search"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Search"))
              .build();
        }
      }
    }
    return getSearchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SearchInFiles",
      requestType = io.milvus.grpc.SearchInFilesParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;
    if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
          MilvusServiceGrpc.getSearchInFilesMethod = getSearchInFilesMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SearchInFiles"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchInFilesParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("SearchInFiles"))
              .build();
        }
      }
    }
    return getSearchInFilesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Cmd",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.StringReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.StringReply> getCmdMethod;
    if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
          MilvusServiceGrpc.getCmdMethod = getCmdMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.StringReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Cmd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.StringReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Cmd"))
              .build();
        }
      }
    }
    return getCmdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam,
      io.milvus.grpc.Status> getDeleteByIDMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteByID",
      requestType = io.milvus.grpc.DeleteByIDParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam,
      io.milvus.grpc.Status> getDeleteByIDMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByIDParam, io.milvus.grpc.Status> getDeleteByIDMethod;
    if ((getDeleteByIDMethod = MilvusServiceGrpc.getDeleteByIDMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDeleteByIDMethod = MilvusServiceGrpc.getDeleteByIDMethod) == null) {
          MilvusServiceGrpc.getDeleteByIDMethod = getDeleteByIDMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.DeleteByIDParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteByID"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.DeleteByIDParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DeleteByID"))
              .build();
        }
      }
    }
    return getDeleteByIDMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getPreloadTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PreloadTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getPreloadTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getPreloadTableMethod;
    if ((getPreloadTableMethod = MilvusServiceGrpc.getPreloadTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getPreloadTableMethod = MilvusServiceGrpc.getPreloadTableMethod) == null) {
          MilvusServiceGrpc.getPreloadTableMethod = getPreloadTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PreloadTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("PreloadTable"))
              .build();
        }
      }
    }
    return getPreloadTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam,
      io.milvus.grpc.Status> getFlushMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Flush",
      requestType = io.milvus.grpc.FlushParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam,
      io.milvus.grpc.Status> getFlushMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.FlushParam, io.milvus.grpc.Status> getFlushMethod;
    if ((getFlushMethod = MilvusServiceGrpc.getFlushMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getFlushMethod = MilvusServiceGrpc.getFlushMethod) == null) {
          MilvusServiceGrpc.getFlushMethod = getFlushMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.FlushParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Flush"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.FlushParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Flush"))
              .build();
        }
      }
    }
    return getFlushMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getCompactMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Compact",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getCompactMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getCompactMethod;
    if ((getCompactMethod = MilvusServiceGrpc.getCompactMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCompactMethod = MilvusServiceGrpc.getCompactMethod) == null) {
          MilvusServiceGrpc.getCompactMethod = getCompactMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Compact"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Compact"))
              .build();
        }
      }
    }
    return getCompactMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MilvusServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceStub>() {
        @java.lang.Override
        public MilvusServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceStub(channel, callOptions);
        }
      };
    return MilvusServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MilvusServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceBlockingStub>() {
        @java.lang.Override
        public MilvusServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceBlockingStub(channel, callOptions);
        }
      };
    return MilvusServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MilvusServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<MilvusServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<MilvusServiceFutureStub>() {
        @java.lang.Override
        public MilvusServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new MilvusServiceFutureStub(channel, callOptions);
        }
      };
    return MilvusServiceFutureStub.newStub(factory, channel);
  }

  /**
   */
  public static abstract class MilvusServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     **
     * &#64;brief This method is used to create table
     * &#64;param TableSchema, use to provide table information to be created.
     * &#64;return Status
     * </pre>
     */
    public void createTable(io.milvus.grpc.TableSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test table existence.
     * &#64;param TableName, table name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnimplementedUnaryCall(getHasTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableSchema
     * </pre>
     */
    public void describeTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableRowCount
     * </pre>
     */
    public void countTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount> responseObserver) {
      asyncUnimplementedUnaryCall(getCountTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all tables.
     * &#64;param Command, dummy parameter.
     * &#64;return TableNameList
     * </pre>
     */
    public void showTables(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList> responseObserver) {
      asyncUnimplementedUnaryCall(getShowTablesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table detail information.
     * &#64;param TableName, target table name.
     * &#64;return TableInfo
     * </pre>
     */
    public void showTableInfo(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableInfo> responseObserver) {
      asyncUnimplementedUnaryCall(getShowTableInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete table.
     * &#64;param TableName, table name is going to be deleted.
     * &#64;return TableNameList
     * </pre>
     */
    public void dropTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by table in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param TableName, target table name.
     * &#64;return IndexParam
     * </pre>
     */
    public void describeIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void dropIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropIndexMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public void createPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreatePartitionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param TableName, target table name.
     * &#64;return PartitionList
     * </pre>
     */
    public void showPartitions(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList> responseObserver) {
      asyncUnimplementedUnaryCall(getShowPartitionsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public void dropPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropPartitionMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to table.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnimplementedUnaryCall(getInsertMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector data by id.
     * &#64;param VectorIdentity, target vector id.
     * &#64;return VectorData
     * </pre>
     */
    public void getVectorByID(io.milvus.grpc.VectorIdentity request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorData> responseObserver) {
      asyncUnimplementedUnaryCall(getGetVectorByIDMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target table and segment
     * &#64;return VectorIds
     * </pre>
     */
    public void getVectorIDs(io.milvus.grpc.GetVectorIDsParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnimplementedUnaryCall(getGetVectorIDsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in table.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchInFilesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnimplementedUnaryCall(getCmdMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public void deleteByID(io.milvus.grpc.DeleteByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteByIDMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void preloadTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getPreloadTableMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public void flush(io.milvus.grpc.FlushParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getFlushMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void compact(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCompactMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableSchema,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_TABLE)))
          .addMethod(
            getHasTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.BoolReply>(
                  this, METHODID_HAS_TABLE)))
          .addMethod(
            getDescribeTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.TableSchema>(
                  this, METHODID_DESCRIBE_TABLE)))
          .addMethod(
            getCountTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.TableRowCount>(
                  this, METHODID_COUNT_TABLE)))
          .addMethod(
            getShowTablesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.TableNameList>(
                  this, METHODID_SHOW_TABLES)))
          .addMethod(
            getShowTableInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.TableInfo>(
                  this, METHODID_SHOW_TABLE_INFO)))
          .addMethod(
            getDropTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_TABLE)))
          .addMethod(
            getCreateIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.IndexParam,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_INDEX)))
          .addMethod(
            getDescribeIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.IndexParam>(
                  this, METHODID_DESCRIBE_INDEX)))
          .addMethod(
            getDropIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_INDEX)))
          .addMethod(
            getCreatePartitionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.PartitionParam,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_PARTITION)))
          .addMethod(
            getShowPartitionsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.PartitionList>(
                  this, METHODID_SHOW_PARTITIONS)))
          .addMethod(
            getDropPartitionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.PartitionParam,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_PARTITION)))
          .addMethod(
            getInsertMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.InsertParam,
                io.milvus.grpc.VectorIds>(
                  this, METHODID_INSERT)))
          .addMethod(
            getGetVectorByIDMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.VectorIdentity,
                io.milvus.grpc.VectorData>(
                  this, METHODID_GET_VECTOR_BY_ID)))
          .addMethod(
            getGetVectorIDsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.GetVectorIDsParam,
                io.milvus.grpc.VectorIds>(
                  this, METHODID_GET_VECTOR_IDS)))
          .addMethod(
            getSearchMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH)))
          .addMethod(
            getSearchInFilesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchInFilesParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH_IN_FILES)))
          .addMethod(
            getCmdMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.StringReply>(
                  this, METHODID_CMD)))
          .addMethod(
            getDeleteByIDMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.DeleteByIDParam,
                io.milvus.grpc.Status>(
                  this, METHODID_DELETE_BY_ID)))
          .addMethod(
            getPreloadTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_PRELOAD_TABLE)))
          .addMethod(
            getFlushMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.FlushParam,
                io.milvus.grpc.Status>(
                  this, METHODID_FLUSH)))
          .addMethod(
            getCompactMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_COMPACT)))
          .build();
    }
  }

  /**
   */
  public static final class MilvusServiceStub extends io.grpc.stub.AbstractAsyncStub<MilvusServiceStub> {
    private MilvusServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create table
     * &#64;param TableSchema, use to provide table information to be created.
     * &#64;return Status
     * </pre>
     */
    public void createTable(io.milvus.grpc.TableSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test table existence.
     * &#64;param TableName, table name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public void hasTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getHasTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableSchema
     * </pre>
     */
    public void describeTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableRowCount
     * </pre>
     */
    public void countTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCountTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all tables.
     * &#64;param Command, dummy parameter.
     * &#64;return TableNameList
     * </pre>
     */
    public void showTables(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowTablesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table detail information.
     * &#64;param TableName, target table name.
     * &#64;return TableInfo
     * </pre>
     */
    public void showTableInfo(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableInfo> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowTableInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete table.
     * &#64;param TableName, table name is going to be deleted.
     * &#64;return TableNameList
     * </pre>
     */
    public void dropTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by table in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param TableName, target table name.
     * &#64;return IndexParam
     * </pre>
     */
    public void describeIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void dropIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public void createPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreatePartitionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param TableName, target table name.
     * &#64;return PartitionList
     * </pre>
     */
    public void showPartitions(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowPartitionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public void dropPartition(io.milvus.grpc.PartitionParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropPartitionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to table.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector data by id.
     * &#64;param VectorIdentity, target vector id.
     * &#64;return VectorData
     * </pre>
     */
    public void getVectorByID(io.milvus.grpc.VectorIdentity request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorData> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetVectorByIDMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target table and segment
     * &#64;return VectorIds
     * </pre>
     */
    public void getVectorIDs(io.milvus.grpc.GetVectorIDsParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetVectorIDsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in table.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public void deleteByID(io.milvus.grpc.DeleteByIDParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteByIDMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void preloadTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPreloadTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public void flush(io.milvus.grpc.FlushParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFlushMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public void compact(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCompactMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class MilvusServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<MilvusServiceBlockingStub> {
    private MilvusServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create table
     * &#64;param TableSchema, use to provide table information to be created.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createTable(io.milvus.grpc.TableSchema request) {
      return blockingUnaryCall(
          getChannel(), getCreateTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test table existence.
     * &#64;param TableName, table name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public io.milvus.grpc.BoolReply hasTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getHasTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableSchema
     * </pre>
     */
    public io.milvus.grpc.TableSchema describeTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableRowCount
     * </pre>
     */
    public io.milvus.grpc.TableRowCount countTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getCountTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all tables.
     * &#64;param Command, dummy parameter.
     * &#64;return TableNameList
     * </pre>
     */
    public io.milvus.grpc.TableNameList showTables(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getShowTablesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table detail information.
     * &#64;param TableName, target table name.
     * &#64;return TableInfo
     * </pre>
     */
    public io.milvus.grpc.TableInfo showTableInfo(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getShowTableInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete table.
     * &#64;param TableName, table name is going to be deleted.
     * &#64;return TableNameList
     * </pre>
     */
    public io.milvus.grpc.Status dropTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDropTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by table in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createIndex(io.milvus.grpc.IndexParam request) {
      return blockingUnaryCall(
          getChannel(), getCreateIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param TableName, target table name.
     * &#64;return IndexParam
     * </pre>
     */
    public io.milvus.grpc.IndexParam describeIndex(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status dropIndex(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDropIndexMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status createPartition(io.milvus.grpc.PartitionParam request) {
      return blockingUnaryCall(
          getChannel(), getCreatePartitionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param TableName, target table name.
     * &#64;return PartitionList
     * </pre>
     */
    public io.milvus.grpc.PartitionList showPartitions(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getShowPartitionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status dropPartition(io.milvus.grpc.PartitionParam request) {
      return blockingUnaryCall(
          getChannel(), getDropPartitionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to table.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public io.milvus.grpc.VectorIds insert(io.milvus.grpc.InsertParam request) {
      return blockingUnaryCall(
          getChannel(), getInsertMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector data by id.
     * &#64;param VectorIdentity, target vector id.
     * &#64;return VectorData
     * </pre>
     */
    public io.milvus.grpc.VectorData getVectorByID(io.milvus.grpc.VectorIdentity request) {
      return blockingUnaryCall(
          getChannel(), getGetVectorByIDMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target table and segment
     * &#64;return VectorIds
     * </pre>
     */
    public io.milvus.grpc.VectorIds getVectorIDs(io.milvus.grpc.GetVectorIDsParam request) {
      return blockingUnaryCall(
          getChannel(), getGetVectorIDsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in table.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public io.milvus.grpc.TopKQueryResult search(io.milvus.grpc.SearchParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public io.milvus.grpc.TopKQueryResult searchInFiles(io.milvus.grpc.SearchInFilesParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchInFilesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public io.milvus.grpc.StringReply cmd(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getCmdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public io.milvus.grpc.Status deleteByID(io.milvus.grpc.DeleteByIDParam request) {
      return blockingUnaryCall(
          getChannel(), getDeleteByIDMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status preloadTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getPreloadTableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status flush(io.milvus.grpc.FlushParam request) {
      return blockingUnaryCall(
          getChannel(), getFlushMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public io.milvus.grpc.Status compact(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getCompactMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class MilvusServiceFutureStub extends io.grpc.stub.AbstractFutureStub<MilvusServiceFutureStub> {
    private MilvusServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new MilvusServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create table
     * &#64;param TableSchema, use to provide table information to be created.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createTable(
        io.milvus.grpc.TableSchema request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to test table existence.
     * &#64;param TableName, table name is going to be tested.
     * &#64;return BoolReply
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.BoolReply> hasTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getHasTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableSchema
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableSchema> describeTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table schema.
     * &#64;param TableName, target table name.
     * &#64;return TableRowCount
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableRowCount> countTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getCountTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to list all tables.
     * &#64;param Command, dummy parameter.
     * &#64;return TableNameList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableNameList> showTables(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getShowTablesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get table detail information.
     * &#64;param TableName, target table name.
     * &#64;return TableInfo
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableInfo> showTableInfo(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getShowTableInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete table.
     * &#64;param TableName, table name is going to be deleted.
     * &#64;return TableNameList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to build index by table in sync mode.
     * &#64;param IndexParam, index paramters.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createIndex(
        io.milvus.grpc.IndexParam request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to describe index
     * &#64;param TableName, target table name.
     * &#64;return IndexParam
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.IndexParam> describeIndex(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop index
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropIndex(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to create partition
     * &#64;param PartitionParam, partition parameters.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createPartition(
        io.milvus.grpc.PartitionParam request) {
      return futureUnaryCall(
          getChannel().newCall(getCreatePartitionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to show partition information
     * &#64;param TableName, target table name.
     * &#64;return PartitionList
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.PartitionList> showPartitions(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getShowPartitionsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to drop partition
     * &#64;param PartitionParam, target partition.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropPartition(
        io.milvus.grpc.PartitionParam request) {
      return futureUnaryCall(
          getChannel().newCall(getDropPartitionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to add vector array to table.
     * &#64;param InsertParam, insert parameters.
     * &#64;return VectorIds
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorIds> insert(
        io.milvus.grpc.InsertParam request) {
      return futureUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector data by id.
     * &#64;param VectorIdentity, target vector id.
     * &#64;return VectorData
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorData> getVectorByID(
        io.milvus.grpc.VectorIdentity request) {
      return futureUnaryCall(
          getChannel().newCall(getGetVectorByIDMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to get vector ids from a segment
     * &#64;param GetVectorIDsParam, target table and segment
     * &#64;return VectorIds
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorIds> getVectorIDs(
        io.milvus.grpc.GetVectorIDsParam request) {
      return futureUnaryCall(
          getChannel().newCall(getGetVectorIDsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in table.
     * &#64;param SearchParam, search parameters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> search(
        io.milvus.grpc.SearchParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to query vector in specified files.
     * &#64;param SearchInFilesParam, search in files paremeters.
     * &#64;return TopKQueryResult
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> searchInFiles(
        io.milvus.grpc.SearchInFilesParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to give the server status.
     * &#64;param Command, command string
     * &#64;return StringReply
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.StringReply> cmd(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to delete vector by id
     * &#64;param DeleteByIDParam, delete parameters.
     * &#64;return status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> deleteByID(
        io.milvus.grpc.DeleteByIDParam request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteByIDMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to preload table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> preloadTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getPreloadTableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to flush buffer into storage.
     * &#64;param FlushParam, flush parameters
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> flush(
        io.milvus.grpc.FlushParam request) {
      return futureUnaryCall(
          getChannel().newCall(getFlushMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * &#64;brief This method is used to compact table
     * &#64;param TableName, target table name.
     * &#64;return Status
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> compact(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getCompactMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_TABLE = 0;
  private static final int METHODID_HAS_TABLE = 1;
  private static final int METHODID_DESCRIBE_TABLE = 2;
  private static final int METHODID_COUNT_TABLE = 3;
  private static final int METHODID_SHOW_TABLES = 4;
  private static final int METHODID_SHOW_TABLE_INFO = 5;
  private static final int METHODID_DROP_TABLE = 6;
  private static final int METHODID_CREATE_INDEX = 7;
  private static final int METHODID_DESCRIBE_INDEX = 8;
  private static final int METHODID_DROP_INDEX = 9;
  private static final int METHODID_CREATE_PARTITION = 10;
  private static final int METHODID_SHOW_PARTITIONS = 11;
  private static final int METHODID_DROP_PARTITION = 12;
  private static final int METHODID_INSERT = 13;
  private static final int METHODID_GET_VECTOR_BY_ID = 14;
  private static final int METHODID_GET_VECTOR_IDS = 15;
  private static final int METHODID_SEARCH = 16;
  private static final int METHODID_SEARCH_IN_FILES = 17;
  private static final int METHODID_CMD = 18;
  private static final int METHODID_DELETE_BY_ID = 19;
  private static final int METHODID_PRELOAD_TABLE = 20;
  private static final int METHODID_FLUSH = 21;
  private static final int METHODID_COMPACT = 22;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MilvusServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MilvusServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_TABLE:
          serviceImpl.createTable((io.milvus.grpc.TableSchema) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_HAS_TABLE:
          serviceImpl.hasTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply>) responseObserver);
          break;
        case METHODID_DESCRIBE_TABLE:
          serviceImpl.describeTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema>) responseObserver);
          break;
        case METHODID_COUNT_TABLE:
          serviceImpl.countTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount>) responseObserver);
          break;
        case METHODID_SHOW_TABLES:
          serviceImpl.showTables((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList>) responseObserver);
          break;
        case METHODID_SHOW_TABLE_INFO:
          serviceImpl.showTableInfo((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableInfo>) responseObserver);
          break;
        case METHODID_DROP_TABLE:
          serviceImpl.dropTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_CREATE_INDEX:
          serviceImpl.createIndex((io.milvus.grpc.IndexParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_DESCRIBE_INDEX:
          serviceImpl.describeIndex((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam>) responseObserver);
          break;
        case METHODID_DROP_INDEX:
          serviceImpl.dropIndex((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_CREATE_PARTITION:
          serviceImpl.createPartition((io.milvus.grpc.PartitionParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_SHOW_PARTITIONS:
          serviceImpl.showPartitions((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.PartitionList>) responseObserver);
          break;
        case METHODID_DROP_PARTITION:
          serviceImpl.dropPartition((io.milvus.grpc.PartitionParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_INSERT:
          serviceImpl.insert((io.milvus.grpc.InsertParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds>) responseObserver);
          break;
        case METHODID_GET_VECTOR_BY_ID:
          serviceImpl.getVectorByID((io.milvus.grpc.VectorIdentity) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorData>) responseObserver);
          break;
        case METHODID_GET_VECTOR_IDS:
          serviceImpl.getVectorIDs((io.milvus.grpc.GetVectorIDsParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds>) responseObserver);
          break;
        case METHODID_SEARCH:
          serviceImpl.search((io.milvus.grpc.SearchParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_SEARCH_IN_FILES:
          serviceImpl.searchInFiles((io.milvus.grpc.SearchInFilesParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_CMD:
          serviceImpl.cmd((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply>) responseObserver);
          break;
        case METHODID_DELETE_BY_ID:
          serviceImpl.deleteByID((io.milvus.grpc.DeleteByIDParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_PRELOAD_TABLE:
          serviceImpl.preloadTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_FLUSH:
          serviceImpl.flush((io.milvus.grpc.FlushParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_COMPACT:
          serviceImpl.compact((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MilvusServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.milvus.grpc.MilvusProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MilvusService");
    }
  }

  private static final class MilvusServiceFileDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier {
    MilvusServiceFileDescriptorSupplier() {}
  }

  private static final class MilvusServiceMethodDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MilvusServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MilvusServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MilvusServiceFileDescriptorSupplier())
              .addMethod(getCreateTableMethod())
              .addMethod(getHasTableMethod())
              .addMethod(getDescribeTableMethod())
              .addMethod(getCountTableMethod())
              .addMethod(getShowTablesMethod())
              .addMethod(getShowTableInfoMethod())
              .addMethod(getDropTableMethod())
              .addMethod(getCreateIndexMethod())
              .addMethod(getDescribeIndexMethod())
              .addMethod(getDropIndexMethod())
              .addMethod(getCreatePartitionMethod())
              .addMethod(getShowPartitionsMethod())
              .addMethod(getDropPartitionMethod())
              .addMethod(getInsertMethod())
              .addMethod(getGetVectorByIDMethod())
              .addMethod(getGetVectorIDsMethod())
              .addMethod(getSearchMethod())
              .addMethod(getSearchInFilesMethod())
              .addMethod(getCmdMethod())
              .addMethod(getDeleteByIDMethod())
              .addMethod(getPreloadTableMethod())
              .addMethod(getFlushMethod())
              .addMethod(getCompactMethod())
              .build();
        }
      }
    }
    return result;
  }
}
