package io.milvus.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.24.0)",
    comments = "Source: milvus.proto")
public final class MilvusServiceGrpc {

  private MilvusServiceGrpc() {}

  public static final String SERVICE_NAME = "milvus.grpc.MilvusService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema,
      io.milvus.grpc.Status> getCreateTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateTable",
      requestType = io.milvus.grpc.TableSchema.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema,
      io.milvus.grpc.Status> getCreateTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableSchema, io.milvus.grpc.Status> getCreateTableMethod;
    if ((getCreateTableMethod = MilvusServiceGrpc.getCreateTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateTableMethod = MilvusServiceGrpc.getCreateTableMethod) == null) {
          MilvusServiceGrpc.getCreateTableMethod = getCreateTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableSchema, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableSchema.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateTable"))
              .build();
        }
      }
    }
    return getCreateTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.BoolReply> getHasTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "HasTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.BoolReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.BoolReply> getHasTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.BoolReply> getHasTableMethod;
    if ((getHasTableMethod = MilvusServiceGrpc.getHasTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getHasTableMethod = MilvusServiceGrpc.getHasTableMethod) == null) {
          MilvusServiceGrpc.getHasTableMethod = getHasTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.BoolReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "HasTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.BoolReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("HasTable"))
              .build();
        }
      }
    }
    return getHasTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getDropTableMethod;
    if ((getDropTableMethod = MilvusServiceGrpc.getDropTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropTableMethod = MilvusServiceGrpc.getDropTableMethod) == null) {
          MilvusServiceGrpc.getDropTableMethod = getDropTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropTable"))
              .build();
        }
      }
    }
    return getDropTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateIndex",
      requestType = io.milvus.grpc.IndexParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam,
      io.milvus.grpc.Status> getCreateIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.IndexParam, io.milvus.grpc.Status> getCreateIndexMethod;
    if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCreateIndexMethod = MilvusServiceGrpc.getCreateIndexMethod) == null) {
          MilvusServiceGrpc.getCreateIndexMethod = getCreateIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.IndexParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CreateIndex"))
              .build();
        }
      }
    }
    return getCreateIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Insert",
      requestType = io.milvus.grpc.InsertParam.class,
      responseType = io.milvus.grpc.VectorIds.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam,
      io.milvus.grpc.VectorIds> getInsertMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds> getInsertMethod;
    if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getInsertMethod = MilvusServiceGrpc.getInsertMethod) == null) {
          MilvusServiceGrpc.getInsertMethod = getInsertMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.InsertParam, io.milvus.grpc.VectorIds>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Insert"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.InsertParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.VectorIds.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Insert"))
              .build();
        }
      }
    }
    return getInsertMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Search",
      requestType = io.milvus.grpc.SearchParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam,
      io.milvus.grpc.TopKQueryResult> getSearchMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult> getSearchMethod;
    if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchMethod = MilvusServiceGrpc.getSearchMethod) == null) {
          MilvusServiceGrpc.getSearchMethod = getSearchMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Search"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Search"))
              .build();
        }
      }
    }
    return getSearchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SearchInFiles",
      requestType = io.milvus.grpc.SearchInFilesParam.class,
      responseType = io.milvus.grpc.TopKQueryResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam,
      io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult> getSearchInFilesMethod;
    if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getSearchInFilesMethod = MilvusServiceGrpc.getSearchInFilesMethod) == null) {
          MilvusServiceGrpc.getSearchInFilesMethod = getSearchInFilesMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.SearchInFilesParam, io.milvus.grpc.TopKQueryResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SearchInFiles"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.SearchInFilesParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TopKQueryResult.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("SearchInFiles"))
              .build();
        }
      }
    }
    return getSearchInFilesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableSchema> getDescribeTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.TableSchema.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableSchema> getDescribeTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.TableSchema> getDescribeTableMethod;
    if ((getDescribeTableMethod = MilvusServiceGrpc.getDescribeTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeTableMethod = MilvusServiceGrpc.getDescribeTableMethod) == null) {
          MilvusServiceGrpc.getDescribeTableMethod = getDescribeTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.TableSchema>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableSchema.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeTable"))
              .build();
        }
      }
    }
    return getDescribeTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableRowCount> getCountTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CountTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.TableRowCount.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.TableRowCount> getCountTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.TableRowCount> getCountTableMethod;
    if ((getCountTableMethod = MilvusServiceGrpc.getCountTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCountTableMethod = MilvusServiceGrpc.getCountTableMethod) == null) {
          MilvusServiceGrpc.getCountTableMethod = getCountTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.TableRowCount>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CountTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableRowCount.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("CountTable"))
              .build();
        }
      }
    }
    return getCountTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.TableNameList> getShowTablesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ShowTables",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.TableNameList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.TableNameList> getShowTablesMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.TableNameList> getShowTablesMethod;
    if ((getShowTablesMethod = MilvusServiceGrpc.getShowTablesMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getShowTablesMethod = MilvusServiceGrpc.getShowTablesMethod) == null) {
          MilvusServiceGrpc.getShowTablesMethod = getShowTablesMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.TableNameList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ShowTables"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableNameList.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("ShowTables"))
              .build();
        }
      }
    }
    return getShowTablesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Cmd",
      requestType = io.milvus.grpc.Command.class,
      responseType = io.milvus.grpc.StringReply.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.Command,
      io.milvus.grpc.StringReply> getCmdMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.Command, io.milvus.grpc.StringReply> getCmdMethod;
    if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getCmdMethod = MilvusServiceGrpc.getCmdMethod) == null) {
          MilvusServiceGrpc.getCmdMethod = getCmdMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.Command, io.milvus.grpc.StringReply>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Cmd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Command.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.StringReply.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("Cmd"))
              .build();
        }
      }
    }
    return getCmdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByRangeParam,
      io.milvus.grpc.Status> getDeleteByRangeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteByRange",
      requestType = io.milvus.grpc.DeleteByRangeParam.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByRangeParam,
      io.milvus.grpc.Status> getDeleteByRangeMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.DeleteByRangeParam, io.milvus.grpc.Status> getDeleteByRangeMethod;
    if ((getDeleteByRangeMethod = MilvusServiceGrpc.getDeleteByRangeMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDeleteByRangeMethod = MilvusServiceGrpc.getDeleteByRangeMethod) == null) {
          MilvusServiceGrpc.getDeleteByRangeMethod = getDeleteByRangeMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.DeleteByRangeParam, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteByRange"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.DeleteByRangeParam.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DeleteByRange"))
              .build();
        }
      }
    }
    return getDeleteByRangeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getPreloadTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PreloadTable",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getPreloadTableMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getPreloadTableMethod;
    if ((getPreloadTableMethod = MilvusServiceGrpc.getPreloadTableMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getPreloadTableMethod = MilvusServiceGrpc.getPreloadTableMethod) == null) {
          MilvusServiceGrpc.getPreloadTableMethod = getPreloadTableMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PreloadTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("PreloadTable"))
              .build();
        }
      }
    }
    return getPreloadTableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DescribeIndex",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.IndexParam.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.IndexParam> getDescribeIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.IndexParam> getDescribeIndexMethod;
    if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDescribeIndexMethod = MilvusServiceGrpc.getDescribeIndexMethod) == null) {
          MilvusServiceGrpc.getDescribeIndexMethod = getDescribeIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.IndexParam>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.IndexParam.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DescribeIndex"))
              .build();
        }
      }
    }
    return getDescribeIndexMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropIndexMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DropIndex",
      requestType = io.milvus.grpc.TableName.class,
      responseType = io.milvus.grpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.milvus.grpc.TableName,
      io.milvus.grpc.Status> getDropIndexMethod() {
    io.grpc.MethodDescriptor<io.milvus.grpc.TableName, io.milvus.grpc.Status> getDropIndexMethod;
    if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
      synchronized (MilvusServiceGrpc.class) {
        if ((getDropIndexMethod = MilvusServiceGrpc.getDropIndexMethod) == null) {
          MilvusServiceGrpc.getDropIndexMethod = getDropIndexMethod =
              io.grpc.MethodDescriptor.<io.milvus.grpc.TableName, io.milvus.grpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DropIndex"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.TableName.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.milvus.grpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new MilvusServiceMethodDescriptorSupplier("DropIndex"))
              .build();
        }
      }
    }
    return getDropIndexMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MilvusServiceStub newStub(io.grpc.Channel channel) {
    return new MilvusServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MilvusServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new MilvusServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MilvusServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new MilvusServiceFutureStub(channel);
  }

  /**
   */
  public static abstract class MilvusServiceImplBase implements io.grpc.BindableService {

    /**
     */
    public void createTable(io.milvus.grpc.TableSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateTableMethod(), responseObserver);
    }

    /**
     */
    public void hasTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnimplementedUnaryCall(getHasTableMethod(), responseObserver);
    }

    /**
     */
    public void dropTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropTableMethod(), responseObserver);
    }

    /**
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateIndexMethod(), responseObserver);
    }

    /**
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnimplementedUnaryCall(getInsertMethod(), responseObserver);
    }

    /**
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchMethod(), responseObserver);
    }

    /**
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSearchInFilesMethod(), responseObserver);
    }

    /**
     */
    public void describeTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeTableMethod(), responseObserver);
    }

    /**
     */
    public void countTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount> responseObserver) {
      asyncUnimplementedUnaryCall(getCountTableMethod(), responseObserver);
    }

    /**
     */
    public void showTables(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList> responseObserver) {
      asyncUnimplementedUnaryCall(getShowTablesMethod(), responseObserver);
    }

    /**
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnimplementedUnaryCall(getCmdMethod(), responseObserver);
    }

    /**
     */
    public void deleteByRange(io.milvus.grpc.DeleteByRangeParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteByRangeMethod(), responseObserver);
    }

    /**
     */
    public void preloadTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getPreloadTableMethod(), responseObserver);
    }

    /**
     */
    public void describeIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnimplementedUnaryCall(getDescribeIndexMethod(), responseObserver);
    }

    /**
     */
    public void dropIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnimplementedUnaryCall(getDropIndexMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableSchema,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_TABLE)))
          .addMethod(
            getHasTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.BoolReply>(
                  this, METHODID_HAS_TABLE)))
          .addMethod(
            getDropTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_TABLE)))
          .addMethod(
            getCreateIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.IndexParam,
                io.milvus.grpc.Status>(
                  this, METHODID_CREATE_INDEX)))
          .addMethod(
            getInsertMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.InsertParam,
                io.milvus.grpc.VectorIds>(
                  this, METHODID_INSERT)))
          .addMethod(
            getSearchMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH)))
          .addMethod(
            getSearchInFilesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.SearchInFilesParam,
                io.milvus.grpc.TopKQueryResult>(
                  this, METHODID_SEARCH_IN_FILES)))
          .addMethod(
            getDescribeTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.TableSchema>(
                  this, METHODID_DESCRIBE_TABLE)))
          .addMethod(
            getCountTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.TableRowCount>(
                  this, METHODID_COUNT_TABLE)))
          .addMethod(
            getShowTablesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.TableNameList>(
                  this, METHODID_SHOW_TABLES)))
          .addMethod(
            getCmdMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.Command,
                io.milvus.grpc.StringReply>(
                  this, METHODID_CMD)))
          .addMethod(
            getDeleteByRangeMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.DeleteByRangeParam,
                io.milvus.grpc.Status>(
                  this, METHODID_DELETE_BY_RANGE)))
          .addMethod(
            getPreloadTableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_PRELOAD_TABLE)))
          .addMethod(
            getDescribeIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.IndexParam>(
                  this, METHODID_DESCRIBE_INDEX)))
          .addMethod(
            getDropIndexMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.milvus.grpc.TableName,
                io.milvus.grpc.Status>(
                  this, METHODID_DROP_INDEX)))
          .build();
    }
  }

  /**
   */
  public static final class MilvusServiceStub extends io.grpc.stub.AbstractStub<MilvusServiceStub> {
    private MilvusServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MilvusServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MilvusServiceStub(channel, callOptions);
    }

    /**
     */
    public void createTable(io.milvus.grpc.TableSchema request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void hasTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getHasTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void dropTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void createIndex(io.milvus.grpc.IndexParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void insert(io.milvus.grpc.InsertParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void search(io.milvus.grpc.SearchParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void searchInFiles(io.milvus.grpc.SearchInFilesParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void describeTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void countTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCountTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void showTables(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getShowTablesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void cmd(io.milvus.grpc.Command request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void deleteByRange(io.milvus.grpc.DeleteByRangeParam request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteByRangeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void preloadTable(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPreloadTableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void describeIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void dropIndex(io.milvus.grpc.TableName request,
        io.grpc.stub.StreamObserver<io.milvus.grpc.Status> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class MilvusServiceBlockingStub extends io.grpc.stub.AbstractStub<MilvusServiceBlockingStub> {
    private MilvusServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MilvusServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MilvusServiceBlockingStub(channel, callOptions);
    }

    /**
     */
    public io.milvus.grpc.Status createTable(io.milvus.grpc.TableSchema request) {
      return blockingUnaryCall(
          getChannel(), getCreateTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.BoolReply hasTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getHasTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.Status dropTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDropTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.Status createIndex(io.milvus.grpc.IndexParam request) {
      return blockingUnaryCall(
          getChannel(), getCreateIndexMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.VectorIds insert(io.milvus.grpc.InsertParam request) {
      return blockingUnaryCall(
          getChannel(), getInsertMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.TopKQueryResult search(io.milvus.grpc.SearchParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.TopKQueryResult searchInFiles(io.milvus.grpc.SearchInFilesParam request) {
      return blockingUnaryCall(
          getChannel(), getSearchInFilesMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.TableSchema describeTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.TableRowCount countTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getCountTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.TableNameList showTables(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getShowTablesMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.StringReply cmd(io.milvus.grpc.Command request) {
      return blockingUnaryCall(
          getChannel(), getCmdMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.Status deleteByRange(io.milvus.grpc.DeleteByRangeParam request) {
      return blockingUnaryCall(
          getChannel(), getDeleteByRangeMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.Status preloadTable(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getPreloadTableMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.IndexParam describeIndex(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDescribeIndexMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.milvus.grpc.Status dropIndex(io.milvus.grpc.TableName request) {
      return blockingUnaryCall(
          getChannel(), getDropIndexMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class MilvusServiceFutureStub extends io.grpc.stub.AbstractStub<MilvusServiceFutureStub> {
    private MilvusServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MilvusServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MilvusServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MilvusServiceFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createTable(
        io.milvus.grpc.TableSchema request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.BoolReply> hasTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getHasTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> createIndex(
        io.milvus.grpc.IndexParam request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateIndexMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.VectorIds> insert(
        io.milvus.grpc.InsertParam request) {
      return futureUnaryCall(
          getChannel().newCall(getInsertMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> search(
        io.milvus.grpc.SearchParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TopKQueryResult> searchInFiles(
        io.milvus.grpc.SearchInFilesParam request) {
      return futureUnaryCall(
          getChannel().newCall(getSearchInFilesMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableSchema> describeTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableRowCount> countTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getCountTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.TableNameList> showTables(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getShowTablesMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.StringReply> cmd(
        io.milvus.grpc.Command request) {
      return futureUnaryCall(
          getChannel().newCall(getCmdMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> deleteByRange(
        io.milvus.grpc.DeleteByRangeParam request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteByRangeMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> preloadTable(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getPreloadTableMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.IndexParam> describeIndex(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDescribeIndexMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.milvus.grpc.Status> dropIndex(
        io.milvus.grpc.TableName request) {
      return futureUnaryCall(
          getChannel().newCall(getDropIndexMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_TABLE = 0;
  private static final int METHODID_HAS_TABLE = 1;
  private static final int METHODID_DROP_TABLE = 2;
  private static final int METHODID_CREATE_INDEX = 3;
  private static final int METHODID_INSERT = 4;
  private static final int METHODID_SEARCH = 5;
  private static final int METHODID_SEARCH_IN_FILES = 6;
  private static final int METHODID_DESCRIBE_TABLE = 7;
  private static final int METHODID_COUNT_TABLE = 8;
  private static final int METHODID_SHOW_TABLES = 9;
  private static final int METHODID_CMD = 10;
  private static final int METHODID_DELETE_BY_RANGE = 11;
  private static final int METHODID_PRELOAD_TABLE = 12;
  private static final int METHODID_DESCRIBE_INDEX = 13;
  private static final int METHODID_DROP_INDEX = 14;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MilvusServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MilvusServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_TABLE:
          serviceImpl.createTable((io.milvus.grpc.TableSchema) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_HAS_TABLE:
          serviceImpl.hasTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.BoolReply>) responseObserver);
          break;
        case METHODID_DROP_TABLE:
          serviceImpl.dropTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_CREATE_INDEX:
          serviceImpl.createIndex((io.milvus.grpc.IndexParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_INSERT:
          serviceImpl.insert((io.milvus.grpc.InsertParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.VectorIds>) responseObserver);
          break;
        case METHODID_SEARCH:
          serviceImpl.search((io.milvus.grpc.SearchParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_SEARCH_IN_FILES:
          serviceImpl.searchInFiles((io.milvus.grpc.SearchInFilesParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TopKQueryResult>) responseObserver);
          break;
        case METHODID_DESCRIBE_TABLE:
          serviceImpl.describeTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableSchema>) responseObserver);
          break;
        case METHODID_COUNT_TABLE:
          serviceImpl.countTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableRowCount>) responseObserver);
          break;
        case METHODID_SHOW_TABLES:
          serviceImpl.showTables((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.TableNameList>) responseObserver);
          break;
        case METHODID_CMD:
          serviceImpl.cmd((io.milvus.grpc.Command) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.StringReply>) responseObserver);
          break;
        case METHODID_DELETE_BY_RANGE:
          serviceImpl.deleteByRange((io.milvus.grpc.DeleteByRangeParam) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_PRELOAD_TABLE:
          serviceImpl.preloadTable((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        case METHODID_DESCRIBE_INDEX:
          serviceImpl.describeIndex((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.IndexParam>) responseObserver);
          break;
        case METHODID_DROP_INDEX:
          serviceImpl.dropIndex((io.milvus.grpc.TableName) request,
              (io.grpc.stub.StreamObserver<io.milvus.grpc.Status>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MilvusServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.milvus.grpc.MilvusProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MilvusService");
    }
  }

  private static final class MilvusServiceFileDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier {
    MilvusServiceFileDescriptorSupplier() {}
  }

  private static final class MilvusServiceMethodDescriptorSupplier
      extends MilvusServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MilvusServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MilvusServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MilvusServiceFileDescriptorSupplier())
              .addMethod(getCreateTableMethod())
              .addMethod(getHasTableMethod())
              .addMethod(getDropTableMethod())
              .addMethod(getCreateIndexMethod())
              .addMethod(getInsertMethod())
              .addMethod(getSearchMethod())
              .addMethod(getSearchInFilesMethod())
              .addMethod(getDescribeTableMethod())
              .addMethod(getCountTableMethod())
              .addMethod(getShowTablesMethod())
              .addMethod(getCmdMethod())
              .addMethod(getDeleteByRangeMethod())
              .addMethod(getPreloadTableMethod())
              .addMethod(getDescribeIndexMethod())
              .addMethod(getDropIndexMethod())
              .build();
        }
      }
    }
    return result;
  }
}
