/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import javax.annotation.Nonnull;

class CommandParam {
    private final String command;
    private final long timeout;

    private CommandParam(@Nonnull Builder builder) {
        this.command = builder.command;
        this.timeout = builder.timeout;
    }

    String getCommand() {
        return this.command;
    }

    long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "CommandParam {command='" + this.command + '\'' + ", timeout=" + this.timeout + '}';
    }

    public static class Builder {
        private final String command;
        private long timeout = 86400L;

        public Builder(@Nonnull String command) {
            this.command = command;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public CommandParam build() {
            return new CommandParam(this);
        }
    }
}

