/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.MetricType;
import javax.annotation.Nonnull;

public class TableSchema {
    private final String tableName;
    private final long dimension;
    private final long indexFileSize;
    private final MetricType metricType;

    private TableSchema(@Nonnull Builder builder) {
        this.tableName = builder.tableName;
        this.dimension = builder.dimension;
        this.indexFileSize = builder.indexFileSize;
        this.metricType = builder.metricType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getDimension() {
        return this.dimension;
    }

    public long getIndexFileSize() {
        return this.indexFileSize;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String toString() {
        return String.format("TableSchema = {tableName = %s, dimension = %d, indexFileSize = %d, metricType = %s}", this.tableName, this.dimension, this.indexFileSize, this.metricType.name());
    }

    public static class Builder {
        private final String tableName;
        private final long dimension;
        private long indexFileSize = 1024L;
        private MetricType metricType = MetricType.L2;

        public Builder(@Nonnull String tableName, long dimension) {
            this.tableName = tableName;
            this.dimension = dimension;
        }

        public Builder withIndexFileSize(long indexFileSize) {
            this.indexFileSize = indexFileSize;
            return this;
        }

        public Builder withMetricType(@Nonnull MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this);
        }
    }
}

