/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.Response;
import java.util.ArrayList;
import java.util.List;

public class SearchResponse {
    private final Response response;
    private final List<List<QueryResult>> queryResultsList;

    public SearchResponse(Response response, List<List<QueryResult>> queryResultsList) {
        this.response = response;
        this.queryResultsList = queryResultsList;
    }

    public List<List<QueryResult>> getQueryResultsList() {
        return this.queryResultsList;
    }

    public List<List<Long>> getResultIdsList() {
        ArrayList<List<Long>> resultIdsList = new ArrayList<List<Long>>();
        for (List<QueryResult> queryResults : this.queryResultsList) {
            ArrayList<Long> resultIds = new ArrayList<Long>();
            for (QueryResult queryResult : queryResults) {
                resultIds.add(queryResult.vectorId);
            }
            resultIdsList.add(resultIds);
        }
        return resultIdsList;
    }

    public List<List<Double>> getResultDistancesList() {
        ArrayList<List<Double>> resultDistancesList = new ArrayList<List<Double>>();
        for (List<QueryResult> queryResults : this.queryResultsList) {
            ArrayList<Double> resultDistances = new ArrayList<Double>();
            for (QueryResult queryResult : queryResults) {
                resultDistances.add(queryResult.distance);
            }
            resultDistancesList.add(resultDistances);
        }
        return resultDistancesList;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("SearchResponse {%s, returned results for %d queries}", this.response.toString(), this.queryResultsList.size());
    }

    public static class QueryResult {
        private final long vectorId;
        private final double distance;

        public QueryResult(long vectorId, double distance) {
            this.vectorId = vectorId;
            this.distance = distance;
        }

        public long getVectorId() {
            return this.vectorId;
        }

        public double getDistance() {
            return this.distance;
        }
    }
}

