/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.DateRange;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SearchParam {
    private final String tableName;
    private final List<List<Float>> queryVectors;
    private final List<DateRange> dateRanges;
    private final long topK;
    private final long nProbe;
    private final long timeout;

    private SearchParam(@Nonnull Builder builder) {
        this.tableName = builder.tableName;
        this.queryVectors = builder.queryVectors;
        this.dateRanges = builder.dateRanges;
        this.nProbe = builder.nProbe;
        this.topK = builder.topK;
        this.timeout = builder.timeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<List<Float>> getQueryVectors() {
        return this.queryVectors;
    }

    public List<DateRange> getdateRanges() {
        return this.dateRanges;
    }

    public long getTopK() {
        return this.topK;
    }

    public long getNProbe() {
        return this.nProbe;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private final String tableName;
        private final List<List<Float>> queryVectors;
        private List<DateRange> dateRanges = new ArrayList<DateRange>();
        private long topK = 1024L;
        private long nProbe = 20L;
        private long timeout = 86400L;

        public Builder(@Nonnull String tableName, @Nonnull List<List<Float>> queryVectors) {
            this.tableName = tableName;
            this.queryVectors = queryVectors;
        }

        public Builder withDateRanges(@Nonnull List<DateRange> dateRanges) {
            this.dateRanges = dateRanges;
            return this;
        }

        public Builder withTopK(long topK) {
            this.topK = topK;
            return this;
        }

        public Builder withNProbe(long nProbe) {
            this.nProbe = nProbe;
            return this;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchParam build() {
            return new SearchParam(this);
        }
    }
}

