/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.SearchParam;
import java.util.List;
import javax.annotation.Nonnull;

public class SearchInFilesParam {
    private final List<String> fileIds;
    private final SearchParam searchParam;
    private final long timeout;

    private SearchInFilesParam(@Nonnull Builder builder) {
        this.fileIds = builder.fileIds;
        this.searchParam = builder.searchParam;
        this.timeout = builder.timeout;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public SearchParam getSearchParam() {
        return this.searchParam;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private final List<String> fileIds;
        private final SearchParam searchParam;
        private long timeout = 86400L;

        public Builder(List<String> fileIds, SearchParam searchParam) {
            this.fileIds = fileIds;
            this.searchParam = searchParam;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchInFilesParam build() {
            return new SearchInFilesParam(this);
        }
    }
}

