/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.milvus.client.CommandParam;
import io.milvus.client.ConnectParam;
import io.milvus.client.CreateIndexParam;
import io.milvus.client.DateRange;
import io.milvus.client.DeleteByRangeParam;
import io.milvus.client.DescribeIndexResponse;
import io.milvus.client.DescribeTableResponse;
import io.milvus.client.GetTableRowCountResponse;
import io.milvus.client.HasTableResponse;
import io.milvus.client.Index;
import io.milvus.client.IndexType;
import io.milvus.client.InsertResponse;
import io.milvus.client.MetricType;
import io.milvus.client.MilvusClient;
import io.milvus.client.Response;
import io.milvus.client.SearchResponse;
import io.milvus.client.ShowTablesResponse;
import io.milvus.client.TableParam;
import io.milvus.client.TableSchema;
import io.milvus.client.TableSchemaParam;
import io.milvus.client.grpc.BoolReply;
import io.milvus.client.grpc.Command;
import io.milvus.client.grpc.ErrorCode;
import io.milvus.client.grpc.IndexParam;
import io.milvus.client.grpc.InsertParam;
import io.milvus.client.grpc.MilvusServiceGrpc;
import io.milvus.client.grpc.QueryResult;
import io.milvus.client.grpc.Range;
import io.milvus.client.grpc.RowRecord;
import io.milvus.client.grpc.SearchInFilesParam;
import io.milvus.client.grpc.SearchParam;
import io.milvus.client.grpc.Status;
import io.milvus.client.grpc.StringReply;
import io.milvus.client.grpc.TableName;
import io.milvus.client.grpc.TableNameList;
import io.milvus.client.grpc.TableRowCount;
import io.milvus.client.grpc.TableSchema;
import io.milvus.client.grpc.TopKQueryResult;
import io.milvus.client.grpc.TopKQueryResultList;
import io.milvus.client.grpc.VectorIds;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class MilvusGrpcClient
implements MilvusClient {
    private static final Logger logger = Logger.getLogger(MilvusGrpcClient.class.getName());
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_BRIGHT_PURPLE = "\u001b[95m";
    private ManagedChannel channel = null;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;

    @Override
    public Response connect(ConnectParam connectParam) {
        if (this.channel != null) {
            this.logWarning("You have already connected!", new Object[0]);
            return new Response(Response.Status.CONNECT_FAILED, "You have already connected!");
        }
        try {
            int port = Integer.parseInt(connectParam.getPort());
            if (port < 0 || port > 65535) {
                this.logSevere("Connect failed! Port {0} out of range", connectParam.getPort());
                return new Response(Response.Status.CONNECT_FAILED);
            }
            this.channel = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)port).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).build();
            ConnectivityState connectivityState = this.channel.getState(true);
            this.logInfo("Waiting to connect...", new Object[0]);
            TimeUnit.MILLISECONDS.sleep(500L);
            connectivityState = this.channel.getState(false);
            if (connectivityState != ConnectivityState.READY) {
                this.logSevere("Connect failed! {0}", connectParam.toString());
                return new Response(Response.Status.CONNECT_FAILED);
            }
            this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        }
        catch (Exception e) {
            this.logSevere("Connect failed! {0}\n{1}", connectParam.toString(), e.toString());
            return new Response(Response.Status.CONNECT_FAILED);
        }
        this.logInfo("Connected successfully!\n{0}", connectParam.toString());
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public boolean connected() {
        if (this.channel == null) {
            return false;
        }
        ConnectivityState connectivityState = this.channel.getState(false);
        return connectivityState == ConnectivityState.READY;
    }

    @Override
    public Response disconnect() throws InterruptedException {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        if (!this.channel.shutdown().awaitTermination(60L, TimeUnit.SECONDS)) {
            this.logSevere("Encountered error when terminating channel", new Object[0]);
            return new Response(Response.Status.RPC_ERROR);
        }
        this.logInfo("Channel terminated", new Object[0]);
        return new Response(Response.Status.SUCCESS);
    }

    @Override
    public Response createTable(@Nonnull TableSchemaParam tableSchemaParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        io.milvus.client.TableSchema tableSchema = tableSchemaParam.getTableSchema();
        TableSchema request = TableSchema.newBuilder().setTableName(tableSchema.getTableName()).setDimension(tableSchema.getDimension()).setIndexFileSize(tableSchema.getIndexFileSize()).setMetricType(tableSchema.getMetricType().getVal()).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableSchemaParam.getTimeout(), TimeUnit.SECONDS)).createTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created table successfully!\n{0}", tableSchema.toString());
                return new Response(Response.Status.SUCCESS);
            }
            if (response.getReason().contentEquals("Table already exists")) {
                this.logWarning("Table `{0}` already exists", tableSchema.getTableName());
                return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
            }
            this.logSevere("Create table failed\n{0}\n{1}", tableSchema.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("createTable RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public HasTableResponse hasTable(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new HasTableResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), false);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            BoolReply response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).hasTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("hasTable `{0}` = {1}", tableName, response.getBoolReply());
                return new HasTableResponse(new Response(Response.Status.SUCCESS), response.getBoolReply());
            }
            this.logSevere("hasTable `{0}` failed:\n{1}", tableName, response.toString());
            return new HasTableResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), false);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("hasTable RPC failed:\n{0}", e.getStatus().toString());
            return new HasTableResponse(new Response(Response.Status.RPC_ERROR, e.toString()), false);
        }
    }

    @Override
    public Response dropTable(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).dropTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped table `{0}` successfully!", tableName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Drop table `{0}` failed:\n{1}", tableName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("dropTable RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response createIndex(@Nonnull CreateIndexParam createIndexParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        io.milvus.client.grpc.Index index = io.milvus.client.grpc.Index.newBuilder().setIndexType(createIndexParam.getIndex().getIndexType().getVal()).setNlist(createIndexParam.getIndex().getNList()).build();
        IndexParam request = IndexParam.newBuilder().setTableName(createIndexParam.getTableName()).setIndex(index).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(createIndexParam.getTimeout(), TimeUnit.SECONDS)).createIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Created index successfully!\n{0}", createIndexParam.toString());
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Create index failed\n{0}\n{1}", createIndexParam.toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("createIndex RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public InsertResponse insert(@Nonnull io.milvus.client.InsertParam insertParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new InsertResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<Long>());
        }
        ArrayList<RowRecord> rowRecordList = new ArrayList<RowRecord>();
        for (List<Float> vectors : insertParam.getVectors()) {
            RowRecord rowRecord = RowRecord.newBuilder().addAllVectorData(vectors).build();
            rowRecordList.add(rowRecord);
        }
        InsertParam request = InsertParam.newBuilder().setTableName(insertParam.getTableName()).addAllRowRecordArray(rowRecordList).addAllRowIdArray(insertParam.getVectorIds()).build();
        try {
            VectorIds response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(insertParam.getTimeout(), TimeUnit.SECONDS)).insert(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                Optional<List<Long>> resultVectorIds = Optional.ofNullable(response.getVectorIdArrayList());
                this.logInfo("Inserted {0} vectors to table `{1} successfully!", resultVectorIds.map(List::size).orElse(0), insertParam.getTableName());
                return new InsertResponse(new Response(Response.Status.SUCCESS), resultVectorIds.orElse(new ArrayList()));
            }
            this.logSevere("Insert vectors failed:\n{0}", response.toString());
            return new InsertResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<Long>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("insert RPC failed:\n{0}", e.getStatus().toString());
            return new InsertResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<Long>());
        }
    }

    @Override
    public SearchResponse search(@Nonnull io.milvus.client.SearchParam searchParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new SearchResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<List<SearchResponse.QueryResult>>());
        }
        List<RowRecord> queryRowRecordList = this.getQueryRowRecordList(searchParam);
        List<Range> queryRangeList = this.getQueryRangeList(searchParam);
        SearchParam request = SearchParam.newBuilder().setTableName(searchParam.getTableName()).addAllQueryRecordArray(queryRowRecordList).addAllQueryRangeArray(queryRangeList).setTopk(searchParam.getTopK()).setNprobe(searchParam.getNProbe()).build();
        try {
            TopKQueryResultList response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(searchParam.getTimeout(), TimeUnit.SECONDS)).search(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                List<List<SearchResponse.QueryResult>> queryResultsList = this.getQueryResultsList(response);
                this.logInfo("Search completed successfully! Returned results for {0} queries", queryResultsList.size());
                return new SearchResponse(new Response(Response.Status.SUCCESS), queryResultsList);
            }
            this.logSevere("Search failed:\n{0}", response.toString());
            return new SearchResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<List<SearchResponse.QueryResult>>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("search RPC failed:\n{0}", e.getStatus().toString());
            return new SearchResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<List<SearchResponse.QueryResult>>());
        }
    }

    @Override
    public SearchResponse searchInFiles(@Nonnull io.milvus.client.SearchInFilesParam searchInFilesParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new SearchResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<List<SearchResponse.QueryResult>>());
        }
        io.milvus.client.SearchParam searchParam = searchInFilesParam.getSearchParam();
        List<RowRecord> queryRowRecordList = this.getQueryRowRecordList(searchParam);
        List<Range> queryRangeList = this.getQueryRangeList(searchParam);
        SearchParam searchParamToSet = SearchParam.newBuilder().setTableName(searchParam.getTableName()).addAllQueryRecordArray(queryRowRecordList).addAllQueryRangeArray(queryRangeList).setTopk(searchParam.getTopK()).setNprobe(searchParam.getNProbe()).build();
        SearchInFilesParam request = SearchInFilesParam.newBuilder().addAllFileIdArray(searchInFilesParam.getFileIds()).setSearchParam(searchParamToSet).build();
        try {
            TopKQueryResultList response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(searchInFilesParam.getTimeout(), TimeUnit.SECONDS)).searchInFiles(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Search in files {0} completed successfully!", searchInFilesParam.getFileIds());
                List<List<SearchResponse.QueryResult>> queryResultsList = this.getQueryResultsList(response);
                return new SearchResponse(new Response(Response.Status.SUCCESS), queryResultsList);
            }
            this.logSevere("Search in files {0} failed:\n{1}", searchInFilesParam.getFileIds(), response.toString());
            return new SearchResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<List<SearchResponse.QueryResult>>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("searchInFiles RPC failed:\n{0}", e.getStatus().toString());
            return new SearchResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<List<SearchResponse.QueryResult>>());
        }
    }

    @Override
    public DescribeTableResponse describeTable(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new DescribeTableResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            TableSchema response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).describeTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                io.milvus.client.TableSchema tableSchema = new TableSchema.Builder(response.getTableName(), response.getDimension()).withIndexFileSize(response.getIndexFileSize()).withMetricType(MetricType.valueOf(response.getMetricType())).build();
                this.logInfo("Describe Table `{0}` returned:\n{1}", tableName, tableSchema);
                return new DescribeTableResponse(new Response(Response.Status.SUCCESS), tableSchema);
            }
            this.logSevere("Describe Table `{0}` failed:\n{1}", tableName, response.toString());
            return new DescribeTableResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("describeTable RPC failed:\n{0}", e.getStatus().toString());
            return new DescribeTableResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public ShowTablesResponse showTables() {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new ShowTablesResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), new ArrayList<String>());
        }
        Command request = Command.newBuilder().setCmd("").build();
        try {
            TableNameList response = this.blockingStub.showTables(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                ProtocolStringList tableNames = response.getTableNamesList();
                this.logInfo("Current tables: {0}", tableNames.toString());
                return new ShowTablesResponse(new Response(Response.Status.SUCCESS), (List<String>)tableNames);
            }
            this.logSevere("Show tables failed:\n{0}", response.toString());
            return new ShowTablesResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), new ArrayList<String>());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("showTables RPC failed:\n{0}", e.getStatus().toString());
            return new ShowTablesResponse(new Response(Response.Status.RPC_ERROR, e.toString()), new ArrayList<String>());
        }
    }

    @Override
    public GetTableRowCountResponse getTableRowCount(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new GetTableRowCountResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), 0L);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            TableRowCount response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).countTable(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                long tableRowCount = response.getTableRowCount();
                this.logInfo("Table `{0}` has {1} rows", tableName, tableRowCount);
                return new GetTableRowCountResponse(new Response(Response.Status.SUCCESS), tableRowCount);
            }
            this.logSevere("Get table `{0}` row count failed:\n{1}", tableName, response.toString());
            return new GetTableRowCountResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), 0L);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("countTable RPC failed:\n{0}", e.getStatus().toString());
            return new GetTableRowCountResponse(new Response(Response.Status.RPC_ERROR, e.toString()), 0L);
        }
    }

    @Override
    public Response serverStatus() {
        CommandParam commandParam = new CommandParam.Builder("OK").build();
        return this.command(commandParam);
    }

    @Override
    public Response serverVersion() {
        CommandParam commandParam = new CommandParam.Builder("version").build();
        return this.command(commandParam);
    }

    private Response command(@Nonnull CommandParam commandParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        String command = commandParam.getCommand();
        Command request = Command.newBuilder().setCmd(command).build();
        try {
            StringReply response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(commandParam.getTimeout(), TimeUnit.SECONDS)).cmd(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Command `{0}`: {1}", command, response.getStringReply());
                return new Response(Response.Status.SUCCESS, response.getStringReply());
            }
            this.logSevere("Command `{0}` failed:\n{1}", command, response.toString());
            return new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("Command RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response deleteByRange(@Nonnull DeleteByRangeParam deleteByRangeParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        io.milvus.client.grpc.DeleteByRangeParam request = io.milvus.client.grpc.DeleteByRangeParam.newBuilder().setRange(this.getRange(deleteByRangeParam.getDateRange())).setTableName(deleteByRangeParam.getTableName()).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(deleteByRangeParam.getTimeout(), TimeUnit.SECONDS)).deleteByRange(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Deleted vectors from table `{0}` in range {1} successfully!", deleteByRangeParam.getTableName(), deleteByRangeParam.getDateRange().toString());
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Deleted vectors from table `{0}` in range {1} failed:\n{2}", deleteByRangeParam.getTableName(), deleteByRangeParam.getDateRange().toString(), response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("deleteByRange RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public Response preloadTable(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).preloadTable(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Preloaded table `{0}` successfully!", tableName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Preload table `{0}` failed:\n{1}", tableName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("preloadTable RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    @Override
    public DescribeIndexResponse describeIndex(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new DescribeIndexResponse(new Response(Response.Status.CLIENT_NOT_CONNECTED), null);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            IndexParam response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).describeIndex(request);
            if (response.getStatus().getErrorCode() == ErrorCode.SUCCESS) {
                Index index = new Index.Builder().withIndexType(IndexType.valueOf(response.getIndex().getIndexType())).withNList(response.getIndex().getNlist()).build();
                this.logInfo("Describe index for table `{0}` returned:\n{1}", tableName, index.toString());
                return new DescribeIndexResponse(new Response(Response.Status.SUCCESS), index);
            }
            this.logSevere("Describe index for table `{0}` failed:\n{1}", tableName, response.toString());
            return new DescribeIndexResponse(new Response(Response.Status.valueOf(response.getStatus().getErrorCodeValue()), response.getStatus().getReason()), null);
        }
        catch (StatusRuntimeException e) {
            this.logSevere("describeIndex RPC failed:\n{0}", e.getStatus().toString());
            return new DescribeIndexResponse(new Response(Response.Status.RPC_ERROR, e.toString()), null);
        }
    }

    @Override
    public Response dropIndex(@Nonnull TableParam tableParam) {
        if (!this.connected()) {
            this.logWarning("You are not connected to Milvus server", new Object[0]);
            return new Response(Response.Status.CLIENT_NOT_CONNECTED);
        }
        String tableName = tableParam.getTableName();
        TableName request = TableName.newBuilder().setTableName(tableName).build();
        try {
            Status response = ((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(tableParam.getTimeout(), TimeUnit.SECONDS)).dropIndex(request);
            if (response.getErrorCode() == ErrorCode.SUCCESS) {
                this.logInfo("Dropped index for table `{0}` successfully!", tableName);
                return new Response(Response.Status.SUCCESS);
            }
            this.logSevere("Drop index for table `{0}` failed:\n{1}", tableName, response.toString());
            return new Response(Response.Status.valueOf(response.getErrorCodeValue()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logSevere("dropIndex RPC failed:\n{0}", e.getStatus().toString());
            return new Response(Response.Status.RPC_ERROR, e.toString());
        }
    }

    private List<RowRecord> getQueryRowRecordList(@Nonnull io.milvus.client.SearchParam searchParam) {
        ArrayList<RowRecord> queryRowRecordList = new ArrayList<RowRecord>();
        for (List<Float> vectors : searchParam.getQueryVectors()) {
            RowRecord rowRecord = RowRecord.newBuilder().addAllVectorData(vectors).build();
            queryRowRecordList.add(rowRecord);
        }
        return queryRowRecordList;
    }

    private List<Range> getQueryRangeList(@Nonnull io.milvus.client.SearchParam searchParam) {
        ArrayList<Range> queryRangeList = new ArrayList<Range>();
        String datePattern = "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
        for (DateRange queryRange : searchParam.getdateRanges()) {
            Range dateRange = Range.newBuilder().setStartValue(simpleDateFormat.format(queryRange.getStartDate())).setEndValue(simpleDateFormat.format(queryRange.getEndDate())).build();
            queryRangeList.add(dateRange);
        }
        return queryRangeList;
    }

    private Range getRange(@Nonnull DateRange dateRange) {
        String datePattern = "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
        return Range.newBuilder().setStartValue(simpleDateFormat.format(dateRange.getStartDate())).setEndValue(simpleDateFormat.format(dateRange.getEndDate())).build();
    }

    private List<List<SearchResponse.QueryResult>> getQueryResultsList(TopKQueryResultList searchResponse) {
        ArrayList<List<SearchResponse.QueryResult>> queryResultsList = new ArrayList<List<SearchResponse.QueryResult>>();
        Optional<List<TopKQueryResult>> topKQueryResultList = Optional.ofNullable(searchResponse.getTopkQueryResultList());
        if (topKQueryResultList.isPresent()) {
            for (TopKQueryResult topKQueryResult : topKQueryResultList.get()) {
                ArrayList<SearchResponse.QueryResult> responseQueryResults = new ArrayList<SearchResponse.QueryResult>();
                List<QueryResult> queryResults = topKQueryResult.getQueryResultArraysList();
                for (QueryResult queryResult : queryResults) {
                    SearchResponse.QueryResult responseQueryResult = new SearchResponse.QueryResult(queryResult.getId(), queryResult.getDistance());
                    responseQueryResults.add(responseQueryResult);
                }
                queryResultsList.add(responseQueryResults);
            }
        }
        return queryResultsList;
    }

    private void logInfo(String msg, Object ... params) {
        logger.log(Level.INFO, ANSI_YELLOW + msg + ANSI_RESET, params);
    }

    private void logWarning(String msg, Object ... params) {
        logger.log(Level.WARNING, ANSI_PURPLE + msg + ANSI_RESET, params);
    }

    private void logSevere(String msg, Object ... params) {
        logger.log(Level.SEVERE, ANSI_BRIGHT_PURPLE + msg + ANSI_RESET, params);
    }
}

