/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InsertParam {
    private final String tableName;
    private final List<List<Float>> vectors;
    private final List<Long> vectorIds;
    private final long timeout;

    private InsertParam(@Nonnull Builder builder) {
        this.tableName = builder.tableName;
        this.vectors = builder.vectors;
        this.vectorIds = builder.vectorIds;
        this.timeout = builder.timeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<List<Float>> getVectors() {
        return this.vectors;
    }

    public List<Long> getVectorIds() {
        return this.vectorIds;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private final String tableName;
        private final List<List<Float>> vectors;
        private List<Long> vectorIds = new ArrayList<Long>();
        private long timeout = 86400L;

        public Builder(@Nonnull String tableName, @Nonnull List<List<Float>> vectors) {
            this.tableName = tableName;
            this.vectors = vectors;
        }

        public Builder withVectorIds(@Nonnull List<Long> vectorIds) {
            this.vectorIds = vectorIds;
            return this;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public InsertParam build() {
            return new InsertParam(this);
        }
    }
}

