/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.IndexType;
import javax.annotation.Nonnull;

public class Index {
    private final IndexType indexType;
    private final int nList;

    private Index(@Nonnull Builder builder) {
        this.indexType = builder.indexType;
        this.nList = builder.nList;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public int getNList() {
        return this.nList;
    }

    public String toString() {
        return "Index {indexType=" + (Object)((Object)this.indexType) + ", nList=" + this.nList + '}';
    }

    public static class Builder {
        private IndexType indexType = IndexType.FLAT;
        private int nList = 16384;

        public Builder withIndexType(@Nonnull IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder withNList(int nList) {
            this.nList = nList;
            return this;
        }

        public Index build() {
            return new Index(this);
        }
    }
}

