/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.Index;
import javax.annotation.Nonnull;

public class CreateIndexParam {
    private final String tableName;
    private final Index index;
    private final long timeout;

    private CreateIndexParam(@Nonnull Builder builder) {
        this.tableName = builder.tableName;
        this.index = builder.index;
        this.timeout = builder.timeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Index getIndex() {
        return this.index;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return String.format("IndexParam = {tableName = %s, index = {indexType = %s, nList = %d}, timeout = %d}", this.tableName, this.index.getIndexType().name(), this.index.getNList(), this.timeout);
    }

    public static class Builder {
        private final String tableName;
        private Index index;
        private long timeout = 86400L;

        public Builder(@Nonnull String tableName) {
            this.tableName = tableName;
        }

        public Builder withIndex(Index index) {
            this.index = index;
            return this;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public CreateIndexParam build() {
            return new CreateIndexParam(this);
        }
    }
}

