/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import javax.annotation.Nonnull;

public class ConnectParam {
    private final String host;
    private final String port;

    private ConnectParam(@Nonnull Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String toString() {
        return "ConnectParam {host='" + this.host + '\'' + ", port='" + this.port + '\'' + '}';
    }

    public static class Builder {
        private String host = "127.0.0.1";
        private String port = "19530";

        public Builder withHost(@Nonnull String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(@Nonnull String port) {
            this.port = port;
            return this;
        }

        public ConnectParam build() {
            return new ConnectParam(this);
        }
    }
}

