/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket;

import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.http.MediaType;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import java.net.URI;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.reactivestreams.Publisher;

public interface WebSocketSession
extends MutableConvertibleValues<Object>,
AutoCloseable {
    public String getId();

    public MutableConvertibleValues<Object> getAttributes();

    public boolean isOpen();

    public boolean isWritable();

    public boolean isSecure();

    public Set<? extends WebSocketSession> getOpenSessions();

    public URI getRequestURI();

    public String getProtocolVersion();

    public <T> Publisher<T> send(T var1, MediaType var2);

    public <T> CompletableFuture<T> sendAsync(T var1, MediaType var2);

    default public void sendSync(Object message, MediaType mediaType) {
        try {
            this.sendAsync(message, mediaType).get();
        }
        catch (InterruptedException e) {
            throw new WebSocketSessionException("Send Interrupted");
        }
        catch (ExecutionException e) {
            throw new WebSocketSessionException("Send Failure: " + e.getMessage(), e);
        }
    }

    default public <T> Publisher<T> send(T message) {
        return this.send(message, MediaType.APPLICATION_JSON_TYPE);
    }

    default public <T> CompletableFuture<T> sendAsync(T message) {
        return this.sendAsync(message, MediaType.APPLICATION_JSON_TYPE);
    }

    default public void sendSync(Object message) {
        this.sendSync(message, MediaType.APPLICATION_JSON_TYPE);
    }

    default public Optional<String> getSubprotocol() {
        return Optional.empty();
    }

    default public ConvertibleMultiValues<String> getRequestParameters() {
        return ConvertibleMultiValues.empty();
    }

    default public ConvertibleValues<Object> getUriVariables() {
        return ConvertibleValues.empty();
    }

    default public Optional<Principal> getUserPrincipal() {
        return Optional.empty();
    }

    @Override
    public void close();

    public void close(CloseReason var1);
}

