/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import io.micronaut.annotation.processing.test.support.KotlinCompilation;
import io.micronaut.annotation.processing.test.support.KspKt;
import io.micronaut.annotation.processing.test.support.SourceFile;
import io.micronaut.aop.internal.InterceptorRegistryBean;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisherFactory;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.provider.BeanProviderDefinition;
import io.micronaut.kotlin.processing.beans.BeanDefinitionProcessorProvider;
import io.micronaut.kotlin.processing.visitor.KotlinVisitorContext;
import io.micronaut.kotlin.processing.visitor.TypeElementSymbolProcessor;
import io.micronaut.kotlin.processing.visitor.TypeElementSymbolProcessorProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Pair;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class KotlinCompiler {
    private static final KotlinCompilation KOTLIN_COMPILATION = new KotlinCompilation();
    private static final KotlinCompilation KSP_COMPILATION = new KotlinCompilation();

    public static URLClassLoader buildClassLoader(String name, @Language(value="kotlin") String clazz) {
        Pair<Pair<KotlinCompilation, KotlinCompilation.Result>, Pair<KotlinCompilation, KotlinCompilation.Result>> resultPair = KotlinCompiler.compile(name, clazz, classElement -> {});
        return KotlinCompiler.toClassLoader(resultPair);
    }

    @NotNull
    private static URLClassLoader toClassLoader(Pair<Pair<KotlinCompilation, KotlinCompilation.Result>, Pair<KotlinCompilation, KotlinCompilation.Result>> resultPair) {
        try {
            Pair sourcesCompilation = (Pair)resultPair.component1();
            Pair kspCompilation = (Pair)resultPair.component2();
            KotlinCompilation.Result sourcesCompileResult = (KotlinCompilation.Result)sourcesCompilation.component2();
            KotlinCompilation.Result kspCompileResult = (KotlinCompilation.Result)kspCompilation.component2();
            ArrayList<URL> classpath2 = new ArrayList<URL>();
            classpath2.add(sourcesCompileResult.getOutputDirectory().toURI().toURL());
            classpath2.add(kspCompileResult.getOutputDirectory().toURI().toURL());
            classpath2.addAll(((KotlinCompilation)kspCompilation.component1()).getClasspaths().stream().flatMap(f -> {
                try {
                    return Stream.of(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    return Stream.empty();
                }
            }).toList());
            classpath2.addAll(((KotlinCompilation)sourcesCompilation.component1()).getClasspaths().stream().flatMap(f -> {
                try {
                    return Stream.of(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    return Stream.empty();
                }
            }).toList());
            return new URLClassLoader((URL[])classpath2.toArray(URL[]::new), KotlinCompiler.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Pair<Pair<KotlinCompilation, KotlinCompilation.Result>, Pair<KotlinCompilation, KotlinCompilation.Result>> compile(String name, @Language(value="kotlin") String clazz, Consumer<ClassElement> classElements) {
        try {
            Files.deleteIfExists(KOTLIN_COMPILATION.getWorkingDir().toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KOTLIN_COMPILATION.setSources(Collections.singletonList(SourceFile.Companion.kotlin(name + ".kt", clazz, true)));
        KotlinCompilation.Result result = KOTLIN_COMPILATION.compile();
        if (result.getExitCode() != KotlinCompilation.ExitCode.OK) {
            throw new RuntimeException(result.getMessages());
        }
        KSP_COMPILATION.setSources(KOTLIN_COMPILATION.getSources());
        ClassElementTypeElementSymbolProcessorProvider classElementTypeElementSymbolProcessorProvider = new ClassElementTypeElementSymbolProcessorProvider(classElements);
        KspKt.setSymbolProcessorProviders(KSP_COMPILATION, Arrays.asList(new SymbolProcessorProvider[]{classElementTypeElementSymbolProcessorProvider, new BeanDefinitionProcessorProvider()}));
        KotlinCompilation.Result kspResult = KSP_COMPILATION.compile();
        if (kspResult.getExitCode() != KotlinCompilation.ExitCode.OK) {
            throw new RuntimeException(kspResult.getMessages());
        }
        return new Pair((Object)new Pair((Object)KOTLIN_COMPILATION, (Object)result), (Object)new Pair((Object)KSP_COMPILATION, (Object)kspResult));
    }

    public static Pair<Pair<KotlinCompilation, KotlinCompilation.Result>, Pair<KotlinCompilation, KotlinCompilation.Result>> compileJava(String name, @Language(value="java") String clazz, Consumer<ClassElement> classElements) {
        try {
            Files.deleteIfExists(KOTLIN_COMPILATION.getWorkingDir().toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KOTLIN_COMPILATION.setSources(Collections.singletonList(SourceFile.Companion.java(name + ".java", clazz, true)));
        KotlinCompilation.Result result = KOTLIN_COMPILATION.compile();
        if (result.getExitCode() != KotlinCompilation.ExitCode.OK) {
            throw new RuntimeException(result.getMessages());
        }
        KSP_COMPILATION.setSources(KOTLIN_COMPILATION.getSources());
        ClassElementTypeElementSymbolProcessorProvider classElementTypeElementSymbolProcessorProvider = new ClassElementTypeElementSymbolProcessorProvider(classElements);
        KspKt.setSymbolProcessorProviders(KSP_COMPILATION, Arrays.asList(new SymbolProcessorProvider[]{classElementTypeElementSymbolProcessorProvider, new BeanDefinitionProcessorProvider()}));
        KotlinCompilation.Result kspResult = KSP_COMPILATION.compile();
        if (kspResult.getExitCode() != KotlinCompilation.ExitCode.OK) {
            throw new RuntimeException(kspResult.getMessages());
        }
        return new Pair((Object)new Pair((Object)KOTLIN_COMPILATION, (Object)result), (Object)new Pair((Object)KSP_COMPILATION, (Object)kspResult));
    }

    public static BeanIntrospection<?> buildBeanIntrospection(String name, @Language(value="kotlin") String clazz) {
        URLClassLoader classLoader = KotlinCompiler.buildClassLoader(name, clazz);
        try {
            return BeanIntrospector.forClassLoader((ClassLoader)classLoader).findIntrospection(classLoader.loadClass(name)).orElse(null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static BeanDefinition<?> buildBeanDefinition(String name, @Language(value="kotlin") String clazz) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return KotlinCompiler.buildBeanDefinition(NameUtils.getPackageName((String)name), NameUtils.getSimpleName((String)name), clazz);
    }

    public static BeanDefinition<?> buildBeanDefinition(String packageName, String simpleName, @Language(value="kotlin") String clazz) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        URLClassLoader classLoader = KotlinCompiler.buildClassLoader(packageName + "." + simpleName, clazz);
        String beanDefName = (Serializable)(simpleName.startsWith("$") ? "" : Character.valueOf('$')) + simpleName + "$Definition";
        String beanFullName = packageName + "." + beanDefName;
        return (BeanDefinition)KotlinCompiler.loadDefinition(classLoader, beanFullName);
    }

    public static BeanDefinitionReference<?> buildBeanDefinitionReference(String name, @Language(value="kotlin") String clazz) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (BeanDefinitionReference)KotlinCompiler.loadReference(name, clazz, "$Definition");
    }

    public static BeanDefinition<?> buildIntroducedBeanDefinition(String className, @Language(value="kotlin") String cls) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (BeanDefinition)KotlinCompiler.loadReference(className, cls, "$Intercepted$Definition");
    }

    public static BeanDefinition<?> buildInterceptedBeanDefinition(String className, @Language(value="kotlin") String cls) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (BeanDefinition)KotlinCompiler.loadReference(className, cls, "$Definition$Intercepted$Definition");
    }

    public static BeanDefinitionReference<?> buildInterceptedBeanDefinitionReference(String className, @Language(value="kotlin") String cls) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (BeanDefinitionReference)KotlinCompiler.loadReference(className, cls, "$Definition$Intercepted$Definition");
    }

    private static <T> T loadReference(String className, @Language(value="kotlin") String cls, String suffix) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String simpleName = NameUtils.getSimpleName((String)className);
        String beanDefName = (Serializable)(simpleName.startsWith("$") ? "" : Character.valueOf('$')) + simpleName + suffix;
        String packageName = NameUtils.getPackageName((String)className);
        String beanFullName = packageName + "." + beanDefName;
        return KotlinCompiler.buildAndLoad(className, beanFullName, cls);
    }

    public static <T> T buildAndLoad(String className, String beanFullName, @Language(value="kotlin") String cls) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        URLClassLoader classLoader = KotlinCompiler.buildClassLoader(className, cls);
        return (T)KotlinCompiler.loadDefinition(classLoader, beanFullName);
    }

    public static byte[] getClassBytes(String name, @Language(value="kotlin") String clazz) throws FileNotFoundException, IOException {
        URL url;
        String simpleName = NameUtils.getSimpleName((String)name);
        String className = (Serializable)(simpleName.startsWith("$") ? "" : Character.valueOf('$')) + simpleName;
        String packageName = NameUtils.getPackageName((String)name);
        String fileName = packageName.replace('.', '/') + "/" + className + ".class";
        URLClassLoader classLoader = KotlinCompiler.buildClassLoader(className, clazz);
        File file = null;
        URL[] uRLArray = classLoader.getURLs();
        int n = uRLArray.length;
        for (int i = 0; i < n && !(file = new File((url = uRLArray[i]).getFile(), fileName)).exists(); ++i) {
            file = null;
        }
        if (file != null) {
            try (FileInputStream is = new FileInputStream(file);){
                int nbByteRead;
                ByteArrayOutputStream answer = new ByteArrayOutputStream();
                byte[] byteBuffer = new byte[8192];
                while ((nbByteRead = ((InputStream)is).read(byteBuffer)) != -1) {
                    answer.write(byteBuffer, 0, nbByteRead);
                }
                byte[] byArray = answer.toByteArray();
                return byArray;
            }
        }
        return null;
    }

    public static ApplicationContext buildContext(@Language(value="kotlin") String clazz) {
        return KotlinCompiler.buildContext(clazz, false);
    }

    public static ApplicationContext buildContext(@Language(value="kotlin") String clazz, boolean includeAllBeans) {
        return KotlinCompiler.buildContext(clazz, includeAllBeans, Collections.emptyMap());
    }

    public static ApplicationContext buildContext(@Language(value="kotlin") String clazz, final boolean includeAllBeans, Map<String, Object> config) {
        final Pair<Pair<KotlinCompilation, KotlinCompilation.Result>, Pair<KotlinCompilation, KotlinCompilation.Result>> pair = KotlinCompiler.compile("temp", clazz, classElement -> {});
        final URLClassLoader classLoader = KotlinCompiler.toClassLoader(pair);
        ApplicationContextBuilder builder = ApplicationContext.builder();
        builder.classLoader((ClassLoader)classLoader);
        builder.environments(new String[]{"test"});
        builder.properties(config);
        final Environment environment = builder.build().getEnvironment();
        return new DefaultApplicationContext((ApplicationContextConfiguration)builder){

            public Environment getEnvironment() {
                return environment;
            }

            protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
                List<String> beanDefinitionNames = ((KotlinCompilation)((Pair)pair.component2()).component1()).getClasspaths().stream().filter(f -> f.toURI().toString().contains("/ksp/sources/resources")).flatMap(dir -> {
                    File[] files = new File((File)dir, "META-INF/micronaut/io.micronaut.inject.BeanDefinitionReference").listFiles();
                    if (files == null) {
                        return Stream.empty();
                    }
                    return Stream.of(files).filter(f -> f.isFile());
                }).map(f -> f.getName()).toList();
                ArrayList<BeanDefinitionReference> beanDefinitions = new ArrayList<BeanDefinitionReference>(beanDefinitionNames.size());
                for (String name : beanDefinitionNames) {
                    try {
                        BeanDefinitionReference br = (BeanDefinitionReference)KotlinCompiler.loadDefinition(classLoader, name);
                        if (br == null) continue;
                        beanDefinitions.add(br);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
                }
                if (includeAllBeans) {
                    beanDefinitions.addAll(super.resolveBeanDefinitionReferences());
                } else {
                    beanDefinitions.add((BeanDefinitionReference)new InterceptorRegistryBean());
                    beanDefinitions.add((BeanDefinitionReference)new BeanProviderDefinition());
                    beanDefinitions.add((BeanDefinitionReference)new ApplicationEventPublisherFactory());
                }
                return beanDefinitions;
            }
        }.start();
    }

    public static Object getBean(BeanContext beanContext, String className) throws ClassNotFoundException {
        return beanContext.getBean(beanContext.getClassLoader().loadClass(className));
    }

    public static BeanDefinition<?> getBeanDefinition(BeanContext beanContext, String className) throws ClassNotFoundException {
        return beanContext.getBeanDefinition(beanContext.getClassLoader().loadClass(className));
    }

    private static Object loadDefinition(ClassLoader classLoader, String name) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        try {
            Class<?> c = classLoader.loadClass(name);
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        KOTLIN_COMPILATION.setJvmDefault("all");
        KOTLIN_COMPILATION.setInheritClassPath(true);
        KSP_COMPILATION.setInheritClassPath(true);
        KSP_COMPILATION.setClasspaths(Arrays.asList(new File(KSP_COMPILATION.getWorkingDir(), "ksp/classes"), new File(KSP_COMPILATION.getWorkingDir(), "ksp/sources/resources"), KOTLIN_COMPILATION.getClassesDir()));
    }

    private static class ClassElementTypeElementSymbolProcessorProvider
    extends TypeElementSymbolProcessorProvider {
        Consumer<ClassElement> classElements;

        public ClassElementTypeElementSymbolProcessorProvider(Consumer<ClassElement> classElements) {
            this.classElements = classElements;
        }

        @NotNull
        public SymbolProcessor create(@NotNull SymbolProcessorEnvironment environment) {
            return new TypeElementSymbolProcessor(environment){

                @NotNull
                public ClassElement newClassElement(@NotNull KotlinVisitorContext visitorContext, @NotNull KSClassDeclaration classDeclaration) {
                    ClassElement classElement = super.newClassElement(visitorContext, classDeclaration);
                    classElements.accept(classElement);
                    return classElement;
                }
            };
        }
    }
}

