/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test.support;

import io.micronaut.annotation.processing.test.support.UtilsKt;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001a9\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a5\u0010\u0012\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a1\u0010\u0016\u001a\u00020\t\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00170\u001a\"\u0002H\u0017H\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\u000e\u0010!\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0000\u001a\u001a\u0010\"\u001a\u00020\t*\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0$H\u0000\u001a\f\u0010%\u001a\u00020\t*\u00020\u0001H\u0000\u001a\f\u0010&\u001a\u00020\t*\u00020\u0001H\u0000\u001a\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010$*\u00020\u0001H\u0000\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"processJdkHome", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getProcessJdkHome", "()Ljava/io/File;", "processJdkHome$delegate", "Lkotlin/Lazy;", "getJavaHome", "isJdk9OrLater", "", "withSystemProperties", "T", "properties", "", "", "f", "Lkotlin/Function0;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withSystemProperty", "key", "value", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addAll", "E", "", "elems", "", "(Ljava/util/Collection;[Ljava/lang/Object;)Z", "addUrl", "", "Ljava/net/URLClassLoader;", "url", "Ljava/net/URL;", "existsOrNull", "hasFileExtension", "extensions", "", "hasJavaFileExtension", "hasKotlinFileExtension", "listFilesRecursively", "inject-kotlin-test"})
public final class UtilsKt {
    @NotNull
    private static final Lazy processJdkHome$delegate = LazyKt.lazy((Function0)processJdkHome.2.INSTANCE);

    public static final <E> boolean addAll(@NotNull Collection<E> $this$addAll, E ... elems) {
        Intrinsics.checkNotNullParameter($this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elems, (String)"elems");
        return CollectionsKt.addAll($this$addAll, (Object[])elems);
    }

    @NotNull
    public static final File getJavaHome() {
        Object object;
        String string = System.getProperty("java.home");
        if (string == null) {
            string = System.getenv("JAVA_HOME");
        }
        if ((object = string) == null) {
            throw new IllegalStateException("no java home found");
        }
        String path = object;
        Object it = object = new File(path);
        boolean bl = false;
        if (!((File)it).isDirectory()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return object;
    }

    public static final File getProcessJdkHome() {
        Lazy lazy = processJdkHome$delegate;
        return (File)lazy.getValue();
    }

    public static final boolean isJdk9OrLater() {
        return SourceVersion.latestSupported().compareTo((Enum)SourceVersion.RELEASE_8) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listFilesRecursively(@NotNull File $this$listFilesRecursively) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$listFilesRecursively, (String)"<this>");
        File[] fileArray = $this$listFilesRecursively.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles()");
        Object[] $this$flatMap$iv = fileArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            List<File> list;
            File file = (File)element$iv$iv;
            boolean bl = false;
            if (file.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                list = UtilsKt.listFilesRecursively(file);
            } else {
                list = CollectionsKt.listOf((Object)file);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean hasKotlinFileExtension(@NotNull File $this$hasKotlinFileExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$hasKotlinFileExtension, (String)"<this>");
        Object[] objectArray = new String[]{"kt", "kts"};
        return UtilsKt.hasFileExtension($this$hasKotlinFileExtension, CollectionsKt.listOf((Object[])objectArray));
    }

    public static final boolean hasJavaFileExtension(@NotNull File $this$hasJavaFileExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJavaFileExtension, (String)"<this>");
        return UtilsKt.hasFileExtension($this$hasJavaFileExtension, CollectionsKt.listOf((Object)"java"));
    }

    public static final boolean hasFileExtension(@NotNull File $this$hasFileExtension, @NotNull List<String> extensions) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasFileExtension, (String)"<this>");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            Iterable $this$any$iv = extensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$this$hasFileExtension), (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void addUrl(@NotNull URLClassLoader $this$addUrl, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)$this$addUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object[] objectArray = new Class[]{URL.class};
        Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", (Class<?>[])objectArray);
        addUrlMethod.setAccessible(true);
        objectArray = new Object[]{url};
        addUrlMethod.invoke((Object)$this$addUrl, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withSystemProperty(@NotNull String key, @NotNull String value, @NotNull Function0<? extends T> f) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$withSystemProperty = false;
        Map properties$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value));
        boolean $i$f$withSystemProperties = false;
        Map previousProperties$iv = new LinkedHashMap();
        for (Map.Entry iterator : properties$iv.entrySet()) {
            String key$iv = (String)iterator.getKey();
            String value$iv = (String)iterator.getValue();
            previousProperties$iv.put(key$iv, System.getProperty(key$iv));
            System.setProperty(key$iv, value$iv);
        }
        try {
            object = f.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (Map.Entry entry : previousProperties$iv.entrySet()) {
                String key$iv = (String)entry.getKey();
                String value$iv = (String)entry.getValue();
                if (value$iv == null) continue;
                System.setProperty(key$iv, value$iv);
            }
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withSystemProperties(@NotNull Map<String, String> properties, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$withSystemProperties = false;
        Map previousProperties = new LinkedHashMap();
        for (Map.Entry<String, String> iterator : properties.entrySet()) {
            String key = iterator.getKey();
            String value = iterator.getValue();
            previousProperties.put(key, System.getProperty(key));
            System.setProperty(key, value);
        }
        try {
            Object object = f.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (Map.Entry entry : previousProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                System.setProperty(key, value);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Nullable
    public static final File existsOrNull(@NotNull File $this$existsOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$existsOrNull, (String)"<this>");
        return $this$existsOrNull.exists() ? $this$existsOrNull : null;
    }
}

