/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test.support;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002J\b\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/micronaut/annotation/processing/test/support/TeeOutputStream;", "Ljava/io/OutputStream;", "streams", "", "([Ljava/io/OutputStream;)V", "", "(Ljava/util/Collection;)V", "getStreams", "()Ljava/util/Collection;", "close", "", "closeImpl", "streamsToClose", "flush", "write", "b", "", "off", "", "len", "inject-kotlin-test"})
public final class TeeOutputStream
extends OutputStream {
    @NotNull
    private final Collection<OutputStream> streams;

    public TeeOutputStream(@NotNull Collection<? extends OutputStream> streams) {
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        this.streams = streams;
    }

    @NotNull
    public final Collection<OutputStream> getStreams() {
        return this.streams;
    }

    public TeeOutputStream(OutputStream ... streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        this(ArraysKt.toList((Object[])streams));
    }

    @Override
    public synchronized void write(int b) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream stream : this.streams) {
            stream.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeImpl(this.streams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeImpl(Collection<? extends OutputStream> streamsToClose) throws IOException {
        try {
            OutputStream outputStream = (OutputStream)CollectionsKt.firstOrNull((Iterable)streamsToClose);
            if (outputStream != null) {
                outputStream.close();
            }
        }
        finally {
            if (streamsToClose.size() > 1) {
                this.closeImpl(CollectionsKt.drop((Iterable)streamsToClose, (int)1));
            }
        }
    }
}

