/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.SuperclassAwareTypeVisitor;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElement
extends AbstractJavaElement
implements ArrayableClassElement {
    protected final TypeElement classElement;
    protected final JavaVisitorContext visitorContext;
    private final int arrayDimensions;
    private List<PropertyElement> beanProperties;
    private Map<String, Map<String, TypeMirror>> genericTypeInfo;
    private List<? extends javax.lang.model.element.Element> enclosedElements;

    @Internal
    public JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(classElement, annotationMetadata, visitorContext, null, 0);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        this(classElement, annotationMetadata, visitorContext, genericsInfo, 0);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo, int arrayDimensions) {
        super(classElement, annotationMetadata, visitorContext);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.genericTypeInfo = genericsInfo;
        this.arrayDimensions = arrayDimensions;
    }

    public boolean isInner() {
        return this.classElement.getNestingKind().isNested();
    }

    public boolean isRecord() {
        return JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement);
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        Map<String, Map<String, TypeMirror>> data;
        Map<String, TypeMirror> forType;
        if (StringUtils.isNotEmpty((CharSequence)type) && (forType = (data = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement)).get(type)) != null) {
            LinkedHashMap<String, ClassElement> typeArgs = new LinkedHashMap<String, ClassElement>(forType.size());
            for (Map.Entry<String, TypeMirror> entry : forType.entrySet()) {
                ClassElement ce;
                TypeMirror v = entry.getValue();
                ClassElement classElement = ce = v != null ? this.mirrorToClassElement(v, this.visitorContext, Collections.emptyMap(), this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments()) : null;
                if (ce == null) {
                    return Collections.emptyMap();
                }
                typeArgs.put(entry.getKey(), ce);
            }
            return Collections.unmodifiableMap(typeArgs);
        }
        return Collections.emptyMap();
    }

    public boolean isPrimitive() {
        return ClassUtils.getPrimitiveType((String)this.getName()).isPresent();
    }

    public Optional<ClassElement> getSuperType() {
        javax.lang.model.element.Element element;
        TypeMirror superclass = this.classElement.getSuperclass();
        if (superclass != null && (element = this.visitorContext.getTypes().asElement(superclass)) instanceof TypeElement) {
            TypeElement superElement = (TypeElement)element;
            if (!Object.class.getName().equals(superElement.getQualifiedName().toString())) {
                if (superclass instanceof DeclaredType && !((DeclaredType)superclass).getTypeArguments().isEmpty()) {
                    return Optional.of(this.parameterizedClassElement(superclass, this.visitorContext, this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement)));
                }
                return Optional.of(new JavaClassElement(superElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(superElement), this.visitorContext));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isAbstract() {
        return this.classElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface() {
        return JavaModelUtils.isInterface((javax.lang.model.element.Element)this.classElement);
    }

    public List<PropertyElement> getBeanProperties() {
        if (this.beanProperties == null) {
            final LinkedHashMap props = new LinkedHashMap();
            final LinkedHashMap fields = new LinkedHashMap();
            if (this.isRecord()) {
                this.classElement.asType().accept(new SuperclassAwareTypeVisitor<Object, Object>(this.visitorContext){

                    @Override
                    protected boolean isAcceptable(javax.lang.model.element.Element element) {
                        return JavaModelUtils.isRecord((javax.lang.model.element.Element)element);
                    }

                    @Override
                    public Object visitDeclared(DeclaredType type, Object o) {
                        javax.lang.model.element.Element element = type.asElement();
                        if (this.isAcceptable(element)) {
                            List<? extends javax.lang.model.element.Element> enclosedElements = element.getEnclosedElements();
                            for (javax.lang.model.element.Element element2 : enclosedElements) {
                                if (!JavaModelUtils.isRecordComponent((javax.lang.model.element.Element)element2) && !(element2 instanceof ExecutableElement) || element2.getKind() == ElementKind.CONSTRUCTOR) continue;
                                this.accept(type, element2, o);
                            }
                        }
                        return o;
                    }

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                        String name = element.getSimpleName().toString();
                        if (element instanceof ExecutableElement) {
                            BeanPropertyData beanPropertyData = (BeanPropertyData)props.get(name);
                            if (beanPropertyData != null) {
                                beanPropertyData.getter = (ExecutableElement)element;
                            }
                        } else {
                            props.computeIfAbsent(name, propertyName -> {
                                BeanPropertyData beanPropertyData = new BeanPropertyData((String)propertyName);
                                beanPropertyData.declaringType = JavaClassElement.this;
                                beanPropertyData.type = JavaClassElement.this.mirrorToClassElement(element.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                                return beanPropertyData;
                            });
                        }
                    }
                }, null);
            } else {
                this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(this.visitorContext){

                    @Override
                    protected boolean isAcceptable(javax.lang.model.element.Element element) {
                        Set<Modifier> modifiers;
                        if (element.getKind() == ElementKind.FIELD) {
                            return true;
                        }
                        if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC)) {
                            ExecutableElement executableElement = (ExecutableElement)element;
                            String methodName = executableElement.getSimpleName().toString();
                            if (methodName.contains("$")) {
                                return false;
                            }
                            if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().isEmpty()) {
                                return true;
                            }
                            return NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1;
                        }
                        return false;
                    }

                    @Override
                    protected void accept(DeclaredType declaringType, javax.lang.model.element.Element element, Object o) {
                        if (element instanceof VariableElement) {
                            fields.put(element.getSimpleName().toString(), (VariableElement)element);
                            return;
                        }
                        ExecutableElement executableElement = (ExecutableElement)element;
                        String methodName = executableElement.getSimpleName().toString();
                        TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
                        if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().isEmpty()) {
                            TypeMirror typeMirror;
                            ClassElement setterParameterType;
                            ClassElement getterReturnType;
                            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                            TypeMirror returnType = executableElement.getReturnType();
                            if (returnType instanceof TypeVariable) {
                                TypeVariable tv = (TypeVariable)returnType;
                                String tvn = tv.toString();
                                ClassElement classElement = JavaClassElement.this.getTypeArguments().get(tvn);
                                getterReturnType = classElement != null ? classElement : JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            } else {
                                getterReturnType = JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            }
                            BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
                            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                            beanPropertyData.type = getterReturnType;
                            beanPropertyData.getter = executableElement;
                            if (beanPropertyData.setter != null && !(setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true)).getName().equals(getterReturnType.getName())) {
                                beanPropertyData.setter = null;
                            }
                        } else if (NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1) {
                            String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                            TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
                            ClassElement setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
                            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                            ClassElement propertyType = beanPropertyData.type;
                            if (propertyType != null) {
                                if (propertyType.getName().equals(setterParameterType.getName())) {
                                    beanPropertyData.setter = executableElement;
                                }
                            } else {
                                beanPropertyData.setter = executableElement;
                            }
                        }
                    }

                    private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
                        if (beanPropertyData.declaringType == null && !JavaClassElement.this.classElement.equals(declaringTypeElement)) {
                            beanPropertyData.declaringType = JavaClassElement.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                        }
                    }
                }, null);
            }
            if (!props.isEmpty()) {
                this.beanProperties = new ArrayList<PropertyElement>(props.size());
                for (Map.Entry entry : props.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    final BeanPropertyData value = (BeanPropertyData)entry.getValue();
                    final VariableElement fieldElement = (VariableElement)fields.get(propertyName);
                    if (value.getter == null) continue;
                    final AnnotationMetadata annotationMetadata = fieldElement != null ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata(fieldElement, value.getter) : this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.getter);
                    JavaPropertyElement propertyElement = new JavaPropertyElement((ClassElement)(value.declaringType == null ? this : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

                        @Override
                        public ClassElement getGenericType() {
                            TypeMirror propertyType = value.getter.getReturnType();
                            if (fieldElement != null) {
                                TypeMirror fieldType = fieldElement.asType();
                                if (JavaClassElement.this.visitorContext.getTypes().isAssignable(fieldType, propertyType)) {
                                    propertyType = fieldType;
                                }
                            }
                            Map<String, Map<String, TypeMirror>> declaredGenericInfo = JavaClassElement.this.getGenericTypeInfo();
                            return this.parameterizedClassElement(propertyType, JavaClassElement.this.visitorContext, declaredGenericInfo);
                        }

                        public Optional<String> getDocumentation() {
                            Elements elements = JavaClassElement.this.visitorContext.getElements();
                            String docComment = elements.getDocComment(value.getter);
                            return Optional.ofNullable(docComment);
                        }

                        public Optional<MethodElement> getWriteMethod() {
                            if (value.setter != null) {
                                return Optional.of(new JavaMethodElement(JavaClassElement.this, value.setter, JavaClassElement.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.setter), JavaClassElement.this.visitorContext));
                            }
                            return Optional.empty();
                        }

                        public Optional<MethodElement> getReadMethod() {
                            return Optional.of(new JavaMethodElement(JavaClassElement.this, value.getter, annotationMetadata, JavaClassElement.this.visitorContext));
                        }
                    };
                    this.beanProperties.add(propertyElement);
                }
                this.beanProperties = Collections.unmodifiableList(this.beanProperties);
            } else {
                this.beanProperties = Collections.emptyList();
            }
        }
        return Collections.unmodifiableList(this.beanProperties);
    }

    public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        Objects.requireNonNull(query, "Query cannot be null");
        ElementQuery.Result result = query.result();
        ElementKind kind = this.getElementKind(result.getElementType());
        ArrayList<JavaFieldElement> resultingElements = new ArrayList<JavaFieldElement>();
        ArrayList<? extends javax.lang.model.element.Element> enclosedElements = new ArrayList<javax.lang.model.element.Element>(this.getDeclaredEnclosedElements());
        boolean onlyDeclared = result.isOnlyDeclared();
        boolean onlyAbstract = result.isOnlyAbstract();
        boolean onlyConcrete = result.isOnlyConcrete();
        if (!onlyDeclared) {
            DeclaredType dt;
            TypeElement element;
            Elements elements = this.visitorContext.getElements();
            TypeMirror superclass = this.classElement.getSuperclass();
            while (superclass instanceof DeclaredType && !(element = (TypeElement)(dt = (DeclaredType)superclass).asElement()).getQualifiedName().toString().startsWith("java.lang.")) {
                List<? extends javax.lang.model.element.Element> superElements = element.getEnclosedElements();
                ArrayList<javax.lang.model.element.Element> elementsToAdd = new ArrayList<javax.lang.model.element.Element>(superElements.size());
                Iterator iterator = superElements.iterator();
                block6: while (iterator.hasNext()) {
                    javax.lang.model.element.Element superElement = (javax.lang.model.element.Element)iterator.next();
                    ElementKind elementKind = superElement.getKind();
                    if (elementKind != kind) continue;
                    for (javax.lang.model.element.Element element2 : enclosedElements) {
                        if (!elements.hides(element2, superElement) && (element2.getKind() != ElementKind.METHOD || superElement.getKind() != ElementKind.METHOD || !elements.overrides((ExecutableElement)element2, (ExecutableElement)superElement, this.classElement))) continue;
                        continue block6;
                    }
                    if (onlyAbstract && !superElement.getModifiers().contains((Object)Modifier.ABSTRACT) || onlyConcrete && superElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                    elementsToAdd.add(superElement);
                }
                enclosedElements.addAll(elementsToAdd);
                superclass = element.getSuperclass();
            }
            if (kind == ElementKind.METHOD) {
                Set<TypeElement> allInterfaces = this.visitorContext.getModelUtils().getAllInterfaces(this.classElement);
                ArrayList<javax.lang.model.element.Element> elementsToAdd = new ArrayList<javax.lang.model.element.Element>(allInterfaces.size());
                for (TypeElement itfe : allInterfaces) {
                    List<? extends javax.lang.model.element.Element> interfaceElements = itfe.getEnclosedElements();
                    block9: for (javax.lang.model.element.Element element3 : interfaceElements) {
                        if (element3.getKind() != ElementKind.METHOD) continue;
                        ExecutableElement ee = (ExecutableElement)element3;
                        if (onlyAbstract && ee.getModifiers().contains((Object)Modifier.DEFAULT) || onlyConcrete && !ee.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                        for (javax.lang.model.element.Element element4 : enclosedElements) {
                            if (element4.getKind() != ElementKind.METHOD || !elements.overrides((ExecutableElement)element4, ee, this.classElement)) continue;
                            continue block9;
                        }
                        elementsToAdd.add(element3);
                    }
                }
                enclosedElements.addAll(elementsToAdd);
                elementsToAdd.clear();
            }
        }
        boolean onlyAccessible = result.isOnlyAccessible();
        if (kind == ElementKind.METHOD) {
            if (onlyAbstract) {
                if (this.isInterface()) {
                    enclosedElements.removeIf(e -> e.getModifiers().contains((Object)Modifier.DEFAULT));
                } else {
                    enclosedElements.removeIf(e -> !e.getModifiers().contains((Object)Modifier.ABSTRACT));
                }
            } else if (onlyConcrete) {
                if (this.isInterface()) {
                    enclosedElements.removeIf(e -> !e.getModifiers().contains((Object)Modifier.DEFAULT));
                } else {
                    enclosedElements.removeIf(e -> e.getModifiers().contains((Object)Modifier.ABSTRACT));
                }
            }
        }
        List modifierPredicates = result.getModifierPredicates();
        List namePredicates = result.getNamePredicates();
        List annotationPredicates = result.getAnnotationPredicates();
        boolean hasNamePredicates = !namePredicates.isEmpty();
        boolean hasModifierPredicates = !modifierPredicates.isEmpty();
        boolean hasAnnotationPredicates = !annotationPredicates.isEmpty();
        block11: for (javax.lang.model.element.Element element : enclosedElements) {
            AbstractJavaElement element5;
            Object qualifiedName;
            String packageName;
            javax.lang.model.element.Element element6;
            ElementKind enclosedElementKind = element.getKind();
            if (enclosedElementKind != kind) continue;
            String string = element.getSimpleName().toString();
            if (onlyAccessible && (element.getModifiers().contains((Object)Modifier.PRIVATE) || string.startsWith("$") || (element6 = element.getEnclosingElement()) != this.classElement && this.visitorContext.getModelUtils().isPackagePrivate(element) && element6 instanceof TypeElement && !(packageName = NameUtils.getPackageName((String)(qualifiedName = ((TypeElement)element6).getQualifiedName()).toString())).equals(this.getPackageName()))) continue;
            if (hasModifierPredicates) {
                Set set = element.getModifiers().stream().map(m -> ElementModifier.valueOf((String)m.name())).collect(Collectors.toSet());
                qualifiedName = modifierPredicates.iterator();
                while (qualifiedName.hasNext()) {
                    Predicate modifierPredicate = (Predicate)qualifiedName.next();
                    if (modifierPredicate.test(set)) continue;
                    continue block11;
                }
            }
            if (hasNamePredicates) {
                for (Object namePredicate : namePredicates) {
                    if (namePredicate.test(string)) continue;
                    continue block11;
                }
            }
            AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(element);
            if (hasAnnotationPredicates) {
                Object namePredicate;
                namePredicate = annotationPredicates.iterator();
                while (namePredicate.hasNext()) {
                    Predicate annotationPredicate = (Predicate)namePredicate.next();
                    if (annotationPredicate.test(annotationMetadata)) continue;
                    continue block11;
                }
            }
            switch (enclosedElementKind) {
                case METHOD: {
                    element5 = this.visitorContext.getElementFactory().newMethodElement((ClassElement)this, (ExecutableElement)element, annotationMetadata, this.genericTypeInfo);
                    break;
                }
                case FIELD: {
                    element5 = this.visitorContext.getElementFactory().newFieldElement((ClassElement)this, (VariableElement)element, annotationMetadata);
                    break;
                }
                case CONSTRUCTOR: {
                    element5 = this.visitorContext.getElementFactory().newConstructorElement((ClassElement)this, (ExecutableElement)element, annotationMetadata);
                    break;
                }
                default: {
                    element5 = null;
                }
            }
            if (element5 == null) continue;
            List elementPredicates = result.getElementPredicates();
            if (!elementPredicates.isEmpty()) {
                for (Predicate elementPredicate : elementPredicates) {
                    if (elementPredicate.test(element5)) continue;
                    continue block11;
                }
            }
            resultingElements.add((JavaFieldElement)element5);
        }
        return Collections.unmodifiableList(resultingElements);
    }

    private List<? extends javax.lang.model.element.Element> getDeclaredEnclosedElements() {
        if (this.enclosedElements == null) {
            this.enclosedElements = this.classElement.getEnclosedElements();
        }
        return this.enclosedElements;
    }

    private <T extends Element> ElementKind getElementKind(Class<T> elementType) {
        if (elementType == MethodElement.class) {
            return ElementKind.METHOD;
        }
        if (elementType == FieldElement.class) {
            return ElementKind.FIELD;
        }
        if (elementType == ConstructorElement.class) {
            return ElementKind.CONSTRUCTOR;
        }
        throw new IllegalArgumentException("Unsupported element type for query: " + elementType);
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaClassElement(this.classElement, this.getAnnotationMetadata(), this.visitorContext, this.getGenericTypeInfo(), arrayDimensions);
    }

    @Override
    public String getName() {
        return JavaModelUtils.getClassName((TypeElement)this.classElement);
    }

    public boolean isAssignable(String type) {
        TypeElement otherElement = this.visitorContext.getElements().getTypeElement(type);
        if (otherElement != null) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(otherElement.asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    public boolean isAssignable(ClassElement type) {
        if (type.isPrimitive()) {
            return this.isAssignable(type.getName());
        }
        Object nativeType = type.getNativeType();
        if (nativeType instanceof TypeElement) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(((TypeElement)nativeType).asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        ModelUtils modelUtils = this.visitorContext.getModelUtils();
        ExecutableElement method = modelUtils.staticCreatorFor(this.classElement, annotationUtils);
        if (method == null) {
            if (this.isInner() && !this.isStatic()) {
                return Optional.empty();
            }
            method = modelUtils.concreteConstructorFor(this.classElement, annotationUtils);
        }
        return this.createMethodElement(annotationUtils, method);
    }

    public Optional<MethodElement> getDefaultConstructor() {
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        ModelUtils modelUtils = this.visitorContext.getModelUtils();
        ExecutableElement method = modelUtils.defaultStaticCreatorFor(this.classElement, annotationUtils);
        if (method == null) {
            if (this.isInner() && !this.isStatic()) {
                return Optional.empty();
            }
            method = modelUtils.defaultConstructorFor(this.classElement);
        }
        return this.createMethodElement(annotationUtils, method);
    }

    private Optional<MethodElement> createMethodElement(AnnotationUtils annotationUtils, ExecutableElement method) {
        return Optional.ofNullable(method).map(executableElement -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)executableElement);
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                return new JavaConstructorElement(this, (ExecutableElement)executableElement, annotationMetadata, this.visitorContext);
            }
            return new JavaMethodElement(this, (ExecutableElement)executableElement, annotationMetadata, this.visitorContext);
        });
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        List<? extends TypeParameterElement> typeParameters = this.classElement.getTypeParameters();
        Iterator<? extends TypeParameterElement> tpi = typeParameters.iterator();
        LinkedHashMap<String, ClassElement> map = new LinkedHashMap<String, ClassElement>();
        while (tpi.hasNext()) {
            TypeParameterElement tpe = tpi.next();
            ClassElement classElement = this.mirrorToClassElement(tpe.asType(), this.visitorContext, this.genericTypeInfo, this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments());
            map.put(tpe.toString(), classElement);
        }
        return Collections.unmodifiableMap(map);
    }

    @NonNull
    public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        Map<String, Map<String, TypeMirror>> info = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement);
        LinkedHashMap<String, Map<String, ClassElement>> result = new LinkedHashMap<String, Map<String, ClassElement>>(info.size());
        info.forEach((name, generics) -> {
            LinkedHashMap resolved = new LinkedHashMap(generics.size());
            generics.forEach((variable, mirror) -> {
                ClassElement classElement = this.mirrorToClassElement((TypeMirror)mirror, this.visitorContext, info, this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments());
                resolved.put(variable, classElement);
            });
            result.put((String)name, resolved);
        });
        Map<String, ClassElement> typeArguments = this.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            result.put(this.getName(), typeArguments);
        }
        return result;
    }

    Map<String, Map<String, TypeMirror>> getGenericTypeInfo() {
        if (this.genericTypeInfo == null) {
            this.genericTypeInfo = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement);
        }
        return this.genericTypeInfo;
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

