/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

@Internal
public class JavaMethodElement
extends AbstractJavaElement
implements MethodElement {
    private final ExecutableElement executableElement;
    private final JavaVisitorContext visitorContext;
    private final JavaClassElement declaringClass;

    public JavaMethodElement(JavaClassElement declaringClass, ExecutableElement executableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(executableElement, annotationMetadata, visitorContext);
        this.executableElement = executableElement;
        this.visitorContext = visitorContext;
        this.declaringClass = declaringClass;
    }

    @NonNull
    public ClassElement getGenericReturnType() {
        return this.returnType(this.declaringClass.getGenericTypeInfo());
    }

    @NonNull
    public ClassElement getReturnType() {
        return this.returnType(Collections.emptyMap());
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.visitorContext.getElements().getDocComment(this.executableElement));
    }

    public ParameterElement[] getParameters() {
        List<? extends VariableElement> parameters = this.executableElement.getParameters();
        ArrayList<JavaParameterElement> elts = new ArrayList<JavaParameterElement>(parameters.size());
        Iterator<? extends VariableElement> i = parameters.iterator();
        while (i.hasNext()) {
            VariableElement variableElement = i.next();
            if (!i.hasNext() && this.isSuspend(variableElement)) continue;
            AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(variableElement);
            if (annotationMetadata.hasDeclaredAnnotation("org.jetbrains.annotations.Nullable")) {
                annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)"javax.annotation.Nullable", Collections.emptyMap());
            }
            elts.add(new JavaParameterElement(this.declaringClass, variableElement, annotationMetadata, this.visitorContext));
        }
        return elts.toArray(new ParameterElement[elts.size()]);
    }

    public ClassElement getDeclaringType() {
        Element enclosingElement = this.executableElement.getEnclosingElement();
        if (enclosingElement instanceof TypeElement) {
            TypeElement te = (TypeElement)enclosingElement;
            if (this.declaringClass.getName().equals(te.getQualifiedName().toString())) {
                return this.declaringClass;
            }
            return new JavaClassElement(te, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(te), this.visitorContext, this.declaringClass.getGenericTypeInfo());
        }
        return this.declaringClass;
    }

    public ClassElement getOwningType() {
        return this.declaringClass;
    }

    private ClassElement returnType(Map<String, Map<String, TypeMirror>> info) {
        VariableElement varElement = (VariableElement)CollectionUtils.last(this.executableElement.getParameters());
        if (this.isSuspend(varElement)) {
            DeclaredType dType = (DeclaredType)varElement.asType();
            WildcardType wType = (WildcardType)dType.getTypeArguments().iterator().next();
            TypeMirror tm = wType.getSuperBound();
            if (tm instanceof DeclaredType && JavaMethodElement.sameType("kotlin.Unit", (DeclaredType)tm)) {
                return PrimitiveElement.VOID;
            }
            return this.mirrorToClassElement(tm, this.visitorContext, info);
        }
        return this.mirrorToClassElement(this.executableElement.getReturnType(), this.visitorContext, info);
    }

    private static boolean sameType(String type, DeclaredType dt) {
        Element elt = dt.asElement();
        return elt instanceof TypeElement && type.equals(((TypeElement)elt).getQualifiedName().toString());
    }

    private boolean isSuspend(VariableElement ve) {
        if (ve != null && ve.asType() instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)ve.asType();
            return JavaMethodElement.sameType("kotlin.coroutines.Continuation", dt);
        }
        return false;
    }
}

