/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.sun.source.util.JavacTask;
import io.micronaut.annotation.processing.AggregatingTypeElementVisitorProcessor;
import io.micronaut.annotation.processing.BeanDefinitionInjectProcessor;
import io.micronaut.annotation.processing.PackageConfigurationInjectProcessor;
import io.micronaut.annotation.processing.TypeElementVisitorProcessor;
import io.micronaut.annotation.processing.test.InMemoryJavaFileManager;
import io.micronaut.annotation.processing.test.JavaFileObjects;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import spock.util.environment.Jvm;

public class JavaParser
implements Closeable {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final InMemoryJavaFileManager fileManager;
    private final DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector();
    private JavacTask lastTask;

    public JavaParser() {
        this.fileManager = new InMemoryJavaFileManager(this.compiler.getStandardFileManager(this.diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public JavaFileManager getFileManager() {
        return this.fileManager;
    }

    public Filer getFiler() {
        return this.fileManager;
    }

    public ProcessingEnvironment getProcessingEnv() {
        return new ProcessingEnvironment(){

            @Override
            public Map<String, String> getOptions() {
                return Collections.emptyMap();
            }

            @Override
            public Messager getMessager() {
                return new Messager(){

                    @Override
                    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
                    }

                    @Override
                    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
                    }

                    @Override
                    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
                    }

                    @Override
                    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
                    }
                };
            }

            @Override
            public Filer getFiler() {
                return JavaParser.this.fileManager;
            }

            @Override
            public Elements getElementUtils() {
                if (JavaParser.this.lastTask == null) {
                    throw new IllegalStateException("Call parse first");
                }
                return JavaParser.this.lastTask.getElements();
            }

            @Override
            public Types getTypeUtils() {
                if (JavaParser.this.lastTask == null) {
                    throw new IllegalStateException("Call parse first");
                }
                return JavaParser.this.lastTask.getTypes();
            }

            @Override
            public SourceVersion getSourceVersion() {
                return SourceVersion.RELEASE_17;
            }

            @Override
            public Locale getLocale() {
                return Locale.getDefault();
            }
        };
    }

    public Iterable<? extends Element> parseLines(String className, String ... lines) {
        return this.parse(JavaFileObjects.forSourceLines(className.replace('.', File.separatorChar) + ".java", lines));
    }

    public Iterable<? extends Element> parse(JavaFileObject ... sources) {
        this.lastTask = this.getJavacTask(sources);
        try {
            this.lastTask.parse();
            Iterable<? extends Element> iterable = this.lastTask.analyze();
            return iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                System.out.println(diagnostic);
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                throw new RuntimeException(diagnostic.toString());
            }
        }
    }

    public Optional<JavacTask> getLastTask() {
        return Optional.ofNullable(this.lastTask);
    }

    public JavacTask getJavacTask(JavaFileObject ... sources) {
        Set<String> options = this.getCompilerOptions();
        this.lastTask = (JavacTask)this.compiler.getTask(null, this.fileManager, this.diagnosticCollector, options, Collections.emptySet(), Arrays.asList(sources));
        return this.lastTask;
    }

    public Iterable<? extends JavaFileObject> generate(String className, String code) {
        return this.generate(JavaFileObjects.forSourceString(className, code));
    }

    @Nullable
    public Reader readGenerated(@NonNull String filePath, String className, String code) throws IOException {
        String computedPath = this.fileManager.getMetaInfPath(filePath);
        Iterable<? extends JavaFileObject> generatedFiles = this.generate(JavaFileObjects.forSourceString(className, code));
        for (JavaFileObject javaFileObject : generatedFiles) {
            if (!javaFileObject.getName().equals(computedPath)) continue;
            return javaFileObject.openReader(true);
        }
        return null;
    }

    public Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        JavacTask task = this.getJavacTask(sources);
        try {
            List<Processor> processors = this.getAnnotationProcessors();
            task.setProcessors(processors);
            task.generate();
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            StringBuilder error = new StringBuilder();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                error.append(diagnostic);
            }
            if (error.length() > 0) {
                throw new RuntimeException(error.toString());
            }
            return this.fileManager.getOutputFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getCompilerOptions() {
        Jvm jvm = Jvm.getCurrent();
        Set options = jvm.isJava15Compatible() && !jvm.isJava17Compatible() ? CollectionUtils.setOf((Object[])new String[]{"--enable-preview", "-source", jvm.getJavaSpecificationVersion()}) : Collections.emptySet();
        return options;
    }

    @NonNull
    protected List<Processor> getAnnotationProcessors() {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        processors.add((Processor)this.getTypeElementVisitorProcessor());
        processors.add((Processor)this.getAggregatingTypeElementVisitorProcessor());
        processors.add((Processor)new PackageConfigurationInjectProcessor());
        processors.add((Processor)this.getBeanDefinitionInjectProcessor());
        return processors;
    }

    @NonNull
    protected BeanDefinitionInjectProcessor getBeanDefinitionInjectProcessor() {
        return new BeanDefinitionInjectProcessor();
    }

    @NonNull
    protected TypeElementVisitorProcessor getTypeElementVisitorProcessor() {
        return new TypeElementVisitorProcessor();
    }

    @NonNull
    protected AggregatingTypeElementVisitorProcessor getAggregatingTypeElementVisitorProcessor() {
        return new AggregatingTypeElementVisitorProcessor();
    }

    @Override
    public void close() {
        if (this.fileManager != null) {
            try {
                this.fileManager.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

