/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import io.micronaut.annotation.processing.AggregatingTypeElementVisitorProcessor;
import io.micronaut.annotation.processing.BeanDefinitionInjectProcessor;
import io.micronaut.annotation.processing.PackageConfigurationInjectProcessor;
import io.micronaut.annotation.processing.ServiceDescriptionProcessor;
import io.micronaut.annotation.processing.TypeElementVisitorProcessor;
import io.micronaut.annotation.processing.test.InMemoryJavaFileManager;
import io.micronaut.annotation.processing.test.JavaFileObjects;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import spock.util.environment.Jvm;

public class JavaParser
implements Closeable {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final InMemoryJavaFileManager fileManager;
    private final DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector();
    private final Context context;

    public JavaParser() {
        this.fileManager = new InMemoryJavaFileManager(this.compiler.getStandardFileManager(this.diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        this.context = new Context();
    }

    public Iterable<? extends Element> parseLines(String className, String ... lines) {
        return this.parse(JavaFileObjects.forSourceLines(className.replace('.', File.separatorChar) + ".java", lines));
    }

    public Iterable<? extends Element> parse(JavaFileObject ... sources) {
        Set<String> options = this.getCompilerOptions();
        JavacTask task = ((JavacTool)this.compiler).getTask(null, this.fileManager, this.diagnosticCollector, options, Collections.emptySet(), Arrays.asList(sources), this.context);
        try {
            task.parse();
            Iterable<? extends Element> iterable = task.analyze();
            return iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                System.out.println(diagnostic);
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                throw new RuntimeException(diagnostic.toString());
            }
        }
    }

    public Iterable<? extends JavaFileObject> generate(String className, String code) {
        return this.generate(JavaFileObjects.forSourceString(className, code));
    }

    @Nullable
    public Reader readGenerated(@NonNull String filePath, String className, String code) throws IOException {
        String computedPath = this.fileManager.getMetaInfPath(filePath);
        Iterable<? extends JavaFileObject> generatedFiles = this.generate(JavaFileObjects.forSourceString(className, code));
        for (JavaFileObject javaFileObject : generatedFiles) {
            if (!javaFileObject.getName().equals(computedPath)) continue;
            return javaFileObject.openReader(true);
        }
        return null;
    }

    public Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        Set<String> options = this.getCompilerOptions();
        JavacTask task = ((JavacTool)this.compiler).getTask(null, this.fileManager, this.diagnosticCollector, options, Collections.emptySet(), Arrays.asList(sources), this.context);
        try {
            List<Processor> processors = this.getAnnotationProcessors();
            task.setProcessors(processors);
            task.generate();
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            StringBuilder error = new StringBuilder();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                error.append(diagnostic);
            }
            if (error.length() > 0) {
                throw new RuntimeException(error.toString());
            }
            return this.fileManager.getOutputFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getCompilerOptions() {
        Set options = Jvm.getCurrent().isJava15Compatible() ? CollectionUtils.setOf((Object[])new String[]{"--enable-preview", "-source", "15"}) : Collections.emptySet();
        return options;
    }

    @NonNull
    protected List<Processor> getAnnotationProcessors() {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        processors.add((Processor)this.getTypeElementVisitorProcessor());
        processors.add((Processor)this.getAggregatingTypeElementVisitorProcessor());
        processors.add((Processor)new PackageConfigurationInjectProcessor());
        processors.add((Processor)this.getBeanDefinitionInjectProcessor());
        processors.add((Processor)new ServiceDescriptionProcessor());
        return processors;
    }

    @NonNull
    protected BeanDefinitionInjectProcessor getBeanDefinitionInjectProcessor() {
        return new BeanDefinitionInjectProcessor();
    }

    @NonNull
    protected TypeElementVisitorProcessor getTypeElementVisitorProcessor() {
        return new TypeElementVisitorProcessor();
    }

    @NonNull
    protected AggregatingTypeElementVisitorProcessor getAggregatingTypeElementVisitorProcessor() {
        return new AggregatingTypeElementVisitorProcessor();
    }

    @Override
    public void close() {
        if (this.compiler != null) {
            try {
                ((com.sun.tools.javac.main.JavaCompiler)((Object)this.compiler)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileManager != null) {
            try {
                this.fileManager.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

