/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

final class InMemoryJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<URI, JavaFileObject> inMemoryFileObjects = new LinkedHashMap<URI, JavaFileObject>();

    InMemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    private static URI uriForFileObject(JavaFileManager.Location location, String packageName, String relativeName) {
        StringBuilder uri = new StringBuilder("mem:///").append(location.getName()).append('/');
        if (!packageName.isEmpty()) {
            uri.append(packageName.replace('.', '/')).append('/');
        }
        uri.append(relativeName);
        return URI.create(uri.toString());
    }

    private static URI uriForJavaFileObject(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        return URI.create("mem:///" + location.getName() + '/' + className.replace('.', '/') + kind.extension);
    }

    public String getMetaInfPath(String name) {
        return InMemoryJavaFileManager.uriForFileObject(StandardLocation.CLASS_OUTPUT, "META-INF", name).getPath();
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (location.isOutputLocation()) {
            URI uri = InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName);
            return this.inMemoryFileObjects.computeIfPresent(uri, new BiFunction<URI, JavaFileObject, JavaFileObject>(){

                @Override
                public JavaFileObject apply(URI uri, JavaFileObject javaFileObject) {
                    return new InMemoryJavaFileObject(uri);
                }
            });
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location.isOutputLocation()) {
            URI uri = InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind);
            return this.inMemoryFileObjects.computeIfPresent(uri, new BiFunction<URI, JavaFileObject, JavaFileObject>(){

                @Override
                public JavaFileObject apply(URI uri, JavaFileObject javaFileObject) {
                    return new InMemoryJavaFileObject(uri);
                }
            });
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName);
        return this.inMemoryFileObjects.computeIfAbsent(uri, new Function<URI, JavaFileObject>(){

            @Override
            public JavaFileObject apply(URI uri) {
                return new InMemoryJavaFileObject(uri);
            }
        });
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind);
        return this.inMemoryFileObjects.computeIfAbsent(uri, new Function<URI, JavaFileObject>(){

            @Override
            public JavaFileObject apply(URI uri) {
                return new InMemoryJavaFileObject(uri);
            }
        });
    }

    Iterable<JavaFileObject> getOutputFiles() {
        return Collections.unmodifiableCollection(this.inMemoryFileObjects.values());
    }

    static JavaFileObject.Kind deduceKind(URI uri) {
        String path = uri.getPath();
        for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (!path.endsWith(kind.extension)) continue;
            return kind;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static final class InMemoryJavaFileObject
    extends SimpleJavaFileObject
    implements JavaFileObject {
        private long lastModified = 0L;
        private Optional<byte[]> data = Optional.empty();

        InMemoryJavaFileObject(URI uri) {
            super(uri, InMemoryJavaFileManager.deduceKind(uri));
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.data.isPresent()) {
                return new ByteArrayInputStream(this.data.get());
            }
            throw new FileNotFoundException();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    byte[] bytes = this.toByteArray();
                    data = Optional.of(bytes);
                    super.close();
                }
            };
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new InputStreamReader(this.openInputStream(), StandardCharsets.UTF_8);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return new String(this.data.get(), StandardCharsets.UTF_8);
            }
            throw new FileNotFoundException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    super.close();
                    byte[] bytes = this.toString().getBytes(StandardCharsets.UTF_8);
                    data = Optional.of(bytes);
                    lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public boolean delete() {
            this.data = Optional.empty();
            this.lastModified = 0L;
            return true;
        }

        @Override
        public String toString() {
            return "InMemoryJavaFileObject{uri=" + this.uri + ", kind=" + (Object)((Object)this.kind) + '}';
        }
    }
}

