/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.google.testing.compile.JavaFileObjects;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import io.micronaut.annotation.processing.BeanDefinitionInjectProcessor;
import io.micronaut.annotation.processing.PackageConfigurationInjectProcessor;
import io.micronaut.annotation.processing.TypeElementVisitorProcessor;
import io.micronaut.annotation.processing.test.InMemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class JavaParser {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final InMemoryJavaFileManager fileManager;
    private final DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector();
    private final Context context;

    public JavaParser() {
        this.fileManager = new InMemoryJavaFileManager(this.compiler.getStandardFileManager(this.diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        this.context = new Context();
    }

    public Iterable<? extends Element> parseLines(String className, String ... lines) {
        return this.parse(JavaFileObjects.forSourceLines((String)(className.replace('.', File.separatorChar) + ".java"), (String[])lines));
    }

    public Iterable<? extends Element> parse(JavaFileObject ... sources) {
        JavacTask task = ((JavacTool)this.compiler).getTask(null, this.fileManager, this.diagnosticCollector, Collections.emptySet(), Collections.emptySet(), Arrays.asList(sources), this.context);
        try {
            task.parse();
            Iterable<? extends Element> iterable = task.analyze();
            return iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                System.out.println(diagnostic);
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                throw new RuntimeException(diagnostic.toString());
            }
        }
    }

    public Iterable<? extends JavaFileObject> generate(String className, String code) {
        return this.generate(JavaFileObjects.forSourceString((String)className, (String)code));
    }

    @Nullable
    public Reader readGenerated(@Nonnull String filePath, String className, String code) throws IOException {
        String computedPath = this.fileManager.getMetaInfPath(filePath);
        Iterable<? extends JavaFileObject> generatedFiles = this.generate(JavaFileObjects.forSourceString((String)className, (String)code));
        for (JavaFileObject javaFileObject : generatedFiles) {
            if (!javaFileObject.getName().equals(computedPath)) continue;
            return javaFileObject.openReader(true);
        }
        return null;
    }

    public Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        JavacTask task = ((JavacTool)this.compiler).getTask(null, this.fileManager, this.diagnosticCollector, Collections.emptySet(), Collections.emptySet(), Arrays.asList(sources), this.context);
        try {
            List<Processor> processors = this.getAnnotationProcessors();
            task.setProcessors(processors);
            task.generate();
            List<Diagnostic<JavaFileObject>> diagnostics = this.diagnosticCollector.getDiagnostics();
            StringBuilder error = new StringBuilder();
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                error.append(diagnostic);
            }
            if (error.length() > 0) {
                throw new RuntimeException(error.toString());
            }
            return this.fileManager.getOutputFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    protected List<Processor> getAnnotationProcessors() {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        processors.add((Processor)this.getTypeElementVisitorProcessor());
        processors.add((Processor)new PackageConfigurationInjectProcessor());
        processors.add((Processor)this.getBeanDefinitionInjectProcessor());
        return processors;
    }

    @Nonnull
    protected BeanDefinitionInjectProcessor getBeanDefinitionInjectProcessor() {
        return new BeanDefinitionInjectProcessor();
    }

    @Nonnull
    protected TypeElementVisitorProcessor getTypeElementVisitorProcessor() {
        return new TypeElementVisitorProcessor();
    }
}

