/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.testing.compile.JavaFileObjects;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import io.micronaut.annotation.processing.BeanDefinitionInjectProcessor;
import io.micronaut.annotation.processing.PackageConfigurationInjectProcessor;
import io.micronaut.annotation.processing.TypeElementVisitorProcessor;
import io.micronaut.annotation.processing.test.InMemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public final class Parser {
    private static final TreeScanner<Boolean, Boolean> HAS_ERRONEOUS_NODE = new TreeScanner<Boolean, Boolean>(){

        @Override
        public Boolean visitErroneous(ErroneousTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean scan(Iterable<? extends Tree> nodes, Boolean p) {
            for (Tree node : (Iterable)MoreObjects.firstNonNull(nodes, (Object)ImmutableList.of())) {
                if (!Parser.isTrue(this.scan(node, p))) continue;
                return true;
            }
            return p;
        }

        @Override
        public Boolean scan(Tree tree, Boolean p) {
            return Parser.isTrue(p) ? p : (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return Parser.isTrue(r1) || Parser.isTrue(r2);
        }
    };

    public static Iterable<? extends Element> parseLines(String className, String ... lines) {
        return Parser.parse(JavaFileObjects.forSourceLines((String)(className.replace('.', File.separatorChar) + ".java"), (String[])lines));
    }

    public static Iterable<? extends JavaFileObject> generate(String className, String code) {
        return Parser.generate(JavaFileObjects.forSourceString((String)className, (String)code));
    }

    public static Iterable<? extends Element> parse(JavaFileObject ... sources) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(compiler.getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        Context context = new Context();
        JavacTask task = ((JavacTool)compiler).getTask(null, fileManager, diagnosticCollector, (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of(), Arrays.asList(sources), context);
        try {
            task.parse();
            Iterable<? extends Element> iterable = task.analyze();
            return iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            List diagnostics = diagnosticCollector.getDiagnostics();
            for (Diagnostic diagnostic : diagnostics) {
                System.out.println(diagnostic);
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                throw new RuntimeException(diagnostic.toString());
            }
        }
    }

    public static Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(compiler.getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        Context context = new Context();
        JavacTask task = ((JavacTool)compiler).getTask(null, fileManager, diagnosticCollector, (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of(), Arrays.asList(sources), context);
        try {
            ArrayList<Object> processors = new ArrayList<Object>();
            processors.add(new TypeElementVisitorProcessor());
            processors.add(new PackageConfigurationInjectProcessor());
            processors.add(new BeanDefinitionInjectProcessor());
            task.setProcessors(processors);
            task.generate();
            List diagnostics = diagnosticCollector.getDiagnostics();
            StringBuilder error = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                error.append(diagnostic);
            }
            if (error.length() > 0) {
                throw new RuntimeException(error.toString());
            }
            return fileManager.getOutputFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean foundParseErrors(Iterable<? extends CompilationUnitTree> parsedCompilationUnits, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return diagnostics.stream().map(Diagnostic::getKind).anyMatch(Predicate.isEqual((Object)Diagnostic.Kind.ERROR)) || Iterables.any(parsedCompilationUnits, Parser::hasErrorNode);
    }

    public static boolean hasErrorNode(Tree tree) {
        return Parser.isTrue(HAS_ERRONEOUS_NODE.scan(tree, (Boolean)false));
    }

    private static boolean isTrue(Boolean p) {
        return Boolean.TRUE.equals(p);
    }

    private static ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> sortDiagnosticsByKind(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return Multimaps.index(diagnostics, input -> input.getKind());
    }

    public static final class ParseResult {
        private final ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics;
        private final ImmutableList<? extends CompilationUnitTree> compilationUnits;
        private final Trees trees;

        ParseResult(ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<? extends CompilationUnitTree> compilationUnits, Trees trees) {
            this.trees = trees;
            this.compilationUnits = ImmutableList.copyOf(compilationUnits);
            this.diagnostics = diagnostics;
        }

        public ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnosticsByKind() {
            return this.diagnostics;
        }

        public Iterable<? extends CompilationUnitTree> compilationUnits() {
            return this.compilationUnits;
        }

        public Trees trees() {
            return this.trees;
        }
    }
}

