/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpStatus;
import io.micronaut.http.exceptions.HttpStatusException;
import java.net.URI;
import java.util.Set;

public final class NotAllowedException
extends HttpStatusException {
    private final String requestMethod;
    private final URI uri;
    private final Set<String> allowedMethods;

    public NotAllowedException(String requestMethod, URI uri, Set<String> allowedMethods) {
        super(HttpStatus.METHOD_NOT_ALLOWED, "Method [" + requestMethod + "] not allowed for URI [" + String.valueOf(uri) + "]. Allowed methods: " + String.valueOf(allowedMethods));
        this.requestMethod = requestMethod;
        this.uri = uri;
        this.allowedMethods = allowedMethods;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }
}

