/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ProxyHeaderParser {
    private static final String FOR = "for";
    private static final String BY = "by";
    private static final String HOST = "host";
    private static final String PROTO = "proto";
    private static final String PARAM_DELIMITER = ";";
    private static final String ELEMENT_DELIMITER = ",";
    private static final String PAIR_DELIMITER = "=";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    private List<String> forwardedFor = new ArrayList<String>();
    private String forwardedBy = null;
    private String forwardedHost = null;
    private String forwardedProto = null;
    private Integer forwardedPort = null;

    public ProxyHeaderParser(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (headers.contains("Forwarded")) {
            for (String header : headers.getAll((CharSequence)"Forwarded")) {
                header = StringUtils.trimToNull((String)header);
                while (StringUtils.isNotEmpty((CharSequence)header)) {
                    String parameter;
                    int parameterEnd = header.indexOf(PARAM_DELIMITER);
                    if (parameterEnd > -1) {
                        parameter = header.substring(0, parameterEnd);
                        header = header.substring(parameterEnd + 1);
                    } else {
                        parameter = header;
                        header = "";
                    }
                    int firstPair = parameter.indexOf(PAIR_DELIMITER);
                    String pairName = parameter.substring(0, firstPair);
                    if (pairName.equalsIgnoreCase(FOR)) {
                        this.processFor(parameter);
                        continue;
                    }
                    if (pairName.equalsIgnoreCase(BY)) {
                        this.processBy(parameter);
                        continue;
                    }
                    if (pairName.equalsIgnoreCase(PROTO)) {
                        this.processProto(parameter);
                        continue;
                    }
                    if (!pairName.equalsIgnoreCase(HOST)) continue;
                    this.processHost(parameter);
                }
            }
        } else {
            this.forwardedProto = StringUtils.trimToNull((String)((String)headers.get((CharSequence)X_FORWARDED_PROTO)));
            this.forwardedHost = (String)headers.get((CharSequence)X_FORWARDED_HOST);
            try {
                if (this.forwardedHost != null && this.forwardedHost.contains(":")) {
                    String[] parts = this.forwardedHost.split(":");
                    this.forwardedHost = parts[0];
                    this.forwardedPort = Integer.valueOf(parts[1]);
                } else {
                    String portHeader = (String)headers.get((CharSequence)X_FORWARDED_PORT);
                    if (portHeader != null) {
                        this.forwardedPort = Integer.valueOf(portHeader);
                    }
                }
            }
            catch (NumberFormatException portHeader) {
                // empty catch block
            }
            String forwardedForHeader = (String)headers.get((CharSequence)X_FORWARDED_FOR);
            if (forwardedForHeader != null) {
                this.forwardedFor = Arrays.stream(forwardedForHeader.split(ELEMENT_DELIMITER)).map(String::trim).collect(Collectors.toList());
            }
        }
    }

    @Nonnull
    public List<String> getFor() {
        return this.forwardedFor;
    }

    public String getBy() {
        return this.forwardedBy;
    }

    public String getHost() {
        return this.forwardedHost;
    }

    public String getScheme() {
        return this.forwardedProto;
    }

    public Integer getPort() {
        return this.forwardedPort;
    }

    private void processFor(String parameter) {
        this.forwardedFor.addAll(Arrays.stream(parameter.split(ELEMENT_DELIMITER)).map(pair -> pair.split(PAIR_DELIMITER)).filter(pair -> ((String[])pair).length == 2).map(pair -> pair[1]).map(String::trim).map(value -> {
            if (value.startsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }).collect(Collectors.toList()));
    }

    private void processBy(String parameter) {
        this.forwardedBy = this.processSimpleParameter(parameter);
    }

    private void processProto(String parameter) {
        this.forwardedProto = this.processSimpleParameter(parameter);
    }

    private void processHost(String parameter) {
        this.forwardedHost = this.processSimpleParameter(parameter);
    }

    private String processSimpleParameter(String parameter) {
        String[] pair = parameter.split(PAIR_DELIMITER);
        if (pair.length == 2) {
            String value = pair[1];
            if (value.startsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }
}

