/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class NettyByteBody
implements ByteBody,
InternalByteBody {
    protected static final Logger LOG = LoggerFactory.getLogger(NettyByteBufferFactory.class);

    public static Flux<ByteBuf> toByteBufs(ByteBody body) {
        if (body instanceof NettyByteBody) {
            NettyByteBody net = (NettyByteBody)body;
            return net.toByteBufPublisher();
        }
        return Flux.from((Publisher)body.toByteArrayPublisher()).map(Unpooled::wrappedBuffer);
    }

    @NonNull
    public Publisher<byte[]> toByteArrayPublisher() {
        return this.toByteBufPublisher().map(bb -> {
            try {
                byte[] byArray = ByteBufUtil.getBytes((ByteBuf)bb);
                return byArray;
            }
            finally {
                bb.release();
            }
        });
    }

    @NonNull
    public Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return this.toByteBufPublisher().map(arg_0 -> ((NettyByteBufferFactory)NettyByteBufferFactory.DEFAULT).wrap(arg_0));
    }

    @NonNull
    public abstract ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow();

    abstract Flux<ByteBuf> toByteBufPublisher();

    static void failClaim() {
        throw new IllegalStateException("Request body has already been claimed: Two conflicting sites are trying to access the request body. If this is intentional, the first user must ByteBody#split the body. To find out where the body was claimed, turn on TRACE logging for io.micronaut.http.netty.body.NettyByteBody.");
    }
}

