/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.KQueueAvailabilityCondition;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

@Singleton
@Internal
@Requires(classes={KQueue.class}, condition=KQueueAvailabilityCondition.class)
@Named(value="native")
@BootstrapContextCompatible
public class KQueueEventLoopGroupFactory
implements EventLoopGroupFactory {
    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return KQueueServerSocketChannel.class;
    }

    @Override
    public Class<? extends ServerDomainSocketChannel> domainServerSocketChannelClass() throws UnsupportedOperationException {
        try {
            return KQueueServerDomainSocketChannel.class;
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public KQueueServerSocketChannel serverSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new KQueueServerSocketChannel();
    }

    @Override
    public ServerChannel domainServerSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        try {
            return new KQueueServerDomainSocketChannel();
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return KQueueSocketChannel.class;
    }

    @Override
    public SocketChannel clientSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new KQueueSocketChannel();
    }

    private static KQueueEventLoopGroup withIoRatio(KQueueEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> KQueueServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> KQueueSocketChannel.class;
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> KQueueServerDomainSocketChannel.class;
            case NettyChannelType.DATAGRAM_SOCKET -> KQueueDatagramChannel.class;
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new KQueueServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new KQueueSocketChannel();
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new KQueueServerDomainSocketChannel();
            case NettyChannelType.DATAGRAM_SOCKET -> new KQueueDatagramChannel();
        };
    }

    @Override
    public Channel channelInstance(NettyChannelType type, EventLoopGroupConfiguration configuration, int fd) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new KQueueServerSocketChannel(fd);
            case NettyChannelType.CLIENT_SOCKET -> new KQueueSocketChannel(fd);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new KQueueServerDomainSocketChannel(fd);
            case NettyChannelType.DATAGRAM_SOCKET -> new KQueueDatagramChannel(fd);
        };
    }
}

